/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.ByteChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.mortbay.io.EndPoint;
import org.mortbay.io.nio.ChannelEndPoint;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpException;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.nio.AbstractNIOConnector;
import org.mortbay.log.Log;

public class BlockingChannelConnector
extends AbstractNIOConnector {
    private transient ServerSocketChannel _acceptChannel;

    public Object getConnection() {
        return this._acceptChannel;
    }

    public void open() throws IOException {
        this._acceptChannel = ServerSocketChannel.open();
        this._acceptChannel.configureBlocking(true);
        InetSocketAddress addr = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
        this._acceptChannel.socket().bind(addr, this.getAcceptQueueSize());
    }

    public void close() throws IOException {
        if (this._acceptChannel != null) {
            this._acceptChannel.close();
        }
        this._acceptChannel = null;
    }

    public void accept(int acceptorID) throws IOException, InterruptedException {
        SocketChannel channel = this._acceptChannel.accept();
        channel.configureBlocking(true);
        Socket socket = channel.socket();
        this.configure(socket);
        Connection connection = new Connection(channel);
        connection.dispatch();
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        Connection connection = (Connection)endpoint;
        if (connection._sotimeout != this._maxIdleTime) {
            connection._sotimeout = this._maxIdleTime;
            ((SocketChannel)endpoint.getTransport()).socket().setSoTimeout(this._maxIdleTime);
        }
        super.customize(endpoint, request);
        this.configure(((SocketChannel)endpoint.getTransport()).socket());
    }

    public int getLocalPort() {
        if (this._acceptChannel == null || !this._acceptChannel.isOpen()) {
            return -1;
        }
        return this._acceptChannel.socket().getLocalPort();
    }

    private class Connection
    extends ChannelEndPoint
    implements Runnable {
        boolean _dispatched;
        HttpConnection _connection;
        int _sotimeout;

        Connection(ByteChannel channel) {
            super(channel);
            this._dispatched = false;
            this._connection = new HttpConnection((Connector)BlockingChannelConnector.this, (EndPoint)this, BlockingChannelConnector.this.getServer());
        }

        void dispatch() throws IOException {
            if (!BlockingChannelConnector.this.getThreadPool().dispatch((Runnable)this)) {
                Log.warn((String)"dispatch failed for  {}", (Object)this._connection);
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                BlockingChannelConnector.this.connectionOpened(this._connection);
                while (this.isOpen()) {
                    if (this._connection.isIdle() && BlockingChannelConnector.this.getServer().getThreadPool().isLowOnThreads() && this._sotimeout != BlockingChannelConnector.this.getLowResourceMaxIdleTime()) {
                        this._sotimeout = BlockingChannelConnector.this.getLowResourceMaxIdleTime();
                        ((SocketChannel)this.getTransport()).socket().setSoTimeout(this._sotimeout);
                    }
                    this._connection.handle();
                }
            }
            catch (EofException e) {
                Log.debug((String)"EOF", (Object)e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    Log.ignore((Throwable)e2);
                }
            }
            catch (HttpException e) {
                Log.debug((String)"BAD", (Object)((Object)e));
                try {
                    this.close();
                }
                catch (IOException e2) {
                    Log.ignore((Throwable)e2);
                }
            }
            catch (Throwable e) {
                Log.warn((String)"handle failed", (Throwable)e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    Log.ignore((Throwable)e2);
                }
            }
            finally {
                BlockingChannelConnector.this.connectionClosed(this._connection);
            }
        }
    }
}

