/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.ByteArrayEndPoint;
import org.mortbay.io.EndPoint;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Server;

public class LocalConnector
extends AbstractConnector {
    ByteArrayEndPoint _endp;
    ByteArrayBuffer _in;
    ByteArrayBuffer _out;
    Server _server;
    boolean _accepting;
    boolean _keepOpen;

    public LocalConnector() {
        this.setPort(1);
    }

    public Object getConnection() {
        return this._endp;
    }

    public void setServer(Server server) {
        super.setServer(server);
        this._server = server;
    }

    public void clear() {
        this._in.clear();
        this._out.clear();
    }

    public void reopen() {
        this._in.clear();
        this._out.clear();
        this._endp = new ByteArrayEndPoint();
        this._endp.setIn(this._in);
        this._endp.setOut(this._out);
        this._endp.setGrowOutput(true);
        this._accepting = false;
    }

    public void doStart() throws Exception {
        this._in = new ByteArrayBuffer(8192);
        this._out = new ByteArrayBuffer(8192);
        this._endp = new ByteArrayEndPoint();
        this._endp.setIn(this._in);
        this._endp.setOut(this._out);
        this._endp.setGrowOutput(true);
        this._accepting = false;
        super.doStart();
    }

    public String getResponses(String requests) throws Exception {
        return this.getResponses(requests, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponses(String requests, boolean keepOpen) throws Exception {
        ByteArrayBuffer buf = new ByteArrayBuffer(requests);
        if (this._in.space() < buf.length()) {
            ByteArrayBuffer n = new ByteArrayBuffer(this._in.length() + buf.length());
            n.put(this._in);
            this._in = n;
            this._endp.setIn(this._in);
        }
        this._in.put(buf);
        LocalConnector localConnector = this;
        synchronized (localConnector) {
            this._keepOpen = keepOpen;
            this._accepting = true;
            ((Object)((Object)this)).notify();
            while (this._accepting) {
                ((Object)((Object)this)).wait();
            }
        }
        this._out = this._endp.getOut();
        return this._out.toString();
    }

    protected Buffer newBuffer(int size) {
        return new ByteArrayBuffer(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void accept(int acceptorID) throws IOException, InterruptedException {
        HttpConnection connection = null;
        while (this.isRunning()) {
            LocalConnector localConnector;
            block18: {
                localConnector = this;
                synchronized (localConnector) {
                    try {
                        while (!this._accepting) {
                            ((Object)((Object)this)).wait();
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                try {
                    if (connection == null) {
                        connection = new HttpConnection((Connector)this, (EndPoint)this._endp, this.getServer());
                        this.connectionOpened(connection);
                    }
                    while (this._in.length() > 0) {
                        connection.handle();
                    }
                    if (this._keepOpen) break block18;
                }
                catch (Throwable throwable) {
                    if (!this._keepOpen) {
                        this.connectionClosed(connection);
                        connection.destroy();
                        connection = null;
                    }
                    LocalConnector localConnector2 = this;
                    synchronized (localConnector2) {
                        this._accepting = false;
                        ((Object)((Object)this)).notify();
                    }
                    throw throwable;
                }
                this.connectionClosed(connection);
                connection.destroy();
                connection = null;
            }
            localConnector = this;
            synchronized (localConnector) {
                this._accepting = false;
                ((Object)((Object)this)).notify();
            }
        }
    }

    public void open() throws IOException {
    }

    public void close() throws IOException {
    }

    public int getLocalPort() {
        return -1;
    }
}

