 /*
  * To change this template, choose Tools | Templates
  * and open the template in the editor.
  */

 package org.javaone.scrambler;

 import org.javaone.anagram.lib.WordLibrary;

 /**
  *
  * @author jirka
  */
 public class AdditionalWordLibrary extends WordLibrary {
     private final String[] words;
     private final String[] scramblers;
     private final int size;

     public AdditionalWordLibrary (final String [] words, final String [] scramblers) {
         this.words = words;
         this.scramblers = scramblers;
         this.size = words.length;
     }

     @Override
     public String getWord(int idx) {
         assert idx < size;
         return words[idx];
     }

     @Override
     public String getScrambledWord(int idx) {
         assert idx < size;
         return scramblers[idx];
     }

     @Override
     public int getSize() {
         return size;
     }

     @Override
     public boolean isCorrect(int idx, String userGuess) {
         assert idx < size;
         return words [idx].equalsIgnoreCase(userGuess);
     }

 }

