package wsclient;

import javax.xml.rpc.JAXRPCException;
import javax.xml.namespace.QName;
import javax.microedition.xml.rpc.Operation;
import javax.microedition.xml.rpc.Type;
import javax.microedition.xml.rpc.ComplexType;
import javax.microedition.xml.rpc.Element;

public class BricksWebServiceService_Stub implements BricksWebServiceService, javax.xml.rpc.Stub {

    private String[] _propertyNames;
    private Object[] _propertyValues;

    public BricksWebServiceService_Stub() {
        _propertyNames = new String[] { ENDPOINT_ADDRESS_PROPERTY };
        _propertyValues = new Object[] { "http://localhost:8080/BrickGameWebApplication/BricksWebServiceService" };
    }

    public void _setProperty( String name, Object value ) {
        int size = _propertyNames.length;
        for (int i = 0; i < size; ++i) {
            if( _propertyNames[i].equals( name )) {
                _propertyValues[i] = value;
                return;
            }
        }
        String[] newPropNames = new String[size + 1];
        System.arraycopy(_propertyNames, 0, newPropNames, 0, size);
        _propertyNames = newPropNames;
        Object[] newPropValues = new Object[size + 1];
        System.arraycopy(_propertyValues, 0, newPropValues, 0, size);
        _propertyValues = newPropValues;

        _propertyNames[size] = name;
        _propertyValues[size] = value;
    }

    public Object _getProperty(String name) {
        for (int i = 0; i < _propertyNames.length; ++i) {
            if (_propertyNames[i].equals(name)) {
                return _propertyValues[i];
            }
        }
        if (ENDPOINT_ADDRESS_PROPERTY.equals(name) || USERNAME_PROPERTY.equals(name) || PASSWORD_PROPERTY.equals(name)) {
            return null;
        }
        if (SESSION_MAINTAIN_PROPERTY.equals(name)) {
            return new Boolean(false);
        }
        throw new JAXRPCException("Stub does not recognize property: " + name);
    }

    protected void _prepOperation(Operation op) {
        for (int i = 0; i < _propertyNames.length; ++i) {
            op.setProperty(_propertyNames[i], _propertyValues[i].toString());
        }
    }

    public String getOppMove(String playerId) throws java.rmi.RemoteException {
        Object inputObject[] = new Object[] {
            playerId
        };

        Operation op = Operation.newInstance( _qname_operation_getOppMove, _type_getOppMove, _type_getOppMoveResponse );
        _prepOperation( op );
        op.setProperty( Operation.SOAPACTION_URI_PROPERTY, "" );
        Object resultObj;
        try {
            resultObj = op.invoke( inputObject );
        } catch( JAXRPCException e ) {
            Throwable cause = e.getLinkedCause();
            if( cause instanceof java.rmi.RemoteException ) {
                throw (java.rmi.RemoteException) cause;
            }
            throw e;
        }

        return (String )((Object[])resultObj)[0];
    }

    public void gameOver(String playerId) throws java.rmi.RemoteException {
        Object inputObject[] = new Object[] {
            playerId
        };

        Operation op = Operation.newInstance( _qname_operation_gameOver, _type_gameOver, _type_gameOverResponse );
        _prepOperation( op );
        op.setProperty( Operation.SOAPACTION_URI_PROPERTY, "" );
        Object resultObj;
        try {
            resultObj = op.invoke( inputObject );
        } catch( JAXRPCException e ) {
            Throwable cause = e.getLinkedCause();
            if( cause instanceof java.rmi.RemoteException ) {
                throw (java.rmi.RemoteException) cause;
            }
            throw e;
        }

    }

    public int startGame(String playerId) throws java.rmi.RemoteException {
        Object inputObject[] = new Object[] {
            playerId
        };

        Operation op = Operation.newInstance( _qname_operation_startGame, _type_startGame, _type_startGameResponse );
        _prepOperation( op );
        op.setProperty( Operation.SOAPACTION_URI_PROPERTY, "" );
        Object resultObj;
        try {
            resultObj = op.invoke( inputObject );
        } catch( JAXRPCException e ) {
            Throwable cause = e.getLinkedCause();
            if( cause instanceof java.rmi.RemoteException ) {
                throw (java.rmi.RemoteException) cause;
            }
            throw e;
        }

        return ((Integer )((Object[])resultObj)[0]).intValue();
    }

    public String initPlayer(String levelId) throws java.rmi.RemoteException {
        Object inputObject[] = new Object[] {
            levelId
        };

        Operation op = Operation.newInstance( _qname_operation_initPlayer, _type_initPlayer, _type_initPlayerResponse );
        _prepOperation( op );
        op.setProperty( Operation.SOAPACTION_URI_PROPERTY, "" );
        Object resultObj;
        try {
            resultObj = op.invoke( inputObject );
        } catch( JAXRPCException e ) {
            Throwable cause = e.getLinkedCause();
            if( cause instanceof java.rmi.RemoteException ) {
                throw (java.rmi.RemoteException) cause;
            }
            throw e;
        }

        return (String )((Object[])resultObj)[0];
    }

    public boolean postMove(String playerId, String steps) throws java.rmi.RemoteException {
        Object inputObject[] = new Object[] {
            playerId,
            steps
        };

        Operation op = Operation.newInstance( _qname_operation_postMove, _type_postMove, _type_postMoveResponse );
        _prepOperation( op );
        op.setProperty( Operation.SOAPACTION_URI_PROPERTY, "" );
        Object resultObj;
        try {
            resultObj = op.invoke( inputObject );
        } catch( JAXRPCException e ) {
            Throwable cause = e.getLinkedCause();
            if( cause instanceof java.rmi.RemoteException ) {
                throw (java.rmi.RemoteException) cause;
            }
            throw e;
        }

        return ((Boolean )((Object[])resultObj)[0]).booleanValue();
    }

    protected static final QName _qname_operation_initPlayer = new QName( "http://bricks/", "initPlayer" );
    protected static final QName _qname_operation_getOppMove = new QName( "http://bricks/", "getOppMove" );
    protected static final QName _qname_operation_gameOver = new QName( "http://bricks/", "gameOver" );
    protected static final QName _qname_operation_startGame = new QName( "http://bricks/", "startGame" );
    protected static final QName _qname_operation_postMove = new QName( "http://bricks/", "postMove" );
    protected static final QName _qname_getOppMoveResponse = new QName( "http://bricks/", "getOppMoveResponse" );
    protected static final QName _qname_getOppMove = new QName( "http://bricks/", "getOppMove" );
    protected static final QName _qname_initPlayer = new QName( "http://bricks/", "initPlayer" );
    protected static final QName _qname_initPlayerResponse = new QName( "http://bricks/", "initPlayerResponse" );
    protected static final QName _qname_gameOver = new QName( "http://bricks/", "gameOver" );
    protected static final QName _qname_postMoveResponse = new QName( "http://bricks/", "postMoveResponse" );
    protected static final QName _qname_startGameResponse = new QName( "http://bricks/", "startGameResponse" );
    protected static final QName _qname_startGame = new QName( "http://bricks/", "startGame" );
    protected static final QName _qname_gameOverResponse = new QName( "http://bricks/", "gameOverResponse" );
    protected static final QName _qname_postMove = new QName( "http://bricks/", "postMove" );
    protected static final Element _type_postMoveResponse;
    protected static final Element _type_startGameResponse;
    protected static final Element _type_postMove;
    protected static final Element _type_gameOverResponse;
    protected static final Element _type_getOppMove;
    protected static final Element _type_getOppMoveResponse;
    protected static final Element _type_startGame;
    protected static final Element _type_initPlayer;
    protected static final Element _type_gameOver;
    protected static final Element _type_initPlayerResponse;

    static {
        _type_getOppMoveResponse = new Element( _qname_getOppMoveResponse, _complexType( new Element[] {
            new Element( new QName( "", "return" ), Type.STRING, 0, 1, false )}), 1, 1, false );
        _type_initPlayer = new Element( _qname_initPlayer, _complexType( new Element[] {
            new Element( new QName( "", "levelId" ), Type.STRING, 0, 1, false )}), 1, 1, false );
        _type_getOppMove = new Element( _qname_getOppMove, _complexType( new Element[] {
            new Element( new QName( "", "playerId" ), Type.STRING, 0, 1, false )}), 1, 1, false );
        _type_initPlayerResponse = new Element( _qname_initPlayerResponse, _complexType( new Element[] {
            new Element( new QName( "", "return" ), Type.STRING, 0, 1, false )}), 1, 1, false );
        _type_postMoveResponse = new Element( _qname_postMoveResponse, _complexType( new Element[] {
            new Element( new QName( "", "return" ), Type.BOOLEAN )}), 1, 1, false );
        _type_gameOver = new Element( _qname_gameOver, _complexType( new Element[] {
            new Element( new QName( "", "playerId" ), Type.STRING, 0, 1, false )}), 1, 1, false );
        _type_startGame = new Element( _qname_startGame, _complexType( new Element[] {
            new Element( new QName( "", "playerId" ), Type.STRING, 0, 1, false )}), 1, 1, false );
        _type_startGameResponse = new Element( _qname_startGameResponse, _complexType( new Element[] {
            new Element( new QName( "", "return" ), Type.INT )}), 1, 1, false );
        _type_gameOverResponse = new Element( _qname_gameOverResponse, _complexType( new Element[] {
        }), 1, 1, false );
        _type_postMove = new Element( _qname_postMove, _complexType( new Element[] {
            new Element( new QName( "", "playerId" ), Type.STRING, 0, 1, false ),
            new Element( new QName( "", "steps" ), Type.STRING, 0, 1, false )}), 1, 1, false );
    }

    private static ComplexType _complexType( Element[] elements ) {
        ComplexType result = new ComplexType();
        result.elements = elements;
        return result;
    }
}
