/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package logic;

import game.*;
import java.io.IOException;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import logic.BricksLayerManager;

/**
 *
 * @author avk
 */
public class BricksGameCanvas extends GameCanvas {

    /**
     * BLACK color constant
     */
    public static final int BLACK = 0;
    /**
     * WHITE color constant
     */
    public static final int WHITE = 0xffffffff;
    /**
     * OPAQUE_BLUE color constant
     */
    public static final int OPAQUE_BLUE = 0xff0000ff;
    /**
     * height of players info block
     */
    public static final int PLAYERS_INFO_BLOCK_HEIGHT = 15;

    /**
     * the top corner x coordinate according to this object's coordinate system.
     */
    private static int CORNER_X = 0;
    /**
     * the top corner y coordinate according to this object's coordinate system.
     */
    private static int CORNER_Y = 0;
    /**
     * the width of the portion of the screen that this canvas can use.
     */
    private static int DISP_WIDTH;
    /**
     * the height of the portion of the screen that this canvas can use.
     */
    private static int DISP_HEIGHT;
    // -------------------------------
    /** 
     * a link to the Display.
     */
    private Display myDisplay;
    /** 
     * a link to the MIDlet object.
     */
    private VisualMIDlet myMidlet;
    /** 
     * the LayerManager that handles the game graphics.
     */
    private BricksLayerManager myManager;
    /**
     * whether or not the game has ended.
     */
    static boolean myGameOver;

    public BricksGameCanvas(VisualMIDlet midlet) {
        super(false);
        myDisplay = Display.getDisplay(midlet);
        myMidlet = midlet;
        // calculate the dimensions based on the full screen
        setFullScreenMode(true);
        DISP_WIDTH = getWidth();
        DISP_HEIGHT = getHeight();
        // create the LayerManager (where all of the interesting
        // graphics go!) and give it the dimensions of the
        // region it is supposed to paint:
        if (myManager == null) {
            myManager = new BricksLayerManager(CORNER_X, CORNER_Y, DISP_WIDTH, DISP_HEIGHT, this);
        }
    }

    /**
     * This is called when the game ends.
     */
    public void setGameOver(String winnerName) {
        myGameOver = true;
        myMidlet.gameOver(winnerName);
    }


    public void checkKeys() {
        if (!myGameOver) {
            int keyState = getKeyStates();

            myManager.requestMove(keyState);
        }
    }


    public void init() throws IOException {
        myManager.init();
    }

    public void start() {
        myGameOver = false;
        // Now that the timer and softkeys are ready,
        // this screen can be displayed (since the menu is
        // not shown initially)
        myDisplay.setCurrent(this);
    }

    /**
     * clears the key states.
     */
    public void flushKeys() {
        getKeyStates();
    }

    /**
     * paint the game graphics on the screen.
     * @param g
     */
    public void paint(Graphics g) {
        // The LayerManager paints the
        // interesting part of the graphics:
        try {
            myManager.paint(g);
        } catch (Exception e) {
            errorMsg(e);
            return;
        }
        paintPlayersInfo(g);

        paintWaitingForOpponent(g);

        if (myGameOver) {
            paintGameOver(g);
        }
    }

    private void paintGameOver(Graphics g) {
            g.setColor(OPAQUE_BLUE);
            g.fillRect(DISP_WIDTH/2 - DISP_WIDTH/3, DISP_HEIGHT/2 - DISP_HEIGHT/4, DISP_WIDTH*2/3, DISP_HEIGHT/2);
            g.setColor(WHITE);
            g.setFont(Font.getFont(Font.FACE_SYSTEM, Font.STYLE_BOLD, Font.SIZE_LARGE));
            g.drawString("GAME OVER", DISP_WIDTH/2, DISP_HEIGHT/2 - 20, Graphics.HCENTER | Graphics.BOTTOM);
            g.drawString("Press any key", DISP_WIDTH/2, DISP_HEIGHT/2 + 30, Graphics.HCENTER | Graphics.BOTTOM);
    }

    private void paintWaitingForOpponent(Graphics g) {
        if (myManager.isWaitingForOpponent()){
            g.setColor(OPAQUE_BLUE);
            g.drawRect(DISP_WIDTH/16, DISP_HEIGHT*4/10, DISP_WIDTH*7/8, DISP_HEIGHT/5);
            //g.setColor(WHITE);
            g.setFont(Font.getFont(Font.FACE_SYSTEM, Font.STYLE_BOLD, Font.SIZE_LARGE));
            g.drawString("WAITING FOR OPPONENT", DISP_WIDTH/2, DISP_HEIGHT*16/30, Graphics.HCENTER | Graphics.BOTTOM);
        }
    }

    private void paintPlayersInfo(Graphics g){
        // the active player info is painted on top of the game graphics.
        String player = myManager.getActivePlayerName();
        String steps = String.valueOf(myManager.getRemainingStepsCount());
        String score = String.valueOf(myManager.getPlayer1Bricks()) + "/"
                + String.valueOf(myManager.getPlayer2Bricks())
                + " ("+String.valueOf(myManager.getBricksLeft()) + ")";
        g.setColor(BLACK);
        g.fillRect(0, 0, getWidth(), PLAYERS_INFO_BLOCK_HEIGHT);
        g.setColor(WHITE);
        g.drawString("player: "+player, 0, 0, Graphics.TOP | Graphics.LEFT);
        g.drawString(score, getWidth()/2, 0, Graphics.TOP | Graphics.HCENTER);
        g.drawString(" steps left: "+steps, getWidth(), 0, Graphics.TOP | Graphics.RIGHT);
    }


    /**
     * update the display.
     */
    public void updateScreen() {
        // paint the display:
        try {
            paint(getGraphics());
            flushGraphics(CORNER_X, CORNER_Y, DISP_WIDTH, DISP_HEIGHT);
        } catch (Exception e) {
            errorMsg(e);
        }
    }

    public void errorMsg(Exception e) {
        myMidlet.errorMsg(e);
    }

    /**
     * Respond to softkeys.
     * The keystates value won't give information
     * about softkeys, so the keypressed method
     * must be implemented separately:
     */
    public void keyPressed(int keyCode) {
        //when the game is over
        if (myGameOver) {
            reset();
            flushKeys();
            //switch to the screen with the winner name
            myMidlet.switchToWinnerForm();
        }
    }

    private void reset() {
        myManager.reset();
        myGameOver = false;
    }


}
