/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package bricks;

/**
 *
 * @author avk
 */
public class Game {

    public static final int PLAYER_ORDER_NO_GAME = 0;
    public static final int PLAYER_ORDER_1 = 1;
    public static final int PLAYER_ORDER_2 = 2;

    String myPlayer1 = null;
    String myPlayer2 = null;
    String myLastPlayer = null;
    String myLastSteps = null;

    boolean myGameOver = false;

    private Game(String player1Id, String player2Id) {
        myPlayer1 = player1Id;
        myPlayer2 = player2Id;
        // it's now 1st player turn to play
        myLastPlayer = myPlayer2;
    }


    static Game createInstance(String player1Id, String player2Id ){
        Game game = new Game(player1Id, player2Id);
        return game;
    }

    void setLastMove(String playerId, String steps){
        myLastPlayer = playerId;
        myLastSteps = steps;
    }

    String getLastSteps(){
        return myLastSteps;
    }

    String getLastPlayedId(){
        return myLastPlayer;
    }

    /**
     * set game over to true. If both players have marked gameover as true,
     * game object can be destroyed.
     * @return if the game object can be desctoyed.
     */
    boolean gameOver(){
        boolean gOver = myGameOver;
        myGameOver = true;
        return gOver;
    }

    int getPlayerOrder(String id){
        if (id.equals(getPlayer1Id())){
            return PLAYER_ORDER_1;
        } else if (id.equals(getPlayer2Id())){
            return PLAYER_ORDER_2;
        } else {
            return PLAYER_ORDER_NO_GAME;
        }
    }

    String getPlayer1Id(){
        return myPlayer1;
    }

    String getPlayer2Id(){
        return myPlayer2;
    }

}
