/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package logic.players;

import java.rmi.RemoteException;
import java.util.Vector;
import javax.microedition.lcdui.game.Sprite;
import logic.BricksLayerManager;
import logic.GameInfo;
import wsclient.BricksWebServiceService;

/**
 *
 * @author avk
 */
public class WebPlayer extends AbstractPlayer {

    private static final String STEPS_SEPARATOR = ",";
    private BricksWebServiceService myWsClient;
    private String myId;
    private Vector mySteps;
    private boolean stepsPosted = false;

    public WebPlayer(Sprite sprite, SpriteAnimator animator, GameInfo info,
            BricksWebServiceService wsClient, String id) {
        super(sprite, animator, info);
        myWsClient = wsClient;
        myId = id;
    }

    public String getName() {
        return "Opponent";
    }

    public boolean isReadyToMove() {
        if (mySteps != null && mySteps.size() > 0){
            return true;
        }
        try {
            // post move.
            if (!stepsPosted && hasStepsToPost()) {
                if (!myWsClient.postMove(myId, stepsToString(getStepsHistory()))) {
                    stepsPosted = true;
                    return false;
                }
            }

            // get move
            String stepsString = myWsClient.getOppMove(myId);
            if (stepsString == null) {
                return false;
            }
            mySteps = stepsFromString(stepsString);
            stepsPosted = false;
        } catch (RemoteException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public int move(int keyState) {
        try {
            Thread.sleep(MS_TO_SLEEP_ON_STEP);
        } catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        if (mySteps.size() > 0) {
            Integer step = (Integer) mySteps.firstElement();
            mySteps.removeElementAt(0);
            return step.intValue();
        } else {
            return BricksLayerManager.MOVE_NONE;
        }
    }

    private String stepsToString(int[] steps) {
        StringBuffer result = new StringBuffer();
        int len = steps.length;
        for (int i = 0; i < len; i++) {
            result.append(steps[i]);
            if (i < len - 1) {
                result.append(STEPS_SEPARATOR);
            }
        }
        return result.toString();
    }

    private Vector stepsFromString(String stepsString) {
        Vector steps = new Vector();

        int from = 0;
        int to = 0;
        while ((to = stepsString.indexOf(STEPS_SEPARATOR, from)) != -1) {
            steps.addElement(cutInt(stepsString, from, to));
            from = to + 1;
        }
        if (stepsString.length() > 0) {
            steps.addElement(cutInt(stepsString, from, stepsString.length()));
        }

        return steps;
    }

    private boolean hasStepsToPost(){
        return getStepsHistory() != null;
        //int[] steps = getStepsHistory();
        //return ( steps.length > 0 && steps[0] != BricksLayerManager.MOVE_NONE );
    }

    private Integer cutInt(String str, int startInder, int endIndex) {
        return Integer.valueOf(str.substring(startInder, endIndex));
    }
}
