/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package logic.players;

import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;
import logic.BricksLayerManager;
import logic.GameInfo;

/**
 *
 * @author avk
 */
public abstract class AbstractPlayer implements Player{

    protected static final int MS_TO_SLEEP_ON_STEP = 500;
    public final static int EMPTY_TILE_INDEX = BricksLayerManager.EMPTY_TILE_INDEX;

    private Sprite mySprite;
    private Sprite myOpponentSprite;
    private SpriteAnimator myAnimator;
    private GameInfo myGameInfo;
    private int bricks;

    public AbstractPlayer(Sprite sprite, SpriteAnimator animator, GameInfo info) {
        mySprite = sprite;
        myAnimator = animator;
        myGameInfo = info;
        myOpponentSprite = myGameInfo.getOpponentSprite(sprite);
        bricks = 0;
    }

    public Sprite getSprite(){
        return mySprite;
    }

    public SpriteAnimator getAnimator(){
        return myAnimator;
    }

    public TiledLayer getBricksLayer(){
        return myGameInfo.getBricksLayer();
    }

    public TiledLayer getWallsLayer(){
        return myGameInfo.getWallsLayer();
    }

    public Sprite getOpponentSprite(){
        return myOpponentSprite;
    }

    public int[] getStepsHistory(){
        return myGameInfo.getStepsHistory();
    }

    public int takeBrick() {
        return ++bricks;
    }

    public int getBricks() {
        return bricks;
    }



}
