/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package logic.players;

import javax.microedition.lcdui.game.Sprite;

/**
 *
 * @author avk
 */
public interface Player {

    public String getName();

    Sprite getSprite();

    SpriteAnimator getAnimator();

    /**
     * tests if player is ready to play in his turn.
     * Can be used by player to think about the best steps, load info etc.
     * @return true if player is ready to move.
     */
    boolean isReadyToMove();

    /**
     * Takes pressed kay and returns direction to move sprite:
     * BricksLayerManager.MOVE_UP, BricksLayerManager.MOVE_RIGTH, BricksLayerManager.MOVE_DOWN, BricksLayerManager.MOVE_LEFT, BricksLayerManager.MOVE_NONE.
     * <p>
     * BricksLayerManager.MOVE_NONE is returned in case no move information is available.
     * @param keyState value returned by GameCanvas.getKeyStates()
     * @return one of values: BricksLayerManager.MOVE_UP, BricksLayerManager.MOVE_RIGTH,
     * BricksLayerManager.MOVE_DOWN, BricksLayerManager.MOVE_LEFT,
     * BricksLayerManager.MOVE_NONE
     */
    int move(int keyState);

    int takeBrick();

    int getBricks();

    interface SpriteAnimator{
        void move();
        void stop();
    }
}
