package org.duanesworldtv.livecycle.samples;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
// this is from xpaaj.jar - check licenses before using.
// LiveCycle ES has newer JAVA libraries for manipulating PDF
import com.adobe.pdf.*;	

public class PDFVersion {
    public static void main(String[] args)
		throws FileNotFoundException, IOException
	{
		// get pdf filename
		String inPdfName;
		if(args.length != 1 ) {
	        System.out.println("\nCommand line format: java PDFExtractData pdf-file");
	        return;
		} else {
			// message 
		    System.out.println("\nPDF data extraction using Adobe PDF Libraries.");
			inPdfName = new String(args[0]);
			PDFExtract(inPdfName);
		}
	}

    public static void PDFExtract(String inPdfName)
	throws FileNotFoundException, IOException
	{
	// open PDF
	System.out.println("\nOpen PDF Document ... ");
	PDFDocument doc = null;
	FileInputStream inPdfFile = new FileInputStream(inPdfName);

	try {
		doc = PDFFactory.openDocument(inPdfFile);
	} catch (IOException e) {
			System.out.println("Error opening PDF file :" + inPdfName);
			System.out.println(e);
	}

	if(doc == null)
		System.out.println("Cannot open PDF file : " + inPdfName);
	else 
		System.out.println( inPdfName + " was successfully opened.");
    

	/** 
	 *	TODO:  Add code to get the version of a PDF file.
	 *  The solution code is commented out right below.  When writing the solution,
	 *  you may use this as reference material.
	 */
    /* SOLUTION*******
     try 
     
     { 
    	System.out.println("Document version is " + doc.getVersion()); 
    	} catch (Exception e) { 
    		System.out.println("Error getting document version: " + e);
    }*/
  }       
}

/******* End of file *********************************/








