package org.duanesworldtv.livecycle.samples;

import java.io.InputStream; 
import java.io.FileInputStream; 
import java.io.FileOutputStream; 
import java.io.BufferedWriter; 
import java.io.FileWriter; 
import java.io.FileNotFoundException; 
import java.io.IOException; 
// this is from xpaaj.jar - check licenses before using. 
// LiveCycle ES has newer JAVA libraries for manipulating PDF 
import com.adobe.pdf.*;

  public class PDFAnnotationExtractor 
  {
	  public static void main(String[] args)
		  throws FileNotFoundException, IOException
		  {
			  String inPDFName;
			  if (args.length != 1) 
			  {
				//TODO: if you get this message, make sure you set your runtime arguments to the right file.
				// Recommend you use an absolute path that is right for your machine like c:\some\path\to\file.pdf
				System.out.println("Usage:  java <class_name> <PDF File>");  
				return;
			  } else {
				  System.out.println("Starting to open PDF document");
				  inPDFName = new String(args[0]);
				  PDFExtract(inPDFName);
			  }
		  }

	  public static void PDFExtract(String inPdfName)
		throws FileNotFoundException, IOException
		{
		  // open PDF
		  System.out.println("\nOpen PDF Document ... ");
		  PDFDocument doc = null;
		  FileInputStream inPdfFile = new FileInputStream(inPdfName);

		  try 
		  {
			doc = PDFFactory.openDocument(inPdfFile);
			} catch (IOException e) {
				System.out.println("Error opening PDF file :" + inPdfName);
				System.out.println(e);
		}
		if(doc == null)
			System.out.println("Cannot open PDF file : " + inPdfName);
		else 
			System.out.println( inPdfName + " was successfully opened.");
		
	 	/** 
		 *	TODO: Add Method PDFExtract to open and extract data from a PDF file.
		 *  The solution code is commented out right below.  When writing the solution,
		 *  you may use this as reference material.
		 */
		
		/**** SOLUTION ****
		 //Don't just cut and paste - this is to help you, not allow you to cheat.
		 //Eclipse Code Completion is your BEST friend!
			System.out.println("\nTrying to Extract annotation data ...");
			InputStream inputStream;
			Boolean b = false;
			  inputStream = doc.exportAnnotations();
			  if(inputStream == null)
			  {
				  System.out.println("Invalid input stream.");
			  } else { 
					String annotFile = "Annotations.xml";
					//b = false;
					try {
						b = saveFile(inputStream, annotFile);
					} catch (Exception e) {
						System.out.println("Error saving annotation file.");
						System.out.println(e);
					}
					if(b == true)
						System.out.println ("Annotations were saved to file : " + annotFile);	
					else
						System.out.println("Annotations were not saved to file.");
		  }*/
		  
	  }
	   public static boolean saveFile(InputStream is, String filePath) 
		throws Exception
   {
       boolean retVal=false;
       byte[] buffer = new byte[10240];
       FileOutputStream outStream = null;
       try
       {
           outStream = new FileOutputStream(filePath);
           int len=0;
           while (true)
           {
               len = is.read(buffer);
               if (len == -1)
                   break;
               outStream.write(buffer, 0, len);
           }
           outStream.close();
           retVal = true;
       }catch (IOException io) {
    	   //TODO: make sure you have perms to write out....
           System.out.println("Writing the array of bytes into the file "
               + filePath + " failed.");
           throw new Exception(
                   "Writing the array of bytes into the file "+ filePath +
           " failed in saveFile");
       }
       return retVal;
   } 

	// save text string to a file.
   public static boolean saveStringToFile(String text, String filePath) 
   {
		boolean b = false;
		try {
			BufferedWriter outTxtFile = new BufferedWriter(new FileWriter(filePath));
			outTxtFile.write(text, 0, text.length());
		    outTxtFile.close();
			b = true;
		} catch (IOException e) {
			System.out.println("Error saving text file.");
		}
		return b;
	}
  } 


/******* End of file *********************************/

