package org.duanesworldtv.livecycle.samples;

import java.io.InputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
// this is from xpaaj.jar - check licenses before using.
// LiveCycle ES has newer JAVA libraries for manipulating PDF
import com.adobe.pdf.*;	

public class PDFExtractXMP {
    public static void main(String[] args)
		throws FileNotFoundException, IOException
	{
		// get pdf filename
		String inPdfName;
		if(args.length != 1 ) {
	        System.out.println("\nCommand line format: java PDFExtractData pdf-file");
	        return;
		} else {
			// message 
		    System.out.println("\nPDF data extraction using Adobe PDF Libraries.");
			inPdfName = new String(args[0]);
			PDFExtract(inPdfName);
		}
	}

 	/** 
	 *	TODO: Add Method PDFExtract to open and extract data from a PDF file
	 */
    public static void PDFExtract(String inPdfName)
	throws FileNotFoundException, IOException
	{
	// open PDF
	System.out.println("\nOpen PDF Document ... ");
	PDFDocument doc = null;
	FileInputStream inPdfFile = new FileInputStream(inPdfName);

	try {
		doc = PDFFactory.openDocument(inPdfFile);
	} catch (IOException e) {
			System.out.println("Error opening PDF file :" + inPdfName);
			System.out.println(e);
	}

	if(doc == null)
		System.out.println("Cannot open PDF file : " + inPdfName);
	else 
		System.out.println( inPdfName + " was successfully opened.");
	
	try {
		System.out.println("Document version is " + doc.getVersion());
	} catch (Exception e) {
        System.out.println("Error getting document version: " + e);		
	}

	try {
	System.out.println("Number of pages is " + doc.getNumberOfPages());
	} catch (Exception e) {
	System.out.println("Error getting number of Pages " + e );
	}
	
	// Export the XMP metadata
	System.out.println("\nExtracting document metadata ...");
	String DocMetadataFile = "DocMetadata.xml";
	boolean b = false;
	InputStream inputStream;
	inputStream = doc.exportXMP();
	if(inputStream == null)
		System.out.println("No document level metadata was exported.");
	else { 
		System.out.println("Document metadata was exported.");
		try {
			b = saveFile(inputStream, DocMetadataFile);
		} catch (Exception e) {
			System.out.println("Error saving metadata file.");
			System.out.println(e);
		}
		if(b == true)
			System.out.println ("Document metadata was saved to file : " + DocMetadataFile);	
		else
			System.out.println("Document metadata was not saved.");
	  }
	}

 	/** 
	method to save InputStream to a file.
*/
public static boolean saveFile(InputStream is, String filePath) 
	throws Exception
{
    boolean retVal=false;
    byte[] buffer = new byte[10240];
    FileOutputStream outStream = null;
    try
    {
        outStream = new FileOutputStream(filePath);
        int len=0;
        while (true)
        {
            len = is.read(buffer);
            if (len == -1)
                break;
            outStream.write(buffer, 0, len);
        }
        outStream.close();
        retVal = true;
    }catch (IOException io) {
        System.out.println("Writing the array of bytes into the file "
            + filePath + " failed.");
        throw new Exception(
                "Writing the array of bytes into the file "+ filePath +
        " failed in saveFile");
    }
    return retVal;
} 

// save text string to a file.
public static boolean saveStringToFile(String text, String filePath) 
{
	boolean b = false;
	try {
		BufferedWriter outTxtFile = new BufferedWriter(new FileWriter(filePath));
		outTxtFile.write(text, 0, text.length());
	    outTxtFile.close();
		b = true;
	} catch (IOException e) {
		System.out.println("Error saving text file.");
	}
	return b;
	
	
	}
}

/******* End of file *********************************/