package org.duanesworldtv.livecycle.samples;
/*
 * This Java Quick Start uses the EJB mode and contains the following JAR files
 * in the class path:
 * 1. adobe-encryption-client.jar
 * 2. adobe-livecycle-client.jar
 * 3. adobe-usermanager-client.jar
 * 4. adobe-utilities.jar
 * 5. jbossall-client.jar (use a different JAR file if LiveCycle ES is not deployed
 * on JBoss)
 * 
 *  These JAR files are located in the following path:
 * <install directory>/Adobe/LiveCycle9.0/LiveCycle_ES_SDK/client-libs/common
 * 
 * The adobe-utilities.jar file is located in the following path:
 * <install directory>/Adobe/LiveCycle9.0/LiveCycle_ES_SDK/client-libs/jboss
 * 
 * The jbossall-client.jar file is located in the following path:
 * <install directory>/Adobe/LiveCycle9.0/jboss/client
 * 
 * If you want to invoke a remote LiveCycle ES instance and there is a
 * firewall between the client application and LiveCycle ES, then it is 
 * recommended that you use the SOAP mode. When using the SOAP mode, 
 * you have to include additional JAR files located in the following 
 * path:
 * <install directory>/Adobe/LiveCycle9.0/LiveCycle_ES_SDK/client-libs/thirdparty
 * 
 * For information about the SOAP and EJB mode, 
 * see "Setting connection properties" in Programming 
 * with LiveCycle ES
 * 
 * For complete details about the location of the LiveCycle ES JAR files, 
 * see "Including LiveCycle ES library files" in Programming 
 * with LiveCycle ES
 */

import com.adobe.livecycle.xmputility.*;
import com.adobe.livecycle.xmputility.client.*;
import java.util.*;
import java.io.*;
import com.adobe.idp.Document;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactoryProperties; 

public class ExportXMP
{
	public static void main(String[] args)
	{
		try
		{
            //Set connection properties required to invoke LiveCycle ES                                           
	    	Properties ConnectionProps = new Properties();
	    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_DEFAULT_SOAP_ENDPOINT, "http://demo.ensemble.com:8080");
	    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_TRANSPORT_PROTOCOL,ServiceClientFactoryProperties.DSC_SOAP_PROTOCOL);          
	    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_SERVER_TYPE, "JBoss");
	    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_CREDENTIAL_USERNAME, "kvarsen");
	    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_CREDENTIAL_PASSWORD, "password");
 
			//Create a ServiceClientFactory instance
			ServiceClientFactory factory = ServiceClientFactory.createInstance(ConnectionProps);
 
			// Create a XMP Utility client
			XMPUtilityServiceClient xmpUt = new XMPUtilityServiceClient(factory);
 
			// Specify a PDF document whose metadata is to be exported
			FileInputStream fileInputStream = new FileInputStream("/Users/duane/Desktop/eclipse/workspace/JavaOne2009-docs/DuanesWorld.pdf");
			Document inDoc = new Document(fileInputStream);
 
			// Export the XMP metadata object
			XMPUtilityMetadata myXmp = xmpUt.exportMetadata(inDoc);
 
			/*TODO: Here you can grab a lot of data my accessing myXmp.* */
			
			// Inspect the XMP metadata object (retrieve the documents author in this case)
			String name = myXmp.getAuthor();
			System.out.println("The documents author is " + name);
			
			String title = myXmp.getTitle();
			System.out.println("The documents title is " + title);			
 
			// Export the XMP metadata to an XML file
			Document outDoc = xmpUt.exportXMP(inDoc);
			File xmpFile = new File("/Users/duane/Desktop/eclipse/workspace/JavaOne2009-docs/MetaData.xml");
			outDoc.copyToFile(xmpFile);
		} catch (Exception e) {
			System.out.println("Error occurred: " + e.getMessage());
		}
	}
}