package org.duanesworldtv.livecycle.samples;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import com.adobe.livecycle.generatepdf.client.CreatePDFResult;
import com.adobe.idp.Document;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactoryProperties;
import com.adobe.livecycle.distiller.client.DistillerServiceClient;
 
public class CreatePDF {
      public static void main(String[] args)
      {
            try
            {     
                //Set connection properties required to invoke LiveCycle ES                                           
    	    	Properties ConnectionProps = new Properties();
    	    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_DEFAULT_SOAP_ENDPOINT, "http://demo.ensemble.com:8080");
    	    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_TRANSPORT_PROTOCOL,ServiceClientFactoryProperties.DSC_SOAP_PROTOCOL);          
    	    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_SERVER_TYPE, "JBoss");
    	    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_CREDENTIAL_USERNAME, "kvarsen");
    	    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_CREDENTIAL_PASSWORD, "password");
            	
            // get pdf filename
    	    // TODO: Ensure the path is correct for you machine.	
            String inFileName = "/Users/duane/Desktop/eclipse/workspace/JavaOne2009-docs/test.ps";
                        
            // TODO: Create a ServiceClientFactory instance
            ServiceClientFactory factory = ServiceClientFactory.createInstance(ConnectionProps);
            
            //TODO: Create a new instance of the DistillerServiceClient 
            DistillerServiceClient disClient = new DistillerServiceClient(factory );
            
            // inPdfName is the input PostScript file. Use absolute path to avoid errors.
            FileInputStream fileInputStream = new FileInputStream(inFileName);
            Document inDoc = new Document(fileInputStream);
            System.out.println("\nGrabbing input document " + inFileName);
                  
            //TODO: Set run-time options for adobePDFSettings and securitySetting.
            String adobePDFSettings = "Standard";
            String securitySettings = "No Security";
      
            //Convert a PS  file into a PDF file
            CreatePDFResult result = new CreatePDFResult();
            
            System.out.println("\nTrying to createPDF...");
            result = disClient.createPDF(
                        inDoc, 
                        inFileName, 
                        adobePDFSettings, 
                        securitySettings, 
                        null, 
                        null
                  );
            
      //Get the newly created document
      Document createdDocument = result.getCreatedDocument();
 
      //Save the PDF file
      createdDocument.copyToFile(new File("converted_by_LC_" + System.currentTimeMillis() + ".pdf"));
      System.out.println("Conversion done!");
      } catch (Exception e) {
      e.printStackTrace();
      }
   }
}
 

