package org.duanesworldtv.livecycle.samples;

/*
 * This Java Quick Start uses the following JAR files
 * 1. adobe-pdfutility-client.jar
 * 2. adobe-livecycle-client.jar
 * 3. adobe-usermanager-client.jar
 * 4. adobe-utilities.jar
 * 5. jbossall-client.jar 
 * 
 * For complete details about the location of these JAR files, 
 * see "Including LiveCycle ES library files" in Programming with
 * LiveCycle ES
 */

 
import java.util.*;

import com.adobe.livecycle.pdfutility.client.*;
import java.io.*;
import com.adobe.idp.Document;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactoryProperties;
 
public class ConvertPDFToXDP
{
	public static void main(String[] args)
	{
		try
		{
				
            //Set connection properties required to invoke LiveCycle ES                                           
	    	Properties ConnectionProps = new Properties();
	    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_DEFAULT_SOAP_ENDPOINT, "http://demo.ensemble.com:8080");
	    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_TRANSPORT_PROTOCOL,ServiceClientFactoryProperties.DSC_SOAP_PROTOCOL);          
	    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_SERVER_TYPE, "JBoss");
	    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_CREDENTIAL_USERNAME, "kvarsen");
	    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_CREDENTIAL_PASSWORD, "password");
			
			// Create a ServiceClientFactory object
			ServiceClientFactory myFactory = ServiceClientFactory.createInstance(ConnectionProps);
 
			// Create a PDF Utility client
			PDFUtilityServiceClient pdfUt = new PDFUtilityServiceClient(myFactory);
 
			// Specify a PDF document to convert to an XDP file
			FileInputStream fileInputStream = new FileInputStream("/Users/duane/Desktop/eclipse/workspace/JavaOne2009-docs/dynamic-XFA.pdf");
			System.out.println("Successfully grabbed " + fileInputStream);
			Document inDoc = new Document(fileInputStream);
 
			// Convert the PDF document to an XDP file
			System.out.println("Trying to convert....");
			
			//TODO: Try to convert the PDF into an XDP and save it
			try 
			{
				Document myXDP = pdfUt.convertPDFtoXDP(inDoc);
				//Save the returned Document object as an XDP file
				File xdpFile = new File("/Users/duane/Desktop/eclipse/workspace/JavaOne2009-docs/DuanesWorld.xdp");
				myXDP.copyToFile(xdpFile);
				System.out.println("Saved " + xdpFile + " to file...");
			} catch (PDFUtilityException pdfue){
				System.out.println("PDFUtility Exception " + pdfue);
			}
 
			
		}
		catch (Exception e)
		{
			System.out.println("Error occurred: " + e.getMessage());
		}
	}
}

