package org.duanesworldtv.livecycle.samples;
/*
 * This Java Quick Start uses the following JAR files
 * 1. adobe-convertpdf-client.jar
 * 2. adobe-livecycle-client.jar
 * 3. adobe-usermanager-client.jar
 * 4. adobe-utilities.jar
 * 5. jbossall-client.jar (use a different JAR file if LiveCycle ES is not deployed on JBoss)
 * 
 *  These JAR files are located in the following path:
 * <install directory>/Adobe/LiveCycle8/LiveCycle_ES_SDK/client-libs
 * 
 * For complete details about the location of these JAR files, 
 * see "Including LiveCycle ES library files" in Programming
 * with LiveCycle ES
 */

import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import com.adobe.idp.Document;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactoryProperties;
import com.adobe.livecycle.convertpdfservice.client.ConvertPdfServiceClient;
import com.adobe.livecycle.convertpdfservice.client.ToImageOptionsSpec;
import com.adobe.livecycle.convertpdfservice.client.enumeration.CMYKPolicy;
import com.adobe.livecycle.convertpdfservice.client.enumeration.ColorCompression;
import com.adobe.livecycle.convertpdfservice.client.enumeration.ColorSpace;
import com.adobe.livecycle.convertpdfservice.client.enumeration.GrayScaleCompression;
import com.adobe.livecycle.convertpdfservice.client.enumeration.GrayScalePolicy;
import com.adobe.livecycle.convertpdfservice.client.enumeration.ImageConvertFormat;
import com.adobe.livecycle.convertpdfservice.client.enumeration.Interlace;
import com.adobe.livecycle.convertpdfservice.client.enumeration.JPEGFormat;
import com.adobe.livecycle.convertpdfservice.client.enumeration.MonochromeCompression;
import com.adobe.livecycle.convertpdfservice.client.enumeration.PNGFilter;
import com.adobe.livecycle.convertpdfservice.client.enumeration.RGBPolicy;
 

public class ConvertPDFToImage {
	public static void main(String[] args)
	{
	try
	{
		// get pdf filename
		String inPdfName;
		if(args.length != 1 ) {
			//TODO: set the runtime argument to a PDF file on your hard drive.
	        System.out.println("\nCommand line format: java JavaAPIConvertPDFtoImage pdf-file");
	        return;
		} else {
			// message 
		    System.out.println("\nGrabbing input PDF to convert to JPEG.");
			inPdfName = new String(args[0]);
			//PDFExtract(inPdfName);
		}
        //Set connection properties required to invoke LiveCycle ES                                           
    	Properties ConnectionProps = new Properties();
    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_DEFAULT_SOAP_ENDPOINT, "http://demo.ensemble.com:8080");
    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_TRANSPORT_PROTOCOL,ServiceClientFactoryProperties.DSC_SOAP_PROTOCOL);          
    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_SERVER_TYPE, "JBoss");
    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_CREDENTIAL_USERNAME, "kvarsen");
    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_CREDENTIAL_PASSWORD, "password");

		// Create a ServiceClientFactory instance
		ServiceClientFactory factory = ServiceClientFactory.createInstance(ConnectionProps);
		System.out.println("factory created");

		//Create the ConvertPDF service client
		ConvertPdfServiceClient serviceClient = new ConvertPdfServiceClient(factory);

		FileInputStream fileInputStream = new FileInputStream(inPdfName);
		Document inDoc = new Document(fileInputStream);
		inDoc.getContentType();
	
		// Set up the runtime options for the new JPEG file to be created
		ToImageOptionsSpec spec = new ToImageOptionsSpec();
		spec.setImageConvertFormat(ImageConvertFormat.JPEG);
		spec.setGrayScaleCompression(GrayScaleCompression.Low);
		spec.setColorCompression(ColorCompression.Low);
		spec.setFormat(JPEGFormat.BaselineOptimized);
		spec.setRgbPolicy(RGBPolicy.Off);
		spec.setCmykPolicy(CMYKPolicy.Off);
		spec.setColorSpace(ColorSpace.RGB);
		spec.setResolution("72");
		spec.setMonochrome(MonochromeCompression.None);
		spec.setFilter(PNGFilter.Sub);
		spec.setInterlace(Interlace.Adam7);
		spec.setTileSize(180);
		spec.setGrayScalePolicy(GrayScalePolicy.Off);
		
		//TODO: Perform the conversion and get the containing the newly created JPEG files
		List allImages = serviceClient.toImage2(
			inDoc,
			spec
		);

		//TODO: Create an Iterator object and iterate through 
		//the List object to get all images
		Iterator iter = allImages.iterator(); 
		int i = 0 ; 
		while (iter.hasNext()) { 
			Document file = (Document)iter.next(); 
			file.copyToFile(new File("./ConvertedByLiveCycle"+ System.currentTimeMillis() + i +".jpg"));
			System.out.println("Converted and saved + " + file);
			i++; 
		}
		System.out.println("Conversion done!");
	}
	catch (Exception e) {
		e.printStackTrace();
		}
	}
}