package org.duanesworldtv.livecycle.samples;

/*
 * This Java Quick Start uses the following JAR files
 * 1. adobe-signatures-client.jar
 * 2. adobe-livecycle-client.jar
 * 3. adobe-usermanager-client.jar
 * 4. adobe-utilities.jar
 * 5. jbossall-client.jar (use a different JAR file if LiveCycle ES is not deployed
 * on JBoss)
 * 
 * These JAR files are located in the following path:
 * <install directory>/Adobe/LiveCycle9.0/LiveCycle_ES_SDK/client-libs/common
 * 
 * For complete details about the location of these JAR files, 
 * see "Including LiveCycle ES library files" in Programming 
 * with LiveCycle ES
 */
import java.util.*;
import java.io.File;
import java.io.FileInputStream;
import com.adobe.livecycle.signatures.client.*;
import com.adobe.livecycle.signatures.client.types.*;
import com.adobe.idp.Document;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactoryProperties;
 
public class AddSignatureField {
 
      public static void main(String[] args) {
            
            try
            {
                //Set connection properties required to invoke LiveCycle ES                                           
    	    	Properties ConnectionProps = new Properties();
    	    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_DEFAULT_SOAP_ENDPOINT, "http://demo.ensemble.com:8080");
    	    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_TRANSPORT_PROTOCOL,ServiceClientFactoryProperties.DSC_SOAP_PROTOCOL);          
    	    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_SERVER_TYPE, "JBoss");
    	    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_CREDENTIAL_USERNAME, "kvarsen");
    	    	ConnectionProps.setProperty(ServiceClientFactoryProperties.DSC_CREDENTIAL_PASSWORD, "password");
    	    	
              //Create a ServiceClientFactory instance
              ServiceClientFactory myFactory = ServiceClientFactory.createInstance(ConnectionProps);
              System.out.println("Connection properties set");
              
              //Create a SignatureServiceClient object
              SignatureServiceClient signClient = new SignatureServiceClient(myFactory);
            
              //Specify a PDF document to which a signature field is added
              FileInputStream fileInputStream = new FileInputStream("/Users/duane/Desktop/eclipse/workspace/JavaOne2009-docs/test.pdf");      
              Document inDoc = new Document (fileInputStream); 
 
              //Specify the name of the signature field
              String fieldName = "SignatureField1";
 
              //Create a  PositionRectangle object that specifies
              //the signature fields location (int lowerLeftX, int lowerLeftY, int width, int height)
              PositionRectangle post = new  PositionRectangle(193,47,133,35);
 
              //Specify the page number that will contain the signature field
              java.lang.Integer pageNum = new java.lang.Integer(1);
              System.out.println("Ready to call server...");
              
              //Add a signature field to the PDF document
              Document sigFieldPDF = signClient.addSignatureField(
                  inDoc,
                  fieldName,
                  pageNum,
                  post,
                  null,
                  null);
             
              //Save the PDF document that contains the signature field     
              File outFile = new File("/Users/duane/Desktop/eclipse/workspace/JavaOne2009-docs/test-signed.pdf");
              System.out.println("Signature added, file saved!");
              sigFieldPDF.copyToFile(outFile);
            } catch (Exception ee) {
                 ee.printStackTrace();
            }
      }
}

