/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.common;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public class SniffedXmlInputStream
extends BufferedInputStream {
    public static int MAX_SNIFFED_BYTES;
    private static Charset dummy1;
    private static Charset dummy2;
    private static Charset dummy3;
    private static Charset dummy4;
    private static Charset dummy5;
    private static Charset dummy6;
    private static Charset dummy7;
    private String _encoding = this.sniffFourBytes();
    private static char[] WHITESPACE;
    private static char[] NOTNAME;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$apache$xmlbeans$impl$common$SniffedXmlInputStream;

    public SniffedXmlInputStream(InputStream stream) throws IOException {
        super(stream);
        String encoding;
        if (this._encoding != null && this._encoding.equals("IBM037") && (encoding = this.sniffForXmlDecl(this._encoding)) != null) {
            this._encoding = encoding;
        }
        if (this._encoding == null) {
            this._encoding = this.sniffForXmlDecl("UTF-8");
        }
        if (this._encoding == null) {
            this._encoding = "UTF-8";
        }
    }

    private int readAsMuchAsPossible(byte[] buf, int startAt, int len) throws IOException {
        int total = 0;
        while (total < len) {
            int count = this.read(buf, startAt + total, len - total);
            if (count < 0) break;
            total += count;
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sniffFourBytes() throws IOException {
        block25: {
            long result;
            block24: {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        block17: {
                                            block16: {
                                                block15: {
                                                    byte[] buf;
                                                    block14: {
                                                        String string;
                                                        this.mark(4);
                                                        boolean skip = false;
                                                        try {
                                                            buf = new byte[4];
                                                            if (this.readAsMuchAsPossible(buf, 0, 4) >= 4) break block14;
                                                            string = null;
                                                            Object var19_4 = null;
                                                        }
                                                        catch (Throwable throwable) {
                                                            Object var19_17 = null;
                                                            this.reset();
                                                            throw throwable;
                                                        }
                                                        this.reset();
                                                        return string;
                                                    }
                                                    result = 0xFF000000 & buf[0] << 24 | 0xFF0000 & buf[1] << 16 | 0xFF00 & buf[2] << 8 | 0xFF & buf[3];
                                                    if (result != 65279L) break block15;
                                                    String string = "UCS-4";
                                                    Object var19_5 = null;
                                                    this.reset();
                                                    return string;
                                                }
                                                if (result != -131072L) break block16;
                                                String string = "UCS-4";
                                                Object var19_6 = null;
                                                this.reset();
                                                return string;
                                            }
                                            if (result != 60L) break block17;
                                            String string = "UCS-4BE";
                                            Object var19_7 = null;
                                            this.reset();
                                            return string;
                                        }
                                        if (result != 0x3C000000L) break block18;
                                        String string = "UCS-4LE";
                                        Object var19_8 = null;
                                        this.reset();
                                        return string;
                                    }
                                    if (result != 3932223L) break block19;
                                    String string = "UTF-16BE";
                                    Object var19_9 = null;
                                    this.reset();
                                    return string;
                                }
                                if (result != 1006649088L) break block20;
                                String string = "UTF-16LE";
                                Object var19_10 = null;
                                this.reset();
                                return string;
                            }
                            if (result != 1010792557L) break block21;
                            String string = null;
                            Object var19_11 = null;
                            this.reset();
                            return string;
                        }
                        if (result != 1282385812L) break block22;
                        String string = "IBM037";
                        Object var19_12 = null;
                        this.reset();
                        return string;
                    }
                    if ((result & 0xFFFFFFFFFFFF0000L) != -16842752L) break block23;
                    String string = "UTF-16";
                    Object var19_13 = null;
                    this.reset();
                    return string;
                }
                if ((result & 0xFFFFFFFFFFFF0000L) != -131072L) break block24;
                String string = "UTF-16";
                Object var19_14 = null;
                this.reset();
                return string;
            }
            if ((result & 0xFFFFFFFFFFFFFF00L) != -272908544L) break block25;
            String string = "UTF-8";
            Object var19_15 = null;
            this.reset();
            return string;
        }
        String string = null;
        Object var19_16 = null;
        this.reset();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sniffForXmlDecl(String encoding) throws IOException {
        String string;
        this.mark(MAX_SNIFFED_BYTES);
        try {
            byte[] bytebuf = new byte[MAX_SNIFFED_BYTES];
            int bytelimit = this.readAsMuchAsPossible(bytebuf, 0, MAX_SNIFFED_BYTES);
            Charset charset = Charset.forName(encoding);
            InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(bytebuf, 0, bytelimit), charset);
            char[] buf = new char[bytelimit];
            int limit = 0;
            while (limit < bytelimit) {
                int count = ((Reader)reader).read(buf, limit, bytelimit - limit);
                if (count < 0) break;
                limit += count;
            }
            string = SniffedXmlInputStream.extractXmlDeclEncoding(buf, 0, limit);
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.reset();
            throw throwable;
        }
        this.reset();
        return string;
    }

    public String getXmlEncoding() {
        return this._encoding;
    }

    static String extractXmlDeclEncoding(char[] buf, int offset, int size) {
        int limit = offset + size;
        int xmlpi = SniffedXmlInputStream.firstIndexOf("<?xml", buf, offset, limit);
        if (xmlpi >= 0) {
            int i = xmlpi + 5;
            ScannedAttribute attr = new ScannedAttribute();
            while (i < limit) {
                if ((i = SniffedXmlInputStream.scanAttribute(buf, i, limit, attr)) < 0) {
                    return null;
                }
                if (!attr.name.equals("encoding")) continue;
                return attr.value;
            }
        }
        return null;
    }

    private static int firstIndexOf(String s, char[] buf, int startAt, int limit) {
        if (!$assertionsDisabled && s.length() <= 0) {
            throw new AssertionError();
        }
        char[] lookFor = s.toCharArray();
        char firstchar = lookFor[0];
        limit -= lookFor.length;
        while (startAt < limit) {
            block5: {
                if (buf[startAt] == firstchar) {
                    int i = 1;
                    while (i < lookFor.length) {
                        if (buf[startAt + i] == lookFor[i]) {
                            ++i;
                            continue;
                        }
                        break block5;
                    }
                    return startAt;
                }
            }
            ++startAt;
        }
        return -1;
    }

    private static int nextNonmatchingByte(char[] lookFor, char[] buf, int startAt, int limit) {
        while (startAt < limit) {
            block3: {
                char thischar = buf[startAt];
                int i = 0;
                while (i < lookFor.length) {
                    if (thischar != lookFor[i]) {
                        ++i;
                        continue;
                    }
                    break block3;
                }
                return startAt;
            }
            ++startAt;
        }
        return -1;
    }

    private static int nextMatchingByte(char[] lookFor, char[] buf, int startAt, int limit) {
        while (startAt < limit) {
            char thischar = buf[startAt];
            int i = 0;
            while (i < lookFor.length) {
                if (thischar == lookFor[i]) {
                    return startAt;
                }
                ++i;
            }
            ++startAt;
        }
        return -1;
    }

    private static int nextMatchingByte(char lookFor, char[] buf, int startAt, int limit) {
        while (startAt < limit) {
            if (buf[startAt] == lookFor) {
                return startAt;
            }
            ++startAt;
        }
        return -1;
    }

    private static int scanAttribute(char[] buf, int startAt, int limit, ScannedAttribute attr) {
        int nameStart = SniffedXmlInputStream.nextNonmatchingByte(WHITESPACE, buf, startAt, limit);
        if (nameStart < 0) {
            return -1;
        }
        int nameEnd = SniffedXmlInputStream.nextMatchingByte(NOTNAME, buf, nameStart, limit);
        if (nameEnd < 0) {
            return -1;
        }
        int equals = SniffedXmlInputStream.nextNonmatchingByte(WHITESPACE, buf, nameEnd, limit);
        if (equals < 0) {
            return -1;
        }
        if (buf[equals] != '=') {
            return -1;
        }
        int valQuote = SniffedXmlInputStream.nextNonmatchingByte(WHITESPACE, buf, equals + 1, limit);
        if (buf[valQuote] != '\'' && buf[valQuote] != '\"') {
            return -1;
        }
        int valEndquote = SniffedXmlInputStream.nextMatchingByte(buf[valQuote], buf, valQuote + 1, limit);
        if (valEndquote < 0) {
            return -1;
        }
        attr.name = new String(buf, nameStart, nameEnd - nameStart);
        attr.value = new String(buf, valQuote + 1, valEndquote - valQuote - 1);
        return valEndquote + 1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$org$apache$xmlbeans$impl$common$SniffedXmlInputStream == null ? (class$org$apache$xmlbeans$impl$common$SniffedXmlInputStream = SniffedXmlInputStream.class$("org.apache.xmlbeans.impl.common.SniffedXmlInputStream")) : class$org$apache$xmlbeans$impl$common$SniffedXmlInputStream).desiredAssertionStatus();
        MAX_SNIFFED_BYTES = 192;
        dummy1 = Charset.forName("UTF-8");
        dummy2 = Charset.forName("UTF-16");
        dummy3 = Charset.forName("UTF-16BE");
        dummy4 = Charset.forName("UTF-16LE");
        dummy5 = Charset.forName("ISO-8859-1");
        dummy6 = Charset.forName("US-ASCII");
        dummy7 = Charset.forName("Cp1252");
        WHITESPACE = new char[]{' ', '\r', '\t', '\n'};
        NOTNAME = new char[]{'=', ' ', '\r', '\t', '\n', '?', '>', '<', '\'', '\"'};
    }

    private static class ScannedAttribute {
        public String name;
        public String value;

        private ScannedAttribute() {
        }
    }
}

