/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.generatepdf.client;

import com.adobe.idp.Document;
import com.adobe.idp.dsc.DSCException;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.livecycle.generatepdf.client.ConversionException;
import com.adobe.livecycle.generatepdf.client.ConvertPDFFormatType;
import com.adobe.livecycle.generatepdf.client.CreatePDFResult;
import com.adobe.livecycle.generatepdf.client.ExportPDFResult;
import com.adobe.livecycle.generatepdf.client.FileFormatNotSupportedException;
import com.adobe.livecycle.generatepdf.client.HtmlToPdfResult;
import com.adobe.livecycle.generatepdf.client.InvalidParameterException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class GeneratePdfServiceClient {
    private static final int CONVERSION_FAILURE = 1000;
    private ServiceClientFactory m_ClientFactory = null;
    private String m_strServiceName = "GeneratePDFService";
    private String m_strVersionNumber = "1.0";
    private static Map<ConvertPDFFormatType, String> m_FormatTypeMapping = new HashMap<ConvertPDFFormatType, String>();

    public GeneratePdfServiceClient(ServiceClientFactory factory) {
        this.m_ClientFactory = factory;
    }

    public CreatePDFResult createPDF(Document inDoc, String inputFileName, String fileTypeSettings, String pdfSettings, String securitySettings, Document inSettingsDoc, Document inXMPDoc) throws InvalidParameterException, ConversionException, FileFormatNotSupportedException {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("inputDocument", inDoc);
        requestMap.put("fileName", inputFileName);
        requestMap.put("fileTypeSettings", fileTypeSettings);
        requestMap.put("pdfSettings", pdfSettings);
        requestMap.put("securitySettings", securitySettings);
        requestMap.put("settingsDocument", inSettingsDoc);
        requestMap.put("xmpDocument", inXMPDoc);
        InvocationRequest request = this.m_ClientFactory.createInvocationRequest(this.m_strServiceName, "CreatePDF", requestMap, true);
        CreatePDFResult result = new CreatePDFResult();
        try {
            InvocationResponse response = this.m_ClientFactory.getServiceClient().invoke(request);
            Map resultMap = (Map)response.getOutputParameter("Result");
            result.setCreatedDocument((Document)resultMap.get("ConvertedDoc"));
            result.setLogDocument((Document)resultMap.get("LogDoc"));
        }
        catch (DSCException e) {
            Serializable rootException = e.getCause();
            if (rootException == null) {
                rootException = new ConversionException(1000, (Throwable)e);
            }
            try {
                throw rootException;
            }
            catch (InvalidParameterException ex) {
                throw ex;
            }
            catch (FileFormatNotSupportedException ex) {
                throw ex;
            }
            catch (ConversionException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new ConversionException(1000, ex);
            }
        }
        return result;
    }

    public HtmlToPdfResult htmlToPDF(String inputUrl, String fileTypeSettingsName, String securitySettingsName, Document inSettingsDoc, Document inXMPDoc) throws InvalidParameterException, ConversionException, FileFormatNotSupportedException {
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("inputURL", inputUrl);
        requestMap.put("fileTypeSettings", fileTypeSettingsName);
        requestMap.put("securitySettings", securitySettingsName);
        requestMap.put("settingsDocument", (String)inSettingsDoc);
        requestMap.put("xmpDocument", (String)inXMPDoc);
        InvocationRequest request = this.m_ClientFactory.createInvocationRequest(this.m_strServiceName, "HtmlToPDF", requestMap, true);
        HtmlToPdfResult result = new HtmlToPdfResult();
        try {
            InvocationResponse response = this.m_ClientFactory.getServiceClient().invoke(request);
            Map resultMap = (Map)response.getOutputParameter("Result");
            result.setCreatedDocument((Document)resultMap.get("ConvertedDoc"));
        }
        catch (DSCException e) {
            Serializable rootException = e.getCause();
            if (rootException == null) {
                rootException = new ConversionException(1000, (Throwable)e);
            }
            try {
                throw rootException;
            }
            catch (InvalidParameterException ex) {
                throw ex;
            }
            catch (FileFormatNotSupportedException ex) {
                throw ex;
            }
            catch (ConversionException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new ConversionException(1000, ex);
            }
        }
        return result;
    }

    public HtmlToPdfResult htmlFileToPDF(Document inputDocument, String fileTypeSettingsName, String securitySettingsName, Document inSettingsDoc, Document inXMPDoc) throws InvalidParameterException, ConversionException, FileFormatNotSupportedException {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("inputDocument", inputDocument);
        requestMap.put("fileTypeSettings", fileTypeSettingsName);
        requestMap.put("securitySettings", securitySettingsName);
        requestMap.put("settingsDocument", inSettingsDoc);
        requestMap.put("xmpDocument", inXMPDoc);
        InvocationRequest request = this.m_ClientFactory.createInvocationRequest(this.m_strServiceName, "HtmlFileToPDF", requestMap, true);
        HtmlToPdfResult result = null;
        try {
            InvocationResponse response = this.m_ClientFactory.getServiceClient().invoke(request);
            result = (HtmlToPdfResult)response.getOutputParameter("Result");
        }
        catch (DSCException e) {
            Serializable rootException = e.getCause();
            if (rootException == null) {
                rootException = new ConversionException(1000, (Throwable)e);
            }
            try {
                throw rootException;
            }
            catch (InvalidParameterException ex) {
                throw ex;
            }
            catch (FileFormatNotSupportedException ex) {
                throw ex;
            }
            catch (ConversionException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new ConversionException(1000, ex);
            }
        }
        return result;
    }

    public ExportPDFResult exportPDF(Document inputDocument, String inputFileName, ConvertPDFFormatType formatType, Document inSettingsDoc) throws InvalidParameterException, ConversionException, FileFormatNotSupportedException {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("inputDocument", inputDocument);
        requestMap.put("fileName", inputFileName);
        requestMap.put("formatType", m_FormatTypeMapping.get((Object)formatType));
        requestMap.put("settingsDocument", inSettingsDoc);
        InvocationRequest request = this.m_ClientFactory.createInvocationRequest(this.m_strServiceName, "ExportPDF", requestMap, true);
        ExportPDFResult result = new ExportPDFResult();
        try {
            InvocationResponse response = this.m_ClientFactory.getServiceClient().invoke(request);
            Map resultMap = (Map)response.getOutputParameter("Result");
            result.setConvertedDocument((Document)resultMap.get("ConvertedDoc"));
        }
        catch (DSCException e) {
            Serializable rootException = e.getCause();
            if (rootException == null) {
                rootException = new ConversionException(1000, (Throwable)e);
            }
            try {
                throw rootException;
            }
            catch (InvalidParameterException ex) {
                throw ex;
            }
            catch (FileFormatNotSupportedException ex) {
                throw ex;
            }
            catch (ConversionException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new ConversionException(1000, ex);
            }
        }
        return result;
    }

    public CreatePDFResult createPDF2(Document inDoc, String inputFileExtension, String fileTypeSettings, String pdfSettings, String securitySettings, Document inSettingsDoc, Document inXMPDoc) throws InvalidParameterException, ConversionException, FileFormatNotSupportedException {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("inputDocument", inDoc);
        requestMap.put("fileExtension", inputFileExtension);
        requestMap.put("fileTypeSettings", fileTypeSettings);
        requestMap.put("pdfSettings", pdfSettings);
        requestMap.put("securitySettings", securitySettings);
        requestMap.put("settingsDocument", inSettingsDoc);
        requestMap.put("xmpDocument", inXMPDoc);
        InvocationRequest request = this.m_ClientFactory.createInvocationRequest(this.m_strServiceName, "CreatePDF2", requestMap, true);
        CreatePDFResult result = null;
        try {
            InvocationResponse response = this.m_ClientFactory.getServiceClient().invoke(request);
            result = (CreatePDFResult)response.getOutputParameter("Result");
        }
        catch (DSCException e) {
            Serializable rootException = e.getCause();
            if (rootException == null) {
                rootException = new ConversionException(1000, (Throwable)e);
            }
            try {
                throw rootException;
            }
            catch (InvalidParameterException ex) {
                throw ex;
            }
            catch (FileFormatNotSupportedException ex) {
                throw ex;
            }
            catch (ConversionException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new ConversionException(1000, ex);
            }
        }
        return result;
    }

    public ExportPDFResult exportPDF2(Document inputDocument, String inputFileExtension, ConvertPDFFormatType formatType, Document inSettingsDoc) throws InvalidParameterException, ConversionException, FileFormatNotSupportedException {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("inputDocument", inputDocument);
        requestMap.put("fileExtension", inputFileExtension);
        requestMap.put("formatType", m_FormatTypeMapping.get((Object)formatType));
        requestMap.put("settingsDocument", inSettingsDoc);
        InvocationRequest request = this.m_ClientFactory.createInvocationRequest(this.m_strServiceName, "ExportPDF2", requestMap, true);
        ExportPDFResult result = null;
        try {
            InvocationResponse response = this.m_ClientFactory.getServiceClient().invoke(request);
            result = (ExportPDFResult)response.getOutputParameter("Result");
        }
        catch (DSCException e) {
            Serializable rootException = e.getCause();
            if (rootException == null) {
                rootException = new ConversionException(1000, (Throwable)e);
            }
            try {
                throw rootException;
            }
            catch (InvalidParameterException ex) {
                throw ex;
            }
            catch (FileFormatNotSupportedException ex) {
                throw ex;
            }
            catch (ConversionException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new ConversionException(1000, ex);
            }
        }
        return result;
    }

    public HtmlToPdfResult htmlToPDF2(String inputUrl, String fileTypeSettingsName, String securitySettingsName, Document inSettingsDoc, Document inXMPDoc) throws InvalidParameterException, ConversionException, FileFormatNotSupportedException {
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("inputURL", inputUrl);
        requestMap.put("fileTypeSettings", fileTypeSettingsName);
        requestMap.put("securitySettings", securitySettingsName);
        requestMap.put("settingsDocument", (String)inSettingsDoc);
        requestMap.put("xmpDocument", (String)inXMPDoc);
        InvocationRequest request = this.m_ClientFactory.createInvocationRequest(this.m_strServiceName, "HtmlToPDF2", requestMap, true);
        HtmlToPdfResult result = null;
        try {
            InvocationResponse response = this.m_ClientFactory.getServiceClient().invoke(request);
            result = (HtmlToPdfResult)response.getOutputParameter("Result");
        }
        catch (DSCException e) {
            Serializable rootException = e.getCause();
            if (rootException == null) {
                rootException = new ConversionException(1000, (Throwable)e);
            }
            try {
                throw rootException;
            }
            catch (InvalidParameterException ex) {
                throw ex;
            }
            catch (FileFormatNotSupportedException ex) {
                throw ex;
            }
            catch (ConversionException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new ConversionException(1000, ex);
            }
        }
        return result;
    }

    static {
        m_FormatTypeMapping.put(ConvertPDFFormatType.EPS, "EPS");
        m_FormatTypeMapping.put(ConvertPDFFormatType.HTML32, "HTML32");
        m_FormatTypeMapping.put(ConvertPDFFormatType.HTML40, "HTML40");
        m_FormatTypeMapping.put(ConvertPDFFormatType.DOC, "DOC");
        m_FormatTypeMapping.put(ConvertPDFFormatType.RTF, "RTF");
        m_FormatTypeMapping.put(ConvertPDFFormatType.AccessibleText, "Accessible-Text");
        m_FormatTypeMapping.put(ConvertPDFFormatType.PlainText, "Plain-Text");
        m_FormatTypeMapping.put(ConvertPDFFormatType.XML10, "XML10");
    }
}

