/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.util;

import com.adobe.framework.Base64;
import com.adobe.util.FileCollector;
import com.adobe.util.PathToRandomAccessFileMap;
import com.adobe.util.RandomAccessFileBox;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public abstract class FileUtil {
    private static SecureRandom _random;
    public static final char[] digits36;
    public static int FILE_BLOCK_SIZE;
    public static final String SESSION_DIR_PREFIX = "session";
    public static final String DOCMAN_DIR_PREFIX = "docm";
    public static final String DATAMAN_DIR_PREFIX = "datam";
    public static final String REMOVEON_DIR_PREFIX = "removeOn";
    public static final String REMOVAL_MARKER = ".remove";
    public static final String DEL_MARKER = ".del";
    public static final String EXPIRATION_FILE_MARKER = ".expiresOn";
    public static final String SESSION_FILE_MARKER = ".session";
    public static final String DATAMAN_REMOVAL_MARKER = "remove";
    public static final String STALE_MARKER = ".stale";
    protected static String _timeFormat;

    public static String getRandomFileName() {
        if (_random == null) {
            try {
                _random = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        byte[] bytes = new byte[16];
        _random.nextBytes(bytes);
        StringBuffer name = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            String str = Integer.toHexString(b);
            int len = str.length();
            str = len < 2 ? "0" + str : str.substring(len - 2, len);
            name.append(str);
        }
        return name.toString();
    }

    public static String getRandomFileNameBase64() {
        if (_random == null) {
            try {
                _random = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        byte[] bytes = new byte[16];
        _random.nextBytes(bytes);
        String name = Base64.encodeBytes((byte[])bytes);
        name = name.replace('+', '!');
        name = name.replace('/', '-');
        name = name.replace("=", "");
        return name;
    }

    public static String getRandomFileNameBase36(int extraBit) {
        if (_random == null) {
            try {
                _random = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        char[] buf = new char[25];
        int r = 0;
        for (int i = 1; i < buf.length; ++i) {
            r = _random.nextInt(36);
            buf[i] = digits36[r];
        }
        r = _random.nextInt(16);
        buf[0] = digits36[r | extraBit * 16];
        return new String(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File source, File target) throws IOException {
        FileInputStream fis = new FileInputStream(source);
        FileOutputStream fos = new FileOutputStream(target, false);
        FileCollector.debugReportFileChange((File)source, (String)"read");
        FileCollector.debugReportFileChange((File)target, (String)"write");
        try {
            byte[] buf = new byte[FILE_BLOCK_SIZE];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        }
        finally {
            try {
                FileCollector.debugReportFileChange((File)source, (String)"readClose");
                fis.close();
            }
            finally {
                FileCollector.debugReportFileChange((File)target, (String)"writeClose");
                fos.close();
            }
        }
    }

    public static void move(File source, File target) throws IOException {
        if (target.exists()) {
            FileCollector.debugReportFileChange((File)target, (String)"deleteMove");
            FileCollector.clientDelete((File)target);
        }
        FileCollector.debugReportFileChange((File)target, (String)"renameTarget");
        if (!source.renameTo(target)) {
            FileCollector.debugReportFileChange((File)target, (String)"copyTarget");
            FileUtil.copy(source, target);
            if (!FileCollector.clientDelete((File)source)) {
                throw new IOException("Failed to delete file \"" + source + "\". Make sure that the file is not locked.");
            }
        }
    }

    public static String sessionToDirName(String session) {
        return SESSION_DIR_PREFIX + session;
    }

    public static String timeToDirName(long time) {
        return DOCMAN_DIR_PREFIX + Long.toString(time);
    }

    public static String timeToExpPostfix(long time) {
        return EXPIRATION_FILE_MARKER + Long.toString(time);
    }

    public static long dirNameToTime(String dirName) {
        if (!dirName.startsWith(REMOVEON_DIR_PREFIX)) {
            return 0L;
        }
        try {
            return new Long(dirName.substring(dirName.lastIndexOf(".") + 1));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] randomAccessRead(File file, long position, int size, PathToRandomAccessFileMap pathToFileMap) throws IOException {
        RandomAccessFile raf = null;
        String path = file.getAbsolutePath();
        RandomAccessFileBox box = null;
        long length = -1L;
        long curPosition = -1L;
        if (pathToFileMap != null && (box = pathToFileMap.getRandomAccessFileBox(path)) != null) {
            raf = box.getRandomAccessFile();
            length = box.getLength();
            curPosition = box.getPosition();
        }
        if (raf == null) {
            raf = new RandomAccessFile(file, "r");
            length = raf.length();
        }
        FileCollector.debugReportFileChange((File)file, (String)"randomAccessFileRead");
        try {
            if (curPosition != position || curPosition == -1L) {
                raf.seek(position);
            }
            if (position > length - (long)size) {
                size = (int)(length - position);
            }
            byte[] buf = new byte[size];
            raf.readFully(buf);
            if (pathToFileMap != null && position + (long)size < length) {
                if (box == null) {
                    box = new RandomAccessFileBox(raf);
                    box.setLength(length);
                }
                box.setPosition(position + (long)size);
                pathToFileMap.putRandomAccessFileBox(path, box);
                raf = null;
            }
            byte[] byArray = buf;
            return byArray;
        }
        finally {
            FileCollector.debugReportFileChange((File)file, (String)"randomAccessFileClose");
            if (raf != null) {
                raf.close();
            }
        }
    }

    static {
        digits36 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        FILE_BLOCK_SIZE = 16384;
        _timeFormat = "yyyy'Y'MM'M'dd'D'HH'h'mm'm'ss's'";
    }
}

