/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.service.logging;

public class Level {
    public static final int OFF_INT = Integer.MAX_VALUE;
    public static final int FATAL_INT = 0;
    public static final int ALERT_INT = 1;
    public static final int CRITICAL_INT = 2;
    public static final int ERROR_INT = 3;
    public static final int WARN_INT = 4;
    public static final int NOTICE_INT = 5;
    public static final int INFO_INT = 6;
    public static final int DEBUG_INT = 7;
    public static final int ALL_INT = Integer.MIN_VALUE;
    public static final int JDK_FINEST_INT = 100;
    public static final int JDK_FINER_INT = 101;
    public static final int JDK_FINE_INT = 102;
    public static final int JDK_CONFIG_INT = 103;
    public static final int JDK_INFO_INT = 104;
    public static final int JDK_WARNING_INT = 105;
    public static final int JDK_SEVERE_INT = 106;
    private static String OFF_STR = "OFF";
    private static String FATAL_STR = "FATAL";
    private static String ALERT_STR = "ALERT";
    private static String CRITICAL_STR = "CRITICAL";
    private static String ERROR_STR = "ERROR";
    private static String WARN_STR = "WARN";
    private static String NOTICE_STR = "NOTICE";
    private static String INFO_STR = "INFO";
    private static String DEBUG_STR = "DEBUG";
    private static String ALL_STR = "ALL";
    public static final Level OFF = new Level(Integer.MAX_VALUE, OFF_STR, java.util.logging.Level.OFF);
    public static final Level FATAL = new Level(0, FATAL_STR, java.util.logging.Level.SEVERE);
    public static final Level ALERT = new Level(1, ALERT_STR, java.util.logging.Level.SEVERE);
    public static final Level CRITICAL = new Level(2, CRITICAL_STR, java.util.logging.Level.SEVERE);
    public static final Level ERROR = new Level(3, ERROR_STR, java.util.logging.Level.SEVERE);
    public static final Level WARN = new Level(4, WARN_STR, java.util.logging.Level.WARNING);
    public static final Level NOTICE = new Level(5, NOTICE_STR, java.util.logging.Level.INFO);
    public static final Level INFO = new Level(6, INFO_STR, java.util.logging.Level.INFO);
    public static final Level DEBUG = new Level(7, DEBUG_STR, java.util.logging.Level.FINE);
    public static final Level ALL = new Level(Integer.MIN_VALUE, ALL_STR, java.util.logging.Level.ALL);
    private final String name;
    private final int value;
    private final java.util.logging.Level jdkLevel;

    private Level(int value, String name, java.util.logging.Level jdkLevel) {
        this.value = value;
        this.name = name;
        this.jdkLevel = jdkLevel;
    }

    public static Level toLevel(String sArg) {
        Level defaultLevel = NOTICE;
        if (sArg == null) {
            return defaultLevel;
        }
        String stringVal = sArg.toUpperCase();
        if (stringVal.equals(OFF_STR)) {
            return OFF;
        }
        if (stringVal.equals(FATAL_STR)) {
            return FATAL;
        }
        if (stringVal.equals(ALERT_STR)) {
            return ALERT;
        }
        if (stringVal.equals(CRITICAL_STR)) {
            return CRITICAL;
        }
        if (stringVal.equals(ERROR_STR)) {
            return ERROR;
        }
        if (stringVal.equals(WARN_STR)) {
            return WARN;
        }
        if (stringVal.equals(NOTICE_STR)) {
            return NOTICE;
        }
        if (stringVal.equals(INFO_STR)) {
            return INFO;
        }
        if (stringVal.equals(DEBUG_STR)) {
            return DEBUG;
        }
        if (stringVal.equals(ALL_STR)) {
            return ALL;
        }
        return defaultLevel;
    }

    public static Level toLevel(int i) {
        switch (i) {
            case 0x7FFFFFFF: {
                return OFF;
            }
            case 0: {
                return FATAL;
            }
            case 1: {
                return ALERT;
            }
            case 2: {
                return CRITICAL;
            }
            case 3: {
                return ERROR;
            }
            case 4: {
                return WARN;
            }
            case 5: {
                return NOTICE;
            }
            case 6: {
                return INFO;
            }
            case 7: {
                return DEBUG;
            }
            case -2147483648: {
                return ALL;
            }
        }
        return DEBUG;
    }

    public static java.util.logging.Level toJdkLevel(int i) {
        switch (i) {
            case 106: {
                return java.util.logging.Level.SEVERE;
            }
            case 105: {
                return java.util.logging.Level.WARNING;
            }
            case 104: {
                return java.util.logging.Level.INFO;
            }
            case 103: {
                return java.util.logging.Level.CONFIG;
            }
            case 102: {
                return java.util.logging.Level.FINE;
            }
            case 101: {
                return java.util.logging.Level.FINER;
            }
            case 100: {
                return java.util.logging.Level.FINEST;
            }
        }
        return java.util.logging.Level.FINE;
    }

    public static int toIntLevel(java.util.logging.Level jdk) {
        if (jdk == java.util.logging.Level.SEVERE) {
            return 106;
        }
        if (jdk == java.util.logging.Level.WARNING) {
            return 105;
        }
        if (jdk == java.util.logging.Level.INFO) {
            return 104;
        }
        if (jdk == java.util.logging.Level.CONFIG) {
            return 103;
        }
        if (jdk == java.util.logging.Level.FINE) {
            return 102;
        }
        if (jdk == java.util.logging.Level.FINER) {
            return 101;
        }
        if (jdk == java.util.logging.Level.FINEST) {
            return 100;
        }
        return 102;
    }

    public final String getName() {
        return this.name;
    }

    public final String toString() {
        return this.name;
    }

    public final int intValue() {
        return this.value;
    }

    public final java.util.logging.Level jdkLevel() {
        return this.jdkLevel;
    }
}

