/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.server.context;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class ContextMap {
    public static final int NULL_CONTEXT = 0;
    private static int nextContextId = 1;
    private static TransactionManager tm = null;
    private static Map mTransactionMap = new WeakHashMap();
    private static Map mCtxIdMap = new WeakHashMap();

    static synchronized int getContextId() {
        int ctxId = 0;
        if (tm == null) {
            try {
                InitialContext namingContext = new InitialContext();
                tm = (TransactionManager)namingContext.lookup("java:/TransactionManager");
            }
            catch (NamingException e) {
                throw new IllegalStateException("No transaction manager " + e);
            }
        }
        try {
            Transaction trans = tm.getTransaction();
            Integer I = (Integer)mTransactionMap.get(trans);
            if (I == null) {
                ctxId = nextContextId++;
                I = new Integer(ctxId);
                mTransactionMap.put(trans, I);
                mCtxIdMap.put(I, new WeakReference<Transaction>(trans));
            } else {
                ctxId = I;
            }
            return ctxId;
        }
        catch (SystemException e) {
            return 0;
        }
    }

    static synchronized void switchContext(int contextId) {
        Transaction trans;
        WeakReference ref = (WeakReference)mCtxIdMap.get(new Integer(contextId));
        if (ref != null && (trans = (Transaction)ref.get()) != null) {
            try {
                if (tm != null) {
                    tm.resume(trans);
                }
            }
            catch (InvalidTransactionException e) {
            }
            catch (SystemException systemException) {
                // empty catch block
            }
        }
    }

    static synchronized void suspendContext() {
        try {
            Transaction trans;
            if (tm != null && (trans = tm.getTransaction()) != null) {
                tm.suspend();
            }
        }
        catch (SystemException systemException) {
            // empty catch block
        }
    }
}

