/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.logging;

import com.adobe.logging.AdobeLogger;
import java.text.MessageFormat;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

abstract class AdobeLoggerImplBase
extends AdobeLogger {
    protected final Logger jdkLogger;
    static boolean delegateToJDK = false;
    private Level loggerLevel = null;
    protected static final int _ALL;
    protected static final int _FINEST;
    protected static final int _FINER;
    protected static final int _FINE;
    protected static final int _CONFIG;
    protected static final int _INFO;
    protected static final int _WARNING;
    protected static final int _SEVERE;
    protected static final int _OFF;

    protected AdobeLoggerImplBase(String name, String resourceBundleName) {
        super(name, resourceBundleName);
        this.jdkLogger = delegateToJDK ? Logger.getLogger(name, resourceBundleName) : null;
        super.setLevel(Level.ALL);
    }

    private static boolean yesno(String s, boolean def) {
        if (s == null) {
            return def;
        }
        if ((s = s.trim()).length() == 0) {
            return def;
        }
        if ((s = s.toLowerCase()).startsWith("f")) {
            return false;
        }
        if (s.startsWith("n")) {
            return false;
        }
        return !s.startsWith("0");
    }

    protected void doSetLevel(Level newLevel) {
    }

    public void setLevel(Level newLevel) {
        this.loggerLevel = newLevel;
        if (this.jdkLogger != null) {
            this.jdkLogger.setLevel(newLevel);
        }
        this.doSetLevel(newLevel);
    }

    public Level getLevel() {
        if (this.jdkLogger != null) {
            return this.jdkLogger.getLevel();
        }
        return this.loggerLevel;
    }

    protected abstract boolean checkLoggable(Level var1);

    public boolean isLoggable(Level level) {
        if (this.jdkLogger != null && this.jdkLogger.isLoggable(level)) {
            return true;
        }
        return this.checkLoggable(level);
    }

    protected abstract void logImpl(LogRecord var1);

    public void log(Level level, String msg) {
        if (this.isLoggable(level)) {
            this.logIt(level, msg, null);
        }
    }

    public void log(Level level, String msg, Object param1) {
        if (this.isLoggable(level)) {
            this.logIt(level, msg, new Object[]{param1});
        }
    }

    public void log(Level level, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            this.logIt(level, msg, params);
        }
    }

    public void log(Level level, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            LogRecord r = this.logRecord(level, msg, null);
            r.setThrown(thrown);
            this.logIt(r);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord r = this.logRecord(level, msg, null, sourceClass, sourceMethod);
        this.logIt(r);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord r = this.logRecord(level, msg, new Object[]{param1}, sourceClass, sourceMethod);
        this.logIt(r);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord r = this.logRecord(level, msg, params, sourceClass, sourceMethod);
        this.logIt(r);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord r = this.logRecord(level, msg, null, sourceClass, sourceMethod);
        r.setThrown(thrown);
        this.logIt(r);
    }

    protected void addUniqueIdInMessage(LogRecord logRecord) {
        if (this.isLoggable(Level.FINE)) {
            StringBuffer _msg = new StringBuffer(Long.toString(Thread.currentThread().getId())).append(":").append(logRecord.getSourceClassName());
            logRecord.setSourceClassName(_msg.toString());
        }
    }

    protected void logIt(Level level, String msg, Object[] params) {
        LogRecord r = this.logRecord(level, msg, params);
        this.logIt(r);
    }

    protected void logIt(Level level, String msg, Object[] params, Throwable thrown) {
        LogRecord r = this.logRecord(level, msg, params);
        r.setThrown(thrown);
        this.logIt(r);
    }

    protected void logIt(LogRecord logRecord) {
        this.addUniqueIdInMessage(logRecord);
        if (this.jdkLogger != null) {
            this.jdkLogger.log(logRecord);
        }
        this.logImpl(logRecord);
    }

    public void log(LogRecord record) {
        if (!this.isLoggable(record.getLevel())) {
            return;
        }
        this.addUniqueIdInMessage(record);
        if (this.jdkLogger != null) {
            this.jdkLogger.log(record);
        }
        this.logImpl(record);
    }

    protected static String fastFormat(String msg, Object[] args) {
        try {
            if (args == null || args.length == 0) {
                return msg;
            }
            StringBuffer res = new StringBuffer();
            int pos = 0;
            int cursor = 0;
            int len = msg.length();
            while (cursor < len) {
                char c;
                if ((c = msg.charAt(cursor++)) == '{') {
                    String numStr;
                    int paramNum;
                    int loc = cursor;
                    while (cursor < len && msg.charAt(cursor) != '}') {
                        ++cursor;
                    }
                    if (cursor >= len) break;
                    if ((paramNum = Integer.parseInt(numStr = msg.substring(loc, cursor++))) >= args.length) continue;
                    res.append(msg.substring(pos, loc - 1));
                    if (args[paramNum] == null) {
                        res.append("null");
                    } else {
                        res.append(args[paramNum].toString());
                    }
                    pos = cursor;
                    continue;
                }
                if (c != '\'' || cursor >= len) continue;
                res.append(msg.substring(pos, cursor - 1));
                pos = cursor;
                c = msg.charAt(cursor++);
                if (c == '\'') {
                    res.append(c);
                } else {
                    while (cursor < len) {
                        if (msg.charAt(cursor++) != '\'') continue;
                        if (cursor >= len || msg.charAt(cursor) != '\'') break;
                        res.append(msg.substring(pos, cursor++));
                        pos = cursor;
                    }
                    int n = --cursor;
                    ++cursor;
                    res.append(msg.substring(pos, n));
                }
                pos = cursor;
            }
            if (pos < len) {
                res.append(msg.substring(pos, len));
            }
            return res.toString();
        }
        catch (NumberFormatException e) {
            return MessageFormat.format(msg, args);
        }
    }

    public void severe(String msg) {
        if (this.isLoggable(Level.SEVERE)) {
            this.logIt(Level.SEVERE, msg, null);
        }
    }

    public void warning(String msg) {
        if (this.isLoggable(Level.WARNING)) {
            this.logIt(Level.WARNING, msg, null);
        }
    }

    public void info(String msg) {
        if (this.isLoggable(Level.INFO)) {
            this.logIt(Level.INFO, msg, null);
        }
    }

    public void config(String msg) {
        if (this.isLoggable(Level.CONFIG)) {
            this.logIt(Level.CONFIG, msg, null);
        }
    }

    public void fine(String msg) {
        if (this.isLoggable(Level.FINE)) {
            this.logIt(Level.FINE, msg, null);
        }
    }

    public void finer(String msg) {
        if (this.isLoggable(Level.FINER)) {
            this.logIt(Level.FINER, msg, null);
        }
    }

    public void finest(String msg) {
        if (this.isLoggable(Level.FINEST)) {
            this.logIt(Level.FINEST, msg, null);
        }
    }

    public void entering(String sourceClass, String sourceMethod) {
        if (!this.isLoggable(Level.FINER)) {
            return;
        }
        LogRecord r = this.logRecord(Level.FINER, "ENTRY", null, sourceClass, sourceMethod);
        this.logIt(r);
    }

    public void entering(String sourceClass, String sourceMethod, Object param1) {
        if (!this.isLoggable(Level.FINER)) {
            return;
        }
        LogRecord r = this.logRecord(Level.FINER, "ENTRY {0}", new Object[]{param1}, sourceClass, sourceMethod);
        this.logIt(r);
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        String msg;
        if (!this.isLoggable(Level.FINER)) {
            return;
        }
        switch (params.length) {
            case 0: {
                msg = "ENTRY";
                break;
            }
            case 1: {
                msg = "ENTRY {0}";
                break;
            }
            case 2: {
                msg = "ENTRY {0} {1}";
                break;
            }
            case 3: {
                msg = "ENTRY {0} {1} {2}";
                break;
            }
            default: {
                StringBuffer buf = new StringBuffer("ENTRY {0} {1} {2} {3}");
                for (int i = 4; i < params.length; ++i) {
                    buf.append(" {");
                    buf.append(i);
                    buf.append('}');
                }
                msg = buf.toString();
            }
        }
        LogRecord r = this.logRecord(Level.FINER, msg, params, sourceClass, sourceMethod);
        this.logIt(r);
    }

    public void exiting(String sourceClass, String sourceMethod) {
        if (!this.isLoggable(Level.FINER)) {
            return;
        }
        LogRecord r = this.logRecord(Level.FINER, "RETURN", null, sourceClass, sourceMethod);
        this.logIt(r);
    }

    public void exiting(String sourceClass, String sourceMethod, Object result) {
        if (!this.isLoggable(Level.FINER)) {
            return;
        }
        LogRecord r = this.logRecord(Level.FINER, "RETURN {0}", new Object[]{result}, sourceClass, sourceMethod);
        this.logIt(r);
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        if (!this.isLoggable(Level.FINER)) {
            return;
        }
        LogRecord r = this.logRecord(Level.FINER, "THROW", null, sourceClass, sourceMethod);
        r.setThrown(thrown);
        this.logIt(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        LogManager mgr = LogManager.getLogManager();
        String logfile = mgr.getProperty("adobe.logfile");
        if (logfile != null) {
            Logger adobeRoot;
            delegateToJDK = true;
            Logger logger = adobeRoot = Logger.getLogger("com.adobe");
            synchronized (logger) {
                Handler[] handlers = adobeRoot.getHandlers();
                if (handlers.length == 0) {
                    String s;
                    int limit = 0x200000;
                    int count = 4;
                    try {
                        s = mgr.getProperty("adobe.logfile.limit");
                        if (s != null) {
                            limit = Integer.parseInt(s);
                        }
                        if (limit < 10000) {
                            limit *= 1024;
                        }
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    try {
                        s = mgr.getProperty("adobe.logfile.count");
                        if (s != null) {
                            count = Integer.parseInt(s);
                        }
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    boolean append = AdobeLoggerImplBase.yesno(mgr.getProperty("adobe.logfile.append"), false);
                    boolean useParent = AdobeLoggerImplBase.yesno(mgr.getProperty("adobe.logfile.useParent"), false);
                    try {
                        FileHandler handler = new FileHandler(logfile, limit, count, append);
                        SimpleFormatter formatter = new SimpleFormatter();
                        handler.setFormatter(formatter);
                        adobeRoot.addHandler(handler);
                        adobeRoot.setUseParentHandlers(useParent);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        _ALL = Level.ALL.intValue();
        _FINEST = Level.FINEST.intValue();
        _FINER = Level.FINER.intValue();
        _FINE = Level.FINE.intValue();
        _CONFIG = Level.CONFIG.intValue();
        _INFO = Level.INFO.intValue();
        _WARNING = Level.WARNING.intValue();
        _SEVERE = Level.SEVERE.intValue();
        _OFF = Level.OFF.intValue();
    }
}

