/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.logging;

import com.adobe.logging.AdobeLoggerImplBase;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

final class AdobeLoggerImpl
extends AdobeLoggerImplBase {
    final Logger delegate;

    AdobeLoggerImpl(String name, String resourceBundleName) {
        super(name, resourceBundleName);
        AdobeLoggerImplBase.delegateToJDK = true;
        this.delegate = this.jdkLogger == null ? Logger.getLogger(name, resourceBundleName) : this.jdkLogger;
        this.delegate.setLevel(Level.INFO);
    }

    public boolean checkLoggable(Level level) {
        Level logLevel;
        int loggerLevel;
        int testLevel = level.intValue();
        return testLevel > (loggerLevel = (logLevel = this.getLevel(this.delegate)).intValue());
    }

    public synchronized void addHandler(Handler handler) throws SecurityException {
        this.delegate.addHandler(handler);
    }

    protected void logImpl(LogRecord record) {
        String msg = AdobeLoggerImpl.fastFormat(record.getMessage(), record.getParameters());
        Level level = record.getLevel();
        String mthdName = record.getSourceMethodName();
        if (level.intValue() <= _FINE && mthdName != null) {
            msg = record.getSourceClassName() + '.' + mthdName + ' ' + msg;
        }
        this.logImpl(level, msg, record.getThrown());
    }

    private void logImpl(Level userLevel, String msg, Throwable thrown) {
        if (thrown != null) {
            this.delegate.log(userLevel, msg, thrown);
        } else {
            this.delegate.finest(msg);
        }
    }

    private Level getLevel(Logger logger) {
        Level _level = logger.getLevel();
        if (_level == null) {
            Logger _parent = logger.getParent();
            if (_parent != null) {
                return this.getLevel(_parent);
            }
            return Level.INFO;
        }
        return _level;
    }

    static {
        delegateToJDK = true;
    }
}

