/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.logging;

import com.adobe.logging.AdobeLogManager;
import com.adobe.logging.AdobeLoggerImplBase;
import com.adobe.logging.Msg;
import com.adobe.logging.Msg0;
import com.adobe.logging.Msg1;
import com.adobe.logging.Msg2;
import com.adobe.logging.Msg3;
import com.adobe.logging.Msg4;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class AdobeLogger
extends Logger {
    private static AdobeLogManager adobeLogManager = new BootstrapLogManager();
    private static final String adobeLoggerImplBaseName = AdobeLoggerImplBase.class.getName();
    private static final String adobeLoggerName = AdobeLogger.class.getName();
    private static final String loggerClassName = Logger.class.getName();

    protected AdobeLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
        super.setLevel(Level.ALL);
    }

    public static Logger getLogger(String name) {
        return AdobeLogger.getLogger(name, null);
    }

    public static synchronized Logger getLogger(String name, String resourceBundleName) {
        return adobeLogManager.getAdobeLogger(name, resourceBundleName);
    }

    public static AdobeLogger getAdobeLogger(String name) {
        return AdobeLogger.getAdobeLogger(name, null);
    }

    public static synchronized AdobeLogger getAdobeLogger(String name, String resourceBundleName) {
        return adobeLogManager.getAdobeLogger(name, resourceBundleName);
    }

    public static AdobeLogger getAdobeLogger(Class cls) {
        return AdobeLogger.getAdobeLogger(cls, null);
    }

    public static AdobeLogger getAdobeLogger(Class cls, String resourceBundleName) {
        return AdobeLogger.getAdobeLogger(cls.getName(), resourceBundleName);
    }

    protected void logIt(Level level, String msg, Object[] params) {
        LogRecord r = this.logRecord(level, msg, params);
        this.log(r);
    }

    protected void logIt(Level level, String msg, Object[] params, Throwable thrown) {
        LogRecord r = this.logRecord(level, msg, params);
        r.setThrown(thrown);
        this.log(r);
    }

    protected final LogRecord logRecord(Level level, String msg, Object[] params) {
        String clsName = null;
        String methodName = null;
        String thisClassName = this.getClass().getName();
        StackTraceElement[] stk = new Throwable().getStackTrace();
        for (int i = 1; i < stk.length; ++i) {
            String cls = stk[i].getClassName();
            String mthd = stk[i].getMethodName();
            if (thisClassName.equals(cls) || adobeLoggerImplBaseName.equals(cls) || adobeLoggerName.equals(cls) || loggerClassName.equals(cls)) continue;
            clsName = cls;
            methodName = mthd;
            break;
        }
        return this.logRecord(level, msg, params, clsName, methodName);
    }

    protected final LogRecord logRecord(Level level, String msg, Object[] params, String clsName, String methodName) {
        LogRecord r = new LogRecord(level, msg);
        if (params != null) {
            r.setParameters(params);
        }
        r.setLoggerName(this.getName());
        r.setSourceClassName(clsName);
        r.setSourceMethodName(methodName);
        return r;
    }

    protected String getMessageText(Msg msg) {
        String id = msg.id;
        String text = msg.msgText;
        ResourceBundle res = this.getResourceBundle();
        if (res != null) {
            try {
                text = res.getString(id);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        return id + ": " + text;
    }

    public final void log(Msg0 msg) {
        if (this.isLoggable(msg.level)) {
            this.logIt(msg.level, this.getMessageText(msg), null);
        }
    }

    public final void log(Throwable thrown, Msg0 msg) {
        if (this.isLoggable(msg.level)) {
            this.logIt(msg.level, this.getMessageText(msg), null, thrown);
        }
    }

    public final void log(Msg1 msg, Object param1) {
        if (this.isLoggable(msg.level)) {
            this.logIt(msg.level, this.getMessageText(msg), new Object[]{param1});
        }
    }

    public final void log(Throwable thrown, Msg1 msg, Object param1) {
        if (this.isLoggable(msg.level)) {
            this.logIt(msg.level, this.getMessageText(msg), new Object[]{param1}, thrown);
        }
    }

    public final void log(Msg2 msg, Object param1, Object param2) {
        if (this.isLoggable(msg.level)) {
            this.logIt(msg.level, this.getMessageText(msg), new Object[]{param1, param2});
        }
    }

    public final void log(Throwable thrown, Msg2 msg, Object param1, Object param2) {
        if (this.isLoggable(msg.level)) {
            this.logIt(msg.level, this.getMessageText(msg), new Object[]{param1, param2}, thrown);
        }
    }

    public final void log(Msg3 msg, Object param1, Object param2, Object param3) {
        if (this.isLoggable(msg.level)) {
            this.logIt(msg.level, this.getMessageText(msg), new Object[]{param1, param2, param3});
        }
    }

    public final void log(Throwable thrown, Msg3 msg, Object param1, Object param2, Object param3) {
        if (this.isLoggable(msg.level)) {
            this.logIt(msg.level, this.getMessageText(msg), new Object[]{param1, param2, param3}, thrown);
        }
    }

    public final void log(Msg4 msg, Object param1, Object param2, Object param3, Object param4) {
        if (this.isLoggable(msg.level)) {
            this.logIt(msg.level, this.getMessageText(msg), new Object[]{param1, param2, param3, param4});
        }
    }

    public final void log(Throwable thrown, Msg4 msg, Object param1, Object param2, Object param3, Object param4) {
        if (this.isLoggable(msg.level)) {
            this.logIt(msg.level, this.getMessageText(msg), new Object[]{param1, param2, param3, param4}, thrown);
        }
    }

    public final void log(Msg msg, Object[] params) {
        if (this.isLoggable(msg.level)) {
            this.logIt(msg.level, this.getMessageText(msg), params);
        }
    }

    public final void log(Throwable thrown, Msg msg, Object[] params) {
        if (this.isLoggable(msg.level)) {
            this.logIt(msg.level, this.getMessageText(msg), params, thrown);
        }
    }

    public final void detail(String msg) {
        if (this.isLoggable(Level.FINE)) {
            this.logIt(Level.FINE, msg, null);
        }
    }

    public final void detail(Throwable thrown, String msg) {
        if (this.isLoggable(Level.FINE)) {
            this.logIt(Level.FINE, msg, null, thrown);
        }
    }

    public final void detail(String msg, Object param1) {
        if (this.isLoggable(Level.FINE)) {
            this.logIt(Level.FINE, msg, new Object[]{param1});
        }
    }

    public final void detail(Throwable thrown, String msg, Object param1) {
        if (this.isLoggable(Level.FINE)) {
            this.logIt(Level.FINE, msg, new Object[]{param1}, thrown);
        }
    }

    public final void detail(String msg, Object param1, Object param2) {
        if (this.isLoggable(Level.FINE)) {
            this.logIt(Level.FINE, msg, new Object[]{param1, param2});
        }
    }

    public final void detail(Throwable thrown, String msg, Object param1, Object param2) {
        if (this.isLoggable(Level.FINE)) {
            this.logIt(Level.FINE, msg, new Object[]{param1, param2}, thrown);
        }
    }

    public final void detail(String msg, Object param1, Object param2, Object param3) {
        if (this.isLoggable(Level.FINE)) {
            this.logIt(Level.FINE, msg, new Object[]{param1, param2, param3});
        }
    }

    public final void detail(Throwable thrown, String msg, Object param1, Object param2, Object param3) {
        if (this.isLoggable(Level.FINE)) {
            this.logIt(Level.FINE, msg, new Object[]{param1, param2, param3}, thrown);
        }
    }

    public final void debug(String msg) {
        if (this.isLoggable(Level.FINER)) {
            this.logIt(Level.FINER, msg, null);
        }
    }

    public final void debug(Throwable thrown, String msg) {
        if (this.isLoggable(Level.FINER)) {
            this.logIt(Level.FINER, msg, null, thrown);
        }
    }

    public final void debug(String msg, Object param1) {
        if (this.isLoggable(Level.FINER)) {
            this.logIt(Level.FINER, msg, new Object[]{param1});
        }
    }

    public final void debug(Throwable thrown, String msg, Object param1) {
        if (this.isLoggable(Level.FINER)) {
            this.logIt(Level.FINER, msg, new Object[]{param1}, thrown);
        }
    }

    public final void debug(String msg, Object param1, Object param2) {
        if (this.isLoggable(Level.FINER)) {
            this.logIt(Level.FINER, msg, new Object[]{param1, param2});
        }
    }

    public final void debug(Throwable thrown, String msg, Object param1, Object param2) {
        if (this.isLoggable(Level.FINER)) {
            this.logIt(Level.FINER, msg, new Object[]{param1, param2}, thrown);
        }
    }

    public final void debug(String msg, Object param1, Object param2, Object param3) {
        if (this.isLoggable(Level.FINER)) {
            this.logIt(Level.FINER, msg, new Object[]{param1, param2, param3});
        }
    }

    public final void debug(Throwable thrown, String msg, Object param1, Object param2, Object param3) {
        if (this.isLoggable(Level.FINER)) {
            this.logIt(Level.FINER, msg, new Object[]{param1, param2, param3}, thrown);
        }
    }

    public final void trace(String msg) {
        if (this.isLoggable(Level.FINEST)) {
            this.logIt(Level.FINEST, msg, null);
        }
    }

    public final void trace(Throwable thrown, String msg) {
        if (this.isLoggable(Level.FINEST)) {
            this.logIt(Level.FINEST, msg, null, thrown);
        }
    }

    public final void trace(String msg, Object param1) {
        if (this.isLoggable(Level.FINEST)) {
            this.logIt(Level.FINEST, msg, new Object[]{param1});
        }
    }

    public final void trace(Throwable thrown, String msg, Object param1) {
        if (this.isLoggable(Level.FINEST)) {
            this.logIt(Level.FINEST, msg, new Object[]{param1}, thrown);
        }
    }

    public final void trace(String msg, Object param1, Object param2) {
        if (this.isLoggable(Level.FINEST)) {
            this.logIt(Level.FINEST, msg, new Object[]{param1, param2});
        }
    }

    public final void trace(Throwable thrown, String msg, Object param1, Object param2) {
        if (this.isLoggable(Level.FINEST)) {
            this.logIt(Level.FINEST, msg, new Object[]{param1, param2}, thrown);
        }
    }

    public final void trace(String msg, Object param1, Object param2, Object param3) {
        if (this.isLoggable(Level.FINEST)) {
            this.logIt(Level.FINEST, msg, new Object[]{param1, param2, param3});
        }
    }

    public final void trace(Throwable thrown, String msg, Object param1, Object param2, Object param3) {
        if (this.isLoggable(Level.FINEST)) {
            this.logIt(Level.FINEST, msg, new Object[]{param1, param2, param3}, thrown);
        }
    }

    private static class BootstrapLogManager
    extends AdobeLogManager {
        private BootstrapLogManager() {
        }

        protected AdobeLogger createAdobeLogger(String name, String resourceBundleName) {
            LogManager mgr = LogManager.getLogManager();
            if (mgr instanceof AdobeLogManager && !(mgr instanceof BootstrapLogManager)) {
                adobeLogManager = (AdobeLogManager)mgr;
            } else {
                String logManagerName = System.getProperty("com.adobe.logging.AdobeLogManager", "com.adobe.logging.AdobeLogManagerImpl");
                try {
                    ClassLoader loader = AdobeLogManager.class.getClassLoader();
                    Class<?> cls = loader.loadClass(logManagerName);
                    adobeLogManager = (AdobeLogManager)cls.newInstance();
                    return adobeLogManager.createAdobeLogger(name, resourceBundleName);
                }
                catch (Throwable e) {
                    adobeLogManager = new AdobeLogManager(){

                        public AdobeLogger createAdobeLogger(String name, String resourceBundleName) {
                            return new AdobeLogger(name, resourceBundleName);
                        }
                    };
                }
            }
            return adobeLogManager.createAdobeLogger(name, resourceBundleName);
        }
    }
}

