/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.jobmanager.client;

import com.adobe.idp.dsc.DSCInvocationException;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.dsc.registry.component.ComponentRegistry;
import com.adobe.idp.dsc.registry.component.client.ComponentRegistryClient;
import com.adobe.idp.jobmanager.common.JobManagerException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JobManagerServiceClient {
    public static final Logger log = Logger.getLogger(JobManagerServiceClient.class.getName());
    protected static ServiceClientFactory serviceClientFactory = null;
    protected static ComponentRegistry componentRegistry = null;
    protected static boolean initialized = false;

    public JobManagerServiceClient(ServiceClientFactory serviceClientFactory) {
        log.log(Level.FINE, "JobManagerServiceClient:init()");
        JobManagerServiceClient.serviceClientFactory = serviceClientFactory;
        componentRegistry = new ComponentRegistryClient(JobManagerServiceClient.serviceClientFactory);
        initialized = true;
    }

    protected InvocationResponse callJobManager(String operationName, HashMap params) throws JobManagerException {
        log.log(Level.FINE, "JobManagerServiceClient:callJobManager:" + operationName);
        try {
            InvocationRequest request = serviceClientFactory.createInvocationRequest("JobManager", operationName, params, true);
            return serviceClientFactory.getServiceClient().invoke(request);
        }
        catch (Throwable e) {
            if (e instanceof DSCInvocationException) {
                e = e.getCause();
            }
            if (e instanceof JobManagerException) {
                throw (JobManagerException)e;
            }
            if (e.getCause() != null) {
                e = e.getCause();
            }
            log.log(Level.SEVERE, "JobManagerServiceClient:callJobManager:Exception:" + e);
            throw new JobManagerException(e);
        }
    }
}

