/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.jobmanager.client;

import com.adobe.idp.dsc.FaultResponse;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.dsc.filter.PagingFilter;
import com.adobe.idp.jobmanager.client.JobManagerServiceClient;
import com.adobe.idp.jobmanager.common.JobId;
import com.adobe.idp.jobmanager.common.JobManagerException;
import com.adobe.idp.jobmanager.common.JobStatus;
import java.util.HashMap;
import java.util.List;

public class JobManager
extends JobManagerServiceClient
implements com.adobe.idp.jobmanager.service.JobManager {
    public JobManager(ServiceClientFactory serviceClientFactory) {
        super(serviceClientFactory);
    }

    public JobId createJob(InvocationRequest request, boolean persistent) throws JobManagerException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("invocationRequest", request);
        params.put("persistent", new Boolean(persistent));
        InvocationResponse response = this.callJobManager("createJob", params);
        return (JobId)response.getOutputParameters().get("jobId");
    }

    public JobStatus getStatus(JobId jobId) throws JobManagerException {
        HashMap<String, JobId> params = new HashMap<String, JobId>();
        params.put("jobId", jobId);
        InvocationResponse response = this.callJobManager("getStatus", params);
        return (JobStatus)response.getOutputParameters().get("jobStatus");
    }

    public InvocationResponse getResponse(JobId jobId) throws JobManagerException {
        HashMap<String, JobId> params = new HashMap<String, JobId>();
        params.put("jobId", jobId);
        InvocationResponse response = this.callJobManager("getResponse", params);
        return (InvocationResponse)response.getOutputParameters().get("invocationResponse");
    }

    public FaultResponse getFaultResponse(JobId jobId) throws JobManagerException {
        HashMap<String, JobId> params = new HashMap<String, JobId>();
        params.put("jobId", jobId);
        InvocationResponse response = this.callJobManager("getFaultResponse", params);
        return (FaultResponse)response.getOutputParameters().get("faultResponse");
    }

    public void faultJob(JobId jobId, FaultResponse faultResponse) throws JobManagerException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("jobId", jobId);
        params.put("faultResponse", faultResponse);
        this.callJobManager("faultJob", params);
    }

    public void completeJob(JobId jobId, InvocationResponse response) throws JobManagerException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("jobId", jobId);
        params.put("invocationResponse", response);
        this.callJobManager("completeJob", params);
    }

    public void terminateJob(JobId jobId) throws JobManagerException {
        HashMap<String, JobId> params = new HashMap<String, JobId>();
        params.put("jobId", jobId);
        this.callJobManager("terminateJob", params);
    }

    public void suspendJob(JobId jobId) throws JobManagerException {
        HashMap<String, JobId> params = new HashMap<String, JobId>();
        params.put("jobId", jobId);
        this.callJobManager("suspendJob", params);
    }

    public void resumeJob(JobId jobId) throws JobManagerException {
        HashMap<String, JobId> params = new HashMap<String, JobId>();
        params.put("jobId", jobId);
        this.callJobManager("resumeJob", params);
    }

    public void disposeJob(JobId jobId) throws JobManagerException {
        HashMap<String, JobId> params = new HashMap<String, JobId>();
        params.put("jobId", jobId);
        this.callJobManager("disposeJob", params);
    }

    public List getJobInstances(PagingFilter aPagingFilter) throws JobManagerException {
        HashMap<String, PagingFilter> params = new HashMap<String, PagingFilter>();
        params.put("filter", aPagingFilter);
        InvocationResponse response = this.callJobManager("getJobInstances", params);
        return (List)response.getOutputParameters().get("jobInstances");
    }
}

