/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.util;

import com.adobe.idp.dsc.util.TextUtil;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class XMLUtil {
    protected static final char[] XML_CHAR_SET = new char[]{'<', '>', '&'};
    protected static final String[] LEGAL_CHARS = new String[]{"<", ">", "&"};
    protected static final List ESCAPED_LEGAL_CHARS = Arrays.asList("&lt;", "&gt;", "&amp;");
    public static final TimeZone STANDARD_TIMEZONE = TimeZone.getTimeZone("GMT");

    public static boolean containsIllegalCharacter(String aText) {
        boolean isFound = false;
        if (aText == null || aText.length() == 0) {
            return false;
        }
        char[] data = aText.toCharArray();
        block5: for (int i = 0; i < data.length; ++i) {
            switch (data[i]) {
                case '<': {
                    return true;
                }
                case '>': {
                    return true;
                }
                case '&': {
                    int j = i;
                    while (j < data.length) {
                        if (data[j++] == ';') {
                            String dataToCheck = new String(data, i, j - i);
                            if (ESCAPED_LEGAL_CHARS.contains(dataToCheck)) continue block5;
                            return true;
                        }
                        if (j != data.length) continue;
                        return true;
                    }
                    continue block5;
                }
            }
        }
        return isFound;
    }

    public static String escape(String aText) {
        if (aText == null || aText.length() == 0) {
            return aText;
        }
        aText = TextUtil.replace(aText, "&", "&amp;");
        aText = TextUtil.replace(aText, "\"", "&quot;");
        aText = TextUtil.replace(aText, "'", "&apos;");
        aText = TextUtil.replace(aText, "<", "&lt;");
        aText = TextUtil.replace(aText, ">", "&gt;");
        return aText;
    }

    protected static SimpleDateFormat getStandardDateTimeFormat() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        format.setTimeZone(STANDARD_TIMEZONE);
        return format;
    }

    protected static SimpleDateFormat getStandardDateTimeWithTimZoneFormat() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        format.setTimeZone(STANDARD_TIMEZONE);
        return format;
    }

    protected static SimpleDateFormat getStandardLC7DateTimeFormat() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        format.setTimeZone(STANDARD_TIMEZONE);
        return format;
    }

    protected static SimpleDateFormat getStandardDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        format.setTimeZone(STANDARD_TIMEZONE);
        return format;
    }

    protected static DecimalFormat getStandardNumberFormat() {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
        format.applyPattern("#0.###");
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatISO8601Number(Number aNumber) {
        DecimalFormat numberFormat;
        if (aNumber == null) {
            return null;
        }
        DecimalFormat decimalFormat = numberFormat = XMLUtil.getStandardNumberFormat();
        synchronized (decimalFormat) {
            return numberFormat.format(aNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatISO8601DateTime(Date aDate) {
        SimpleDateFormat dateFormat;
        if (aDate == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = dateFormat = XMLUtil.getStandardDateTimeFormat();
        synchronized (simpleDateFormat) {
            return dateFormat.format(aDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatISO8601Date(Date aDate) {
        SimpleDateFormat dateFormat;
        if (aDate == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = dateFormat = XMLUtil.getStandardDateFormat();
        synchronized (simpleDateFormat) {
            return dateFormat.format(aDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Number parseISO8601Number(String aValue) throws ParseException {
        DecimalFormat numberFormat;
        if (aValue == null) {
            return null;
        }
        DecimalFormat decimalFormat = numberFormat = XMLUtil.getStandardNumberFormat();
        synchronized (decimalFormat) {
            return numberFormat.parse(aValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseISO8601DateTime(String aValue) throws ParseException {
        if (aValue == null) {
            return null;
        }
        SimpleDateFormat dateFormat = XMLUtil.getStandardDateTimeFormat();
        Date _date = null;
        try {
            SimpleDateFormat simpleDateFormat = dateFormat;
            synchronized (simpleDateFormat) {
                _date = dateFormat.parse(aValue);
            }
            return _date;
        }
        catch (ParseException e2) {
            try {
                SimpleDateFormat e2 = dateFormat = XMLUtil.getStandardLC7DateTimeFormat();
                synchronized (e2) {
                    _date = dateFormat.parse(aValue);
                }
                return _date;
            }
            catch (ParseException parseException) {
                SimpleDateFormat simpleDateFormat = dateFormat = XMLUtil.getStandardDateTimeWithTimZoneFormat();
                synchronized (simpleDateFormat) {
                    _date = dateFormat.parse(aValue);
                }
                return _date;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseISO8601Date(String aValue) throws ParseException {
        SimpleDateFormat e2;
        if (aValue == null) {
            return null;
        }
        SimpleDateFormat dateFormat = XMLUtil.getStandardDateFormat();
        Date _date = null;
        try {
            SimpleDateFormat simpleDateFormat = dateFormat;
            synchronized (simpleDateFormat) {
                _date = dateFormat.parse(aValue);
            }
        }
        catch (ParseException e2) {
            // empty catch block
        }
        if (_date == null) {
            dateFormat = XMLUtil.getStandardDateTimeFormat();
            try {
                e2 = dateFormat;
                synchronized (e2) {
                    _date = dateFormat.parse(aValue);
                }
            }
            catch (ParseException e3) {
                // empty catch block
            }
        }
        if (_date == null) {
            e2 = dateFormat = XMLUtil.getStandardLC7DateTimeFormat();
            synchronized (e2) {
                _date = dateFormat.parse(aValue);
            }
        }
        Calendar _cal = Calendar.getInstance(STANDARD_TIMEZONE);
        _cal.setTime(_date);
        _cal.set(11, 12);
        _cal.set(12, 0);
        _cal.set(13, 0);
        _cal.set(14, 0);
        return _cal.getTime();
    }

    public static boolean isNumericType(String aType) {
        String _type = aType;
        if (_type == null) {
            return false;
        }
        return _type.length() > 3 && _type.substring(0, 3).equalsIgnoreCase("xsd") && ((_type = _type.substring(4)).equalsIgnoreCase("integer") || _type.equalsIgnoreCase("int") || _type.equalsIgnoreCase("float") || _type.equalsIgnoreCase("double") || _type.equalsIgnoreCase("decimal") || _type.equalsIgnoreCase("short") || _type.equalsIgnoreCase("long"));
    }

    public static boolean getBooleanFromString(String aValue) {
        if (aValue == null) {
            return false;
        }
        if (aValue.equalsIgnoreCase("true")) {
            return true;
        }
        try {
            int _val = Integer.parseInt(aValue);
            return _val != 0;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

