/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.util;

import java.security.SecureRandom;
import java.util.Random;
import org.apache.commons.codec.binary.Hex;

public final class UUIDGenerator {
    static int UUID_BYTE_LENGTH = 16;
    static int UUID_UNFORMATTED_LENGTH = 32;
    static int UUID_FORMATTED_LENGTH = 36;
    static int FORMAT_POSITION1 = 8;
    static int FORMAT_POSITION2 = 13;
    static int FORMAT_POSITION3 = 18;
    static int FORMAT_POSITION4 = 23;
    static String URN_PREFIX = "urn:uuid:";
    static int VERSION_FOUR = 4;
    static short TIME_HI_AND_VERSION_BYTE_6 = (short)6;
    static short CLOCK_SEQ_HI_AND_RESERVED_BYTE_8 = (short)8;
    private static Random secureRandom;

    public UUIDGenerator() {
    }

    public UUIDGenerator(SecureRandom secureRandom) {
        UUIDGenerator.secureRandom = secureRandom;
    }

    public String nextUUID() {
        return this.nextUUID(false);
    }

    public String nextUUID(boolean addURNPrefix) {
        byte[] raw = new byte[UUID_BYTE_LENGTH];
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
        secureRandom.nextBytes(raw);
        short s = TIME_HI_AND_VERSION_BYTE_6;
        raw[s] = (byte)(raw[s] & 0xF);
        short s2 = TIME_HI_AND_VERSION_BYTE_6;
        raw[s2] = (byte)(raw[s2] | VERSION_FOUR << 4);
        short s3 = CLOCK_SEQ_HI_AND_RESERVED_BYTE_8;
        raw[s3] = (byte)(raw[s3] & 0x3F);
        short s4 = CLOCK_SEQ_HI_AND_RESERVED_BYTE_8;
        raw[s4] = (byte)(raw[s4] | 0x80);
        return this.getString(raw, addURNPrefix).toUpperCase();
    }

    private String getString(byte[] rawBytes, boolean addUrnPrefix) {
        StringBuffer buf = new StringBuffer(new String(Hex.encodeHex((byte[])rawBytes)));
        while (buf.length() != UUID_UNFORMATTED_LENGTH) {
            buf.insert(0, "0");
        }
        buf.ensureCapacity(UUID_FORMATTED_LENGTH);
        buf.insert(FORMAT_POSITION1, '-');
        buf.insert(FORMAT_POSITION2, '-');
        buf.insert(FORMAT_POSITION3, '-');
        buf.insert(FORMAT_POSITION4, '-');
        if (addUrnPrefix) {
            return URN_PREFIX + buf.toString();
        }
        return buf.toString();
    }
}

