/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.util;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.util.Vector;

public class TextUtil {
    public static final char[] WORD_SEPARATORS = new char[]{' ', '\t', '\n', '\r', '\f', '.', ',', ':', '-', '(', ')', '[', ']', '{', '}', '<', '>', '/', '|', '\\', '\'', '\"'};

    public static String isNull(String aValue, String aReplacement) {
        if (aValue == null || aValue.trim().length() == 0) {
            return aReplacement;
        }
        return aValue;
    }

    public static boolean isEmpty(String aValue) {
        return aValue == null || aValue.trim().length() == 0;
    }

    public static String replaceEmptyValue(String aValue, String aIsEmptyValue) {
        if (TextUtil.isEmpty(aValue)) {
            return aIsEmptyValue;
        }
        return aValue;
    }

    public static String replace(String aOriginalText, String aText, String aReplacement) {
        StringBuffer _newText = new StringBuffer();
        int _startIndex = 0;
        int _endIndex = 0;
        while ((_endIndex = aOriginalText.indexOf(aText, _startIndex)) > -1) {
            _newText.append(aOriginalText.substring(_startIndex, _endIndex));
            _newText.append(aReplacement);
            _startIndex = _endIndex + aText.length();
        }
        _newText.append(aOriginalText.substring(_startIndex));
        return _newText.toString();
    }

    public static String trimToLength(String aText, int aLength) {
        if (aText == null) {
            return null;
        }
        if (aText.length() <= aLength) {
            return aText;
        }
        return aText.substring(0, aLength);
    }

    public static String[] split(String aString, char aDelimiter) {
        int y;
        if (TextUtil.isEmpty(aString)) {
            return new String[0];
        }
        int _start = 0;
        int _end = -1;
        String _string = new String();
        Vector<String> _strings = new Vector<String>();
        while ((y = aString.indexOf(aDelimiter, _start)) != -1) {
            _end = y;
            _string = aString.substring(_start, _end);
            _strings.addElement(_string);
            _start = _end + 1;
        }
        if (_end + 1 != aString.length()) {
            _string = aString.substring(_start);
            _strings.addElement(_string);
        }
        Object[] _stringArray = new String[_strings.size()];
        _strings.copyInto(_stringArray);
        return _stringArray;
    }

    public static String replaceNull(String aValue, String aIsNullValue) {
        if (aValue == null) {
            return aIsNullValue;
        }
        return aValue;
    }

    public static String replaceNull(String aValue, String aIsNullValue, String aIsNotNullValue) {
        if (aValue == null) {
            return aIsNullValue;
        }
        return aIsNotNullValue;
    }

    public static String replaceEmptyStringOrNull(String aValue, String aIsNullValue) {
        if (aValue == null || aValue.length() == 0) {
            return aIsNullValue;
        }
        return aValue;
    }

    public static String replaceEmptyStringOrNull(String aValue, String aIsNullValue, String aIsNotNullValue) {
        if (aValue == null || aValue.length() == 0) {
            return aIsNullValue;
        }
        return aIsNotNullValue;
    }

    public static String repeat(String aString, int aCount) {
        StringBuffer _text = new StringBuffer(aString.length() * aCount);
        for (int i = 0; i < aCount; ++i) {
            _text.append(aString);
        }
        return _text.toString();
    }

    public static String paddingString(String s, int n, char c, boolean paddingLeft) {
        StringBuffer str = new StringBuffer(s);
        int strLength = str.length();
        if (n > 0 && n > strLength) {
            for (int i = 0; i <= n; ++i) {
                if (paddingLeft) {
                    if (i >= n - strLength) continue;
                    str.insert(0, c);
                    continue;
                }
                if (i <= strLength) continue;
                str.append(c);
            }
        }
        return str.toString();
    }

    public static boolean isSeparator(char ch) {
        for (int k = 0; k < WORD_SEPARATORS.length; ++k) {
            if (ch != WORD_SEPARATORS[k]) continue;
            return true;
        }
        return false;
    }

    public static String soundex(String word) {
        char[] result = new char[4];
        result[0] = word.charAt(0);
        result[3] = 48;
        result[2] = 48;
        result[1] = 48;
        int index = 1;
        int codeLast = 42;
        for (int k = 1; k < word.length(); ++k) {
            char ch = word.charAt(k);
            int code = 32;
            switch (ch) {
                case 'b': 
                case 'f': 
                case 'p': 
                case 'v': {
                    code = 49;
                    break;
                }
                case 'c': 
                case 'g': 
                case 'j': 
                case 'k': 
                case 'q': 
                case 's': 
                case 'x': 
                case 'z': {
                    code = 50;
                    break;
                }
                case 'd': 
                case 't': {
                    code = 51;
                    break;
                }
                case 'l': {
                    code = 52;
                    break;
                }
                case 'm': 
                case 'n': {
                    code = 53;
                    break;
                }
                case 'r': {
                    code = 54;
                    break;
                }
                default: {
                    code = 42;
                }
            }
            if (code == codeLast) {
                code = 42;
            }
            codeLast = code;
            if (code == 42) continue;
            result[index] = code;
            if (++index > 3) break;
        }
        return new String(result);
    }

    public static boolean hasDigits(String word) {
        for (int k = 1; k < word.length(); ++k) {
            char ch = word.charAt(k);
            if (!Character.isDigit(ch)) continue;
            return true;
        }
        return false;
    }

    public static String titleCase(String source) {
        return Character.toUpperCase(source.charAt(0)) + source.substring(1);
    }

    public static void main(String[] args) {
        String _text = "test_class";
        String[] _lines = TextUtil.split(_text, '_');
        System.out.println(_lines.length);
        for (int i = 0; i < _lines.length; ++i) {
            System.out.println("String " + (i + 1) + ": " + _lines[i]);
        }
    }

    public static String toHexString(Color aColor) {
        return '#' + Integer.toHexString(aColor.getRGB()).substring(2);
    }

    public static String htmlEncode(String aString) {
        int _len = aString.length();
        StringBuffer _text = new StringBuffer();
        boolean _encoded = false;
        for (int i = 0; i < _len; ++i) {
            char _c = aString.charAt(i);
            if (_c == '\"' || _c == '&' || _c == '<' || _c == '>') {
                if (!_encoded) {
                    _text.append(aString.substring(0, i));
                    _encoded = true;
                }
                switch (_c) {
                    case '\"': {
                        _text.append("&quot;");
                        break;
                    }
                    case '&': {
                        _text.append("&amp;");
                        break;
                    }
                    case '<': {
                        _text.append("&gt;");
                        break;
                    }
                    case '>': {
                        _text.append("&lt;");
                    }
                }
                continue;
            }
            if (!_encoded) continue;
            _text.append(_c);
        }
        if (!_encoded) {
            _text.append(aString);
        }
        return _text.toString();
    }

    public static boolean equals(String aValue1, String aValue2) {
        return TextUtil.equals(aValue1, aValue2, true);
    }

    public static boolean equals(String aValue1, String aValue2, boolean useEmptyValue) {
        if (useEmptyValue) {
            if (TextUtil.isEmpty(aValue1) && TextUtil.isEmpty(aValue2)) {
                return true;
            }
            if (TextUtil.isEmpty(aValue1) || TextUtil.isEmpty(aValue2)) {
                return false;
            }
        } else {
            if (aValue1 == null && aValue2 == null) {
                return true;
            }
            if (aValue1 == null || aValue2 == null) {
                return false;
            }
        }
        return aValue1.trim().equals(aValue2.trim());
    }

    public static boolean equalsIgnoreCase(String aValue1, String aValue2) {
        return TextUtil.equalsIgnoreCase(aValue1, aValue2, true);
    }

    public static boolean equalsIgnoreCase(String aValue1, String aValue2, boolean useEmptyValue) {
        if (useEmptyValue) {
            if (TextUtil.isEmpty(aValue1) && TextUtil.isEmpty(aValue2)) {
                return true;
            }
            if (TextUtil.isEmpty(aValue1) || TextUtil.isEmpty(aValue2)) {
                return false;
            }
        } else {
            if (aValue1 == null && aValue2 == null) {
                return true;
            }
            if (aValue1 == null || aValue2 == null) {
                return false;
            }
        }
        return aValue1.trim().equalsIgnoreCase(aValue2.trim());
    }

    public static boolean contains(String[] aStringArray, String aValue) {
        for (int i = 0; i < aStringArray.length; i = (int)((short)(i + 1))) {
            if (!TextUtil.equalsIgnoreCase(aStringArray[i], aValue)) continue;
            return true;
        }
        return false;
    }

    public static String toUpperCase(String aVal) {
        if (aVal == null) {
            return null;
        }
        return aVal.toUpperCase();
    }

    public static String toLowerCase(String aVal) {
        if (aVal == null) {
            return null;
        }
        return aVal.toLowerCase();
    }

    public static String trim(String aVal) {
        if (aVal == null) {
            return null;
        }
        return aVal.trim();
    }

    public static char[] base64Encode(byte[] aBytes) {
        Base64Encoder _encoder = new Base64Encoder();
        _encoder.translate(aBytes);
        return _encoder.getCharArray();
    }

    public static byte[] base64Decode(String aString) {
        Base64Decoder _decoder = new Base64Decoder();
        _decoder.translate(aString);
        return _decoder.getByteArray();
    }

    private static final class Base64Encoder {
        private static final int OCTET_3 = 3;
        private static final int OCTET_1_MASK = 65535;
        private static final int OCTET_2_MASK = 0xFF00FF;
        private static final int OCTET_3_MASK = 0xFFFF00;
        private static final int OCTET_MASK = 255;
        private static final int SHIFT_1_OCTET = 8;
        private static final int SHIFT_2_OCTET = 16;
        private static final int SEXTET_MASK = 63;
        private static final int SHIFT_1_SEXTET = 6;
        private static final int SHIFT_2_SEXTET = 12;
        private static final int SHIFT_3_SEXTET = 18;
        private static final char[] MAP = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        private int _buffer = 0;
        private int _octets = 0;
        private StringBuffer _stream = new StringBuffer();

        private Base64Encoder() {
        }

        public void reset() {
            this._buffer = 0;
            this._octets = 0;
            this._stream = new StringBuffer();
        }

        public void translate(byte[] bytes) {
            for (int i = 0; i < bytes.length; ++i) {
                byte b = bytes[i];
                this._buffer = this._octets == 0 ? this._buffer & 0xFFFF | (b & 0xFF) << 16 : (this._octets == 1 ? this._buffer & 0xFF00FF | (b & 0xFF) << 8 : this._buffer & 0xFFFF00 | b & 0xFF);
                if (++this._octets != 3) continue;
                this.encode();
            }
        }

        private void encode() {
            this._stream.append(MAP[0x3F & this._buffer >> 18]);
            this._stream.append(MAP[0x3F & this._buffer >> 12]);
            this._stream.append(MAP[0x3F & this._buffer >> 6]);
            this._stream.append(MAP[0x3F & this._buffer]);
            this._buffer = 0;
            this._octets = 0;
        }

        private void encodeWithPadding() {
            this._stream.append(MAP[0x3F & this._buffer >> 18]);
            this._stream.append(MAP[0x3F & this._buffer >> 12]);
            if (this._octets <= 1) {
                this._stream.append('=');
            } else {
                this._stream.append(MAP[0x3F & this._buffer >> 6]);
            }
            if (this._octets <= 2) {
                this._stream.append('=');
            } else {
                this._stream.append(MAP[0x3F & this._buffer]);
            }
            this._buffer = 0;
            this._octets = 0;
        }

        public char[] getCharArray() {
            if (this._octets > 0) {
                this.encodeWithPadding();
            }
            char[] chars = new char[this._stream.length()];
            if (this._stream.length() > 0) {
                this._stream.getChars(0, this._stream.length(), chars, 0);
            }
            return chars;
        }
    }

    private static final class Base64Decoder {
        private static final int SEXTET_1_MASK = 262143;
        private static final int SEXTET_2_MASK = 0xFC0FFF;
        private static final int SEXTET_3_MASK = 0xFFF03F;
        private static final int SEXTET_4_MASK = 0xFFFFC0;
        private static final int SHIFT_1_SEXTET = 6;
        private static final int SHIFT_2_SEXTET = 12;
        private static final int SHIFT_3_SEXTET = 18;
        private static final int SEXTET_2 = 2;
        private static final int SEXTET_3 = 3;
        private static final int SEXTET_4 = 4;
        private static final int OCTET_MASK = 255;
        private static final int SHIFT_1_OCTET = 8;
        private static final int SHIFT_2_OCTET = 16;
        private static final byte SPC = 127;
        private static final byte PAD = 64;
        private static final byte[] MAP = new byte[]{127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 62, 127, 127, 127, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 127, 127, 127, 64, 127, 127, 127, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 127, 127, 127, 127, 127, 127, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127};
        private int _buffer = 0;
        private int _sextets = 0;
        private ByteArrayOutputStream _stream = new ByteArrayOutputStream();

        private Base64Decoder() {
        }

        public void translate(String string) {
            int len = string.length();
            int index = 0;
            byte data = MAP[string.charAt(index)];
            while (index < len && data != 64) {
                if (data != 127) {
                    this._buffer = this._sextets == 0 ? this._buffer & 0x3FFFF | data << 18 : (this._sextets == 1 ? this._buffer & 0xFC0FFF | data << 12 : (this._sextets == 2 ? this._buffer & 0xFFF03F | data << 6 : this._buffer & 0xFFFFC0 | data));
                    if (++this._sextets == 4) {
                        this.decode();
                    }
                }
                if (++index >= len) continue;
                data = MAP[string.charAt(index)];
            }
            if (this._sextets > 0) {
                this.decodeWithPadding();
            }
        }

        private void decode() {
            this._stream.write((byte)(this._buffer >> 16 & 0xFF));
            this._stream.write((byte)(this._buffer >> 8 & 0xFF));
            this._stream.write((byte)(this._buffer & 0xFF));
            this._buffer = 0;
            this._sextets = 0;
        }

        private void decodeWithPadding() {
            if (this._sextets >= 2) {
                this._stream.write((byte)(this._buffer >> 16 & 0xFF));
            }
            if (this._sextets >= 3) {
                this._stream.write((byte)(this._buffer >> 8 & 0xFF));
            }
            if (this._sextets >= 4) {
                this._stream.write((byte)(this._buffer & 0xFF));
            }
            this._buffer = 0;
            this._sextets = 0;
        }

        public byte[] getByteArray() {
            return this._stream.toByteArray();
        }
    }
}

