/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.util;

import com.adobe.idp.dsc.util.ClassLoaderAwareObjectInputStream;
import com.adobe.logging.AdobeLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.util.logging.Level;

public class SwitchSUIDObjectInputStream
extends ClassLoaderAwareObjectInputStream {
    protected static final AdobeLogger logger = AdobeLogger.getAdobeLogger(SwitchSUIDObjectInputStream.class);
    protected static Field SUID_FIELD = null;

    public SwitchSUIDObjectInputStream(InputStream aIn, ClassLoader aClassLoader) throws IOException {
        super(aIn, aClassLoader);
        try {
            SUID_FIELD = ObjectStreamClass.class.getDeclaredField("suid");
            SUID_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException ex) {
            logger.log(Level.SEVERE, ex.getMessage());
        }
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        Class localClass;
        ObjectStreamClass resultClassDescriptor = super.readClassDescriptor();
        try {
            localClass = this.getContainerClass(resultClassDescriptor);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "No local class for " + resultClassDescriptor.getName(), e);
            return resultClassDescriptor;
        }
        if (localClass == null) {
            logger.log(Level.INFO, "No local class for " + resultClassDescriptor.getName());
            return resultClassDescriptor;
        }
        ObjectStreamClass localClassDescriptor = ObjectStreamClass.lookup(localClass);
        if (localClassDescriptor != null) {
            long localSUID = localClassDescriptor.getSerialVersionUID();
            long streamSUID = resultClassDescriptor.getSerialVersionUID();
            if (streamSUID != localSUID) {
                StringBuffer s = new StringBuffer("Potentially Fatal Deserialization Operation for Class: ");
                s.append(localClassDescriptor.getName());
                s.append(" Overriding serialized class version mismatch: ");
                s.append("local serialVersionUID = ").append(localSUID);
                s.append(" stream serialVersionUID = ").append(streamSUID);
                logger.log(Level.INFO, s.toString());
                boolean switchedSUID = false;
                try {
                    if (SUID_FIELD != null) {
                        SUID_FIELD.set(resultClassDescriptor, localSUID);
                        switchedSUID = true;
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.FINE, s.toString());
                }
                if (!switchedSUID) {
                    resultClassDescriptor = localClassDescriptor;
                }
            }
        }
        return resultClassDescriptor;
    }
}

