/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.util;

import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public class QNameConverter
implements Converter {
    boolean explicit = false;

    public QNameConverter() {
    }

    public QNameConverter(boolean explicit) {
        this.explicit = explicit;
    }

    public Object convert(Class type, Object value) {
        if (value == null) {
            throw new ConversionException("No value specified");
        }
        if (value instanceof QName) {
            return value;
        }
        String val = value.toString();
        if (val.startsWith("qname{")) {
            return this.parseQName(val.substring(6, val.length() - 1));
        }
        if (!this.explicit) {
            return this.parseQName(val);
        }
        return new QName(val);
    }

    protected QName parseQName(String val) {
        StringTokenizer st = new StringTokenizer(val, ":");
        String[] elements = new String[4];
        int i = 0;
        while (st.hasMoreTokens()) {
            elements[i] = st.nextToken();
            ++i;
        }
        QName qname = null;
        if (i == 1) {
            qname = new QName(elements[0]);
        } else if (i == 2) {
            qname = new QName(elements[0], elements[1]);
        } else if (i == 3) {
            qname = new QName(elements[1] + ":" + elements[2], elements[0]);
        } else if (i == 4) {
            qname = new QName(elements[2] + ":" + elements[3], elements[1], elements[0]);
        }
        return qname;
    }
}

