/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.util;

import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;

public class ProxyClient
implements InvocationHandler {
    private ServiceClientFactory m_serviceClientFactory;
    private String m_serviceName;

    public static Object createProxyClient(ClassLoader aClassLoader, Class[] aInterfaces, String aServiceName, ServiceClientFactory aServiceClientFactory) {
        return Proxy.newProxyInstance(aClassLoader, aInterfaces, (InvocationHandler)new ProxyClient(aServiceName, aServiceClientFactory));
    }

    public ProxyClient(String aServiceName, ServiceClientFactory aServiceClientFactory) {
        this.m_serviceName = aServiceName;
        this.m_serviceClientFactory = aServiceClientFactory;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        HashMap<String, Object> input = new HashMap<String, Object>();
        for (int i = 0; i < args.length; ++i) {
            input.put("param" + i, args[i]);
        }
        try {
            InvocationRequest request = this.m_serviceClientFactory.createInvocationRequest(this.m_serviceName, method.getName(), input, true);
            InvocationResponse response = this.m_serviceClientFactory.getServiceClient().invoke(request);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            if (returnValue != null && returnValue.length > 0) {
                return returnValue[0];
            }
            return null;
        }
        catch (Exception ex) {
            Class<?>[] exceptions = method.getExceptionTypes();
            Class<?> exceptionClass = ex.getClass();
            for (int i = 0; i < exceptions.length; ++i) {
                Throwable cause = ex.getCause();
                Class<?> exception = exceptions[i];
                if (exception.isAssignableFrom(exceptionClass)) {
                    throw ex;
                }
                if (!cause.getClass().isAssignableFrom(exceptionClass)) continue;
                throw cause;
            }
            throw new DSCRuntimeException(ex);
        }
    }
}

