/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.util;

import com.adobe.idp.Document;
import com.adobe.idp.dsc.util.ClassLoaderAwareObjectInputStream;
import com.adobe.idp.dsc.util.TextUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class IOUtil {
    public static InputStream getResourceAsStream(String aPath) {
        InputStream _in = IOUtil.class.getClassLoader().getResourceAsStream(aPath);
        if (_in == null) {
            throw new RuntimeException("Resource: " + aPath + " does not exist");
        }
        return _in;
    }

    public static byte[] readByteArrayFromStream(InputStream aInputStream) throws IOException {
        return IOUtil.readByteArrayFromStream(aInputStream, 5000);
    }

    public static byte[] readByteArrayFromStream(InputStream aInputStream, int aBufferSize) throws IOException {
        byte[] _buf = new byte[aBufferSize];
        ByteArrayOutputStream _baos = new ByteArrayOutputStream();
        int x = 0;
        while ((x = aInputStream.read(_buf)) > 0) {
            _baos.write(_buf, 0, x);
            _buf = new byte[aBufferSize];
        }
        return _baos.toByteArray();
    }

    public static byte[] readByteArrayFromResource(ClassLoader aLoader, String aResourceName) throws IOException {
        if (TextUtil.isEmpty(aResourceName)) {
            return null;
        }
        InputStream _in = aLoader.getResourceAsStream(aResourceName);
        if (_in == null) {
            throw new RuntimeException(aResourceName + " does not exist");
        }
        byte[] _buff = IOUtil.readByteArrayFromStream(_in);
        _in.close();
        return _buff;
    }

    public static byte[] readByteArrayFromResource(String aResourceName) throws IOException {
        if (TextUtil.isEmpty(aResourceName)) {
            return null;
        }
        InputStream _in = IOUtil.class.getClassLoader().getResourceAsStream(aResourceName);
        if (_in == null) {
            throw new RuntimeException(aResourceName + " does not exist");
        }
        byte[] _buff = IOUtil.readByteArrayFromStream(_in);
        _in.close();
        return _buff;
    }

    public static void writeInput2OutputStream(InputStream aInputStream, OutputStream aOutputStream, boolean aAutoFlush) throws IOException {
        IOUtil.writeInput2OutputStream(aInputStream, aOutputStream, 10000, aAutoFlush ? 1 : -1);
    }

    public static void writeInput2OutputStream(InputStream aInputStream, OutputStream aOutputStream, int aBufferSize, int aAutoFlushInterval) throws IOException {
        byte[] _buf = new byte[aBufferSize];
        int x = 0;
        int i = 1;
        while ((x = aInputStream.read(_buf)) > 0) {
            aOutputStream.write(_buf, 0, x);
            _buf = new byte[aBufferSize];
            if (aAutoFlushInterval > 0 && i % aAutoFlushInterval > 0) {
                aOutputStream.flush();
            }
            ++i;
        }
        if (aAutoFlushInterval > 0 && (i - 1) % aAutoFlushInterval == 0) {
            aOutputStream.flush();
        }
    }

    public static void deleteFile(File aFile) {
        if (!aFile.isDirectory()) {
            aFile.delete();
            return;
        }
        File[] _files = aFile.listFiles();
        for (int i = 0; i < _files.length; ++i) {
            IOUtil.deleteFile(_files[i]);
        }
        aFile.delete();
    }

    public static void copyFile(File aSource, File aDestination) throws IOException {
        if (!aSource.exists()) {
            throw new IOException("File: " + aSource.getAbsolutePath() + " does not exist.");
        }
        if (aSource.isFile() && aDestination.isFile() && aDestination.exists() && !aDestination.delete()) {
            throw new IOException("File: " + aDestination.getAbsolutePath() + " already exists and cannot be deleted.");
        }
        if (aDestination.isDirectory() && !aDestination.exists() && !aDestination.mkdir()) {
            throw new IOException("Cannot create directory: " + aDestination.getAbsolutePath());
        }
        if (aSource.isDirectory()) {
            if (!aDestination.isDirectory()) {
                throw new IOException("Connot copy directory: " + aSource.getAbsolutePath() + " to file: " + aDestination.getAbsolutePath());
            }
            File[] _files = aSource.listFiles();
            for (int i = 0; i < _files.length; ++i) {
                File _dest = new File(aDestination, _files[i].getName());
                if (_files[i].isDirectory() && !_dest.mkdir()) {
                    throw new IOException("Cannot create directory: " + _dest.getAbsolutePath());
                }
                IOUtil.copyFile(_files[i], _dest);
            }
            return;
        }
        File _dest = null;
        _dest = aDestination.isDirectory() ? new File(aDestination, aSource.getName()) : aDestination;
        FileInputStream _fin = new FileInputStream(aSource);
        FileOutputStream _fout = new FileOutputStream(_dest);
        IOUtil.writeInput2OutputStream(_fin, _fout, true);
        _fout.close();
        _fin.close();
    }

    public static String readStringFromStream(InputStream aInputStream) throws IOException {
        return IOUtil.readStringFromReader(new InputStreamReader(aInputStream));
    }

    public static String readStringFromReader(Reader aReader) throws IOException {
        char[] _buf = new char[5000];
        StringBuffer _text = new StringBuffer();
        int x = 0;
        while ((x = aReader.read(_buf)) > 0) {
            _text.append(_buf, 0, x);
            _buf = new char[5000];
        }
        return _text.toString();
    }

    public static String readStringFromFile(File aFile) throws IOException {
        FileInputStream _fin = new FileInputStream(aFile);
        String _val = IOUtil.readStringFromStream(_fin);
        _fin.close();
        return _val;
    }

    public static String readStringFromResource(ClassLoader aLoader, String aResourceName) throws IOException {
        InputStream _in = aLoader.getResourceAsStream(aResourceName);
        if (_in == null) {
            throw new RuntimeException(aResourceName + " does not exist");
        }
        String _val = IOUtil.readStringFromStream(_in);
        _in.close();
        return _val;
    }

    public static String readStringFromResource(String aResourceName) throws IOException {
        InputStream _in = IOUtil.class.getClassLoader().getResourceAsStream(aResourceName);
        if (_in == null) {
            throw new RuntimeException(aResourceName + " does not exist");
        }
        String _val = IOUtil.readStringFromStream(_in);
        _in.close();
        return _val;
    }

    public static void writeFile2JarOutputStream(File aFile, JarOutputStream aOut) throws IOException {
        if (aFile.isDirectory()) {
            File[] _files = aFile.listFiles();
            for (int i = 0; i < _files.length; ++i) {
                IOUtil.writeFile2JarOutputStream(null, _files[i], aOut);
            }
        } else {
            FileInputStream _fin = new FileInputStream(aFile);
            aOut.putNextEntry(new JarEntry(aFile.getName()));
            IOUtil.writeInput2OutputStream(_fin, aOut, false);
            aOut.flush();
            aOut.closeEntry();
        }
    }

    public static void writeFile2JarOutputStream(String aPath, File aFile, JarOutputStream aOut) throws IOException {
        String _path = aPath;
        _path = _path == null || _path.trim().length() == 0 ? aFile.getName() : aPath + '/' + aFile.getName();
        if (aFile.isDirectory()) {
            aOut.putNextEntry(new JarEntry(_path + '/'));
            aOut.closeEntry();
            File[] _files = aFile.listFiles();
            for (int i = 0; i < _files.length; ++i) {
                IOUtil.writeFile2JarOutputStream(_path, _files[i], aOut);
            }
        } else {
            FileInputStream _fin = new FileInputStream(aFile);
            aOut.putNextEntry(new JarEntry(_path));
            IOUtil.writeInput2OutputStream(_fin, aOut, false);
            aOut.flush();
            aOut.closeEntry();
        }
    }

    public static Map readEntriesFromJarInputStreamAsMap(JarInputStream aStream) throws IOException {
        HashMap<String, byte[]> _map = new HashMap<String, byte[]>();
        JarEntry _entry = null;
        while ((_entry = aStream.getNextJarEntry()) != null) {
            _map.put(_entry.getName(), IOUtil.readByteArrayFromStream(aStream));
        }
        return _map;
    }

    public static Map readEntriesFromJarInputStreamAsMap(JarInputStream aStream, char aSpeperator) throws IOException {
        HashMap<String, byte[]> _map = new HashMap<String, byte[]>();
        JarEntry _entry = null;
        while ((_entry = aStream.getNextJarEntry()) != null) {
            _map.put(_entry.getName().replace('/', aSpeperator), IOUtil.readByteArrayFromStream(aStream));
        }
        return _map;
    }

    public static ClassLoader createClassLoader(File[] aClassDirs, File[] aJarDirs) {
        int i;
        ArrayList<URL> _urls = new ArrayList<URL>();
        if (aClassDirs != null) {
            for (i = 0; i < aClassDirs.length; ++i) {
                if (aClassDirs[i].isFile()) continue;
                try {
                    _urls.add(aClassDirs[i].toURL());
                    continue;
                }
                catch (MalformedURLException mex) {
                    // empty catch block
                }
            }
        }
        if (aJarDirs != null) {
            for (i = 0; i < aJarDirs.length; ++i) {
                if (aJarDirs[i].isFile()) {
                    try {
                        _urls.add(aJarDirs[i].toURL());
                    }
                    catch (MalformedURLException mex) {}
                    continue;
                }
                File[] _jars = aJarDirs[i].listFiles(new FileFilter(){

                    public boolean accept(File aFile) {
                        return aFile.getName().endsWith(".jar");
                    }
                });
                for (int x = 0; x < _jars.length; ++x) {
                    try {
                        _urls.add(_jars[x].toURL());
                        continue;
                    }
                    catch (MalformedURLException mex) {
                        // empty catch block
                    }
                }
            }
        }
        URL[] _urlsarr = new URL[_urls.size()];
        _urls.toArray(_urlsarr);
        return new URLClassLoader(_urlsarr);
    }

    public static byte[] writeObject2ByteArray(Object aValue) {
        try {
            ByteArrayOutputStream _buff = new ByteArrayOutputStream();
            ObjectOutputStream _oout = new ObjectOutputStream(_buff);
            _oout.writeObject(aValue);
            _oout.flush();
            _oout.close();
            return _buff.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object readObjectFromByteArray(byte[] aBuff) {
        try {
            ByteArrayInputStream _buff = new ByteArrayInputStream(aBuff);
            ObjectInputStream _oin = new ObjectInputStream(_buff);
            Object _val = _oin.readObject();
            _oin.close();
            return _val;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object readObjectFromByteArray(byte[] aBuff, ClassLoader aClassLoader) {
        try {
            ByteArrayInputStream _buff = new ByteArrayInputStream(aBuff);
            ClassLoaderAwareObjectInputStream _oin = new ClassLoaderAwareObjectInputStream(_buff, aClassLoader);
            Object _val = _oin.readObject();
            _oin.close();
            return _val;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object cloneObject(Object aObject) {
        return IOUtil.cloneObject(aObject, aObject == null ? null : aObject.getClass().getClassLoader());
    }

    public static Object cloneObject(Object aObject, ClassLoader aClassLoader) {
        try {
            byte[] _buff = IOUtil.writeObject2ByteArray(aObject);
            return IOUtil.readObjectFromByteArray(_buff, aClassLoader);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Document encodeDocument(long magicNumber, Object[] objects) throws IOException {
        IOException firstException;
        Document rv;
        block35: {
            IOException e222222;
            ZipOutputStream zout;
            ByteArrayOutputStream baos;
            ObjectOutputStream oos;
            block29: {
                block28: {
                    oos = null;
                    baos = null;
                    zout = null;
                    rv = null;
                    firstException = null;
                    baos = new ByteArrayOutputStream();
                    zout = new ZipOutputStream(baos);
                    ZipEntry entry = new ZipEntry("data.ser");
                    zout.putNextEntry(entry);
                    oos = new ObjectOutputStream(zout);
                    oos.writeLong(magicNumber);
                    oos.writeInt(objects.length);
                    for (Object object : objects) {
                        oos.writeObject(object);
                    }
                    Object var14_13 = null;
                    if (oos == null) break block28;
                    try {
                        oos.close();
                        byte[] bytes = baos.toByteArray();
                        rv = new Document(bytes);
                        zout = null;
                        baos = null;
                    }
                    catch (IOException e222222) {
                        if (firstException != null) break block28;
                        firstException = e222222;
                    }
                }
                if (zout != null) {
                    try {
                        zout.close();
                        baos = null;
                    }
                    catch (IOException e222222) {
                        if (firstException != null) break block29;
                        firstException = e222222;
                    }
                }
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e222222) {
                    if (firstException == null) {
                        firstException = e222222;
                    }
                }
            }
            break block35;
            {
                catch (IOException e3) {
                    IOException e222222;
                    block31: {
                        block30: {
                            firstException = e3;
                            Object var14_14 = null;
                            if (oos != null) {
                                try {
                                    oos.close();
                                    byte[] bytes = baos.toByteArray();
                                    rv = new Document(bytes);
                                    zout = null;
                                    baos = null;
                                }
                                catch (IOException e222222) {
                                    if (firstException != null) break block30;
                                    firstException = e222222;
                                }
                            }
                        }
                        if (zout != null) {
                            try {
                                zout.close();
                                baos = null;
                            }
                            catch (IOException e222222) {
                                if (firstException != null) break block31;
                                firstException = e222222;
                            }
                        }
                    }
                    if (baos != null) {
                        try {
                            baos.close();
                        }
                        catch (IOException e222222) {
                            if (firstException == null) {
                                firstException = e222222;
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block34: {
                    IOException e222222;
                    block33: {
                        block32: {
                            Object var14_15 = null;
                            if (oos != null) {
                                try {
                                    oos.close();
                                    byte[] bytes = baos.toByteArray();
                                    rv = new Document(bytes);
                                    zout = null;
                                    baos = null;
                                }
                                catch (IOException e222222) {
                                    if (firstException != null) break block32;
                                    firstException = e222222;
                                }
                            }
                        }
                        if (zout != null) {
                            try {
                                zout.close();
                                baos = null;
                            }
                            catch (IOException e222222) {
                                if (firstException != null) break block33;
                                firstException = e222222;
                            }
                        }
                    }
                    if (baos != null) {
                        try {
                            baos.close();
                        }
                        catch (IOException e222222) {
                            if (firstException != null) break block34;
                            firstException = e222222;
                        }
                    }
                }
                throw throwable;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object[] decodeDocument(long magicExpected, Document d) throws IOException {
        block35: {
            block40: {
                block31: {
                    rv = new ArrayList<Object>();
                    is = null;
                    zin = null;
                    ois = null;
                    firstException = null;
                    try {
                        try {
                            is = d.getInputStream();
                            zin = new ZipInputStream(is);
                            entry = zin.getNextEntry();
                            ois = new ObjectInputStream(zin);
                            magicRead = ois.readLong();
                            if (magicRead != magicExpected) {
                                throw new IOException("Incompatible stream returned from server, got " + magicRead + ", expected " + magicExpected);
                            }
                            howMany = ois.readInt();
                            for (i = 0; i < howMany; ++i) {
                                rv.add(ois.readObject());
                            }
                            var12_13 = rv.toArray();
                            var14_14 = null;
                            if (ois == null) break block31;
                        }
                        catch (IOException e) {
                            block34: {
                                block33: {
                                    firstException = e;
                                    var14_15 = null;
                                    if (ois != null) {
                                        try {
                                            ois.close();
                                            zin = null;
                                            is = null;
                                        }
                                        catch (IOException e) {
                                            if (firstException != null) break block33;
                                            firstException = e;
                                        }
                                    }
                                }
                                if (zin != null) {
                                    try {
                                        zin.close();
                                        is = null;
                                    }
                                    catch (IOException e) {
                                        if (firstException != null) break block34;
                                        firstException = e;
                                    }
                                }
                            }
                            if (is == null) break block35;
                            try {
                                is.close();
                            }
                            catch (IOException e) {
                                if (firstException == null) {
                                    firstException = e;
                                }
                                break block35;
                            }
                        }
                        catch (ClassNotFoundException e) {
                            block37: {
                                block36: {
                                    firstException = new IOException(e.getMessage());
                                    firstException.initCause(e);
                                    var14_16 = null;
                                    if (ois != null) {
                                        ** try [egrp 2[TRYBLOCK] [6 : 211->225)] { 
lbl64:
                                        // 1 sources

                                        ois.close();
                                        zin = null;
                                        is = null;
                                        break block36;
lbl68:
                                        // 1 sources

                                        catch (IOException e) {
                                            if (firstException != null) break block36;
                                            firstException = e;
                                        }
                                    }
                                }
                                if (zin != null) {
                                    ** try [egrp 3[TRYBLOCK] [7 : 241->252)] { 
lbl74:
                                    // 1 sources

                                    zin.close();
                                    is = null;
                                    break block37;
lbl77:
                                    // 1 sources

                                    catch (IOException e) {
                                        if (firstException != null) break block37;
                                        firstException = e;
                                    }
                                }
                            }
                            if (is == null) break block35;
                            ** try [egrp 4[TRYBLOCK] [8 : 268->276)] { 
lbl83:
                            // 1 sources

                            is.close();
lbl85:
                            // 1 sources

                            catch (IOException e) {
                                if (firstException != null) break block35;
                                firstException = e;
                            }
                            break block35;
                        }
                    }
                    catch (Throwable var13_22) {
                        block39: {
                            block38: {
                                var14_17 = null;
                                if (ois != null) {
                                    ** try [egrp 2[TRYBLOCK] [6 : 211->225)] { 
lbl94:
                                    // 1 sources

                                    ois.close();
                                    zin = null;
                                    is = null;
                                    break block38;
lbl98:
                                    // 1 sources

                                    catch (IOException e) {
                                        if (firstException != null) break block38;
                                        firstException = e;
                                    }
                                }
                            }
                            if (zin != null) {
                                ** try [egrp 3[TRYBLOCK] [7 : 241->252)] { 
lbl104:
                                // 1 sources

                                zin.close();
                                is = null;
                                break block39;
lbl107:
                                // 1 sources

                                catch (IOException e) {
                                    if (firstException != null) break block39;
                                    firstException = e;
                                }
                            }
                        }
                        if (is == null) throw var13_22;
                        ** try [egrp 4[TRYBLOCK] [8 : 268->276)] { 
lbl113:
                        // 1 sources

                        is.close();
                        throw var13_22;
lbl115:
                        // 1 sources

                        catch (IOException e) {
                            if (firstException != null) throw var13_22;
                            firstException = e;
                        }
                        throw var13_22;
                    }
                    ** try [egrp 2[TRYBLOCK] [6 : 211->225)] { 
lbl121:
                    // 1 sources

                    ois.close();
                    zin = null;
                    is = null;
                    break block31;
lbl125:
                    // 1 sources

                    catch (IOException e) {
                        if (firstException != null) break block31;
                        firstException = e;
                    }
                }
                if (zin != null) {
                    ** try [egrp 3[TRYBLOCK] [7 : 241->252)] { 
lbl131:
                    // 1 sources

                    zin.close();
                    is = null;
                    break block40;
lbl134:
                    // 1 sources

                    catch (IOException e) {
                        if (firstException != null) break block40;
                        firstException = e;
                    }
                }
            }
            if (is == null) return var12_13;
            try {}
            catch (IOException e) {
                if (firstException != null) return var12_13;
                firstException = e;
                return var12_13;
            }
            is.close();
            return var12_13;
        }
        if (firstException == null) return null;
        throw firstException;
    }
}

