/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.util;

import com.adobe.idp.dsc.util.ByteArrayURLStreamHandler;
import com.adobe.idp.dsc.util.IOUtil;
import com.adobe.idp.dsc.util.TextUtil;
import com.adobe.logging.AdobeLogger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.logging.Level;

public class HashMapClassLoader
extends ClassLoader {
    public static final AdobeLogger logger = AdobeLogger.getAdobeLogger(HashMapClassLoader.class);
    protected Map m_classBytes = null;
    protected Map m_dependentResources;
    protected String[] m_embeddedJars = null;
    protected Date m_createTime = null;

    public HashMapClassLoader(Map aClassBytes, ClassLoader aParent, Date aCreateTime) {
        super(aParent);
        this.m_classBytes = aClassBytes;
        this.m_createTime = aCreateTime;
    }

    public HashMapClassLoader(Map aClassBytes, ClassLoader aParent) {
        super(aParent);
        this.m_classBytes = aClassBytes;
        this.m_createTime = new Date();
    }

    public void setEmbeddedJars(String[] aEmbeddedJarNames) {
        this.m_embeddedJars = aEmbeddedJarNames;
    }

    public String[] getEmbeddedJars() {
        if (this.m_embeddedJars == null) {
            return new String[0];
        }
        return this.m_embeddedJars;
    }

    public Class findClass(String aClassName) throws ClassNotFoundException {
        byte[] _byte_code = this.getBytes(aClassName.replace('.', '/') + ".class");
        if (_byte_code == null || _byte_code.length == 0) {
            throw new ClassNotFoundException("Class: " + aClassName + " not found.");
        }
        return this.defineClass(aClassName, _byte_code, 0, _byte_code.length);
    }

    public URL findResource(String aResourceName) {
        byte[] _buff = this.getBytes(aResourceName);
        URL _url = null;
        try {
            if (_buff != null && _buff.length > 0) {
                _url = new URL("", "", -1, aResourceName, new ByteArrayURLStreamHandler(_buff));
            }
        }
        catch (MalformedURLException murlEx) {
            murlEx.printStackTrace();
        }
        return _url;
    }

    public byte[] getBytes(String aResource) {
        byte[] _buff = (byte[])this.m_classBytes.get(aResource);
        if (_buff != null) {
            return _buff;
        }
        return this.getBytesFromDependentLibs(aResource);
    }

    protected byte[] getBytesFromDependentLibs(String aResource) {
        if (this.m_dependentResources == null) {
            HashMap _dependentResources = new HashMap();
            String[] _embeddedJarPaths = this.getEmbeddedJars();
            if (_embeddedJarPaths.length == 0) {
                return null;
            }
            for (int i = 0; i < _embeddedJarPaths.length; ++i) {
                String _jarPath = _embeddedJarPaths[i];
                if (TextUtil.isEmpty(_jarPath)) continue;
                byte[] _jarBuff = (byte[])this.m_classBytes.get(_jarPath = _jarPath.trim());
                if (_jarBuff == null || _jarBuff.length == 0) {
                    if (!logger.isLoggable(Level.WARNING)) continue;
                    logger.warning("Jar file: " + _jarPath + " does not exist");
                    continue;
                }
                try {
                    ByteArrayInputStream _bin = new ByteArrayInputStream(_jarBuff);
                    JarInputStream _jin = new JarInputStream(_bin);
                    Map _entries = IOUtil.readEntriesFromJarInputStreamAsMap(_jin);
                    _dependentResources.putAll(_entries);
                    continue;
                }
                catch (IOException ex) {
                    if (!logger.isLoggable(Level.WARNING)) continue;
                    logger.warning("Unable to load Jar file:" + _jarPath);
                }
            }
            this.m_dependentResources = _dependentResources;
        }
        byte[] _buff = (byte[])this.m_dependentResources.get(aResource);
        return _buff;
    }

    public Date getCreateTime() {
        return this.m_createTime;
    }
}

