/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.util;

import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.util.IOUtil;
import com.adobe.idp.dsc.util.TextUtil;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOMUtil {
    protected static int DEFAULT_BUFFER = 32768;

    public static String getAttributeValue(Node aNode, String aName) {
        NamedNodeMap _attribs = aNode.getAttributes();
        for (int y = 0; y < _attribs.getLength(); ++y) {
            Node _attr = _attribs.item(y);
            if (_attr.getNodeType() != 2 || !_attr.getNodeName().equals(aName)) continue;
            return _attr.getNodeValue();
        }
        return null;
    }

    public static Node[] getChildNodes(Node aNode, String aName) {
        ArrayList<Node> _list = new ArrayList<Node>();
        NodeList _children = aNode.getChildNodes();
        for (int i = 0; i < _children.getLength(); ++i) {
            Node _child_node = _children.item(i);
            if (!_child_node.getNodeName().equals(aName)) continue;
            _list.add(_child_node);
        }
        Object[] _objects = _list.toArray();
        Node[] _nodes = new Node[_objects.length];
        for (int i = 0; i < _nodes.length; ++i) {
            _nodes[i] = (Node)_objects[i];
        }
        return _nodes;
    }

    public static Node getChildNode(Node aNode, String aName) {
        NodeList _children = aNode.getChildNodes();
        for (int i = 0; i < _children.getLength(); ++i) {
            Node _child_node = _children.item(i);
            if (!_child_node.getNodeName().equals(aName)) continue;
            return _child_node;
        }
        return null;
    }

    public static Document parseDocumentFromString(String aXML) throws ParserConfigurationException, SAXException {
        return DOMUtil.parseDocumentFromString(aXML, false, false);
    }

    public static Document parseDocumentFromString(String aXML, boolean aNamespaceAware, boolean aValidating) throws ParserConfigurationException, SAXException {
        DocumentBuilderFactory _dbf = DocumentBuilderFactory.newInstance();
        _dbf.setNamespaceAware(aNamespaceAware);
        _dbf.setValidating(aValidating);
        DocumentBuilder _db = _dbf.newDocumentBuilder();
        Document _doc = null;
        _db.setErrorHandler(new ErrorHandler(){

            public void fatalError(SAXParseException ex) {
            }

            public void error(SAXParseException ex) {
            }

            public void warning(SAXParseException ex) {
            }
        });
        try {
            _doc = _db.parse(new InputSource(new StringReader(aXML)));
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            throw new RuntimeException(ioEx.getMessage());
        }
        catch (SAXException e) {
            String message = e.getMessage();
            if (message != null && message.contains("prefix") && message.contains("is not bound")) {
                _dbf.setNamespaceAware(false);
                DocumentBuilder _namespaceUnawareDocBuilder = _dbf.newDocumentBuilder();
                try {
                    _doc = _namespaceUnawareDocBuilder.parse(new InputSource(new StringReader(aXML)));
                }
                catch (IOException ioEx) {
                    ioEx.printStackTrace();
                    throw new RuntimeException(ioEx.getMessage());
                }
            }
            throw e;
        }
        return _doc;
    }

    public static Document parseDocumentFromFile(File aFile, boolean aNamespaceAware, boolean aValidating) throws ParserConfigurationException, SAXException, IOException {
        String _text = IOUtil.readStringFromFile(aFile);
        return DOMUtil.parseDocumentFromString(_text, aNamespaceAware, aValidating);
    }

    public static Document parseDocumentFromFile(File aFile) throws ParserConfigurationException, SAXException, IOException {
        String _text = IOUtil.readStringFromFile(aFile);
        return DOMUtil.parseDocumentFromString(_text);
    }

    public static Document parseDocumentFromStream(InputStream aInputStream) throws ParserConfigurationException, SAXException, IOException {
        String _text = IOUtil.readStringFromStream(aInputStream);
        return DOMUtil.parseDocumentFromString(_text);
    }

    public static Document parseDocumentFromStream(InputStream aInputStream, boolean aNamespaceAware, boolean aValidating) throws ParserConfigurationException, SAXException, IOException {
        String _text = IOUtil.readStringFromStream(aInputStream);
        return DOMUtil.parseDocumentFromString(_text, aNamespaceAware, aValidating);
    }

    public static Document parseDocumentFromReader(Reader aReader) throws ParserConfigurationException, SAXException, IOException {
        String _text = IOUtil.readStringFromReader(aReader);
        return DOMUtil.parseDocumentFromString(_text);
    }

    public static Document parseDocumentFromReader(Reader aReader, boolean aNamespaceAware, boolean aValidating) throws ParserConfigurationException, SAXException, IOException {
        String _text = IOUtil.readStringFromReader(aReader);
        return DOMUtil.parseDocumentFromString(_text, aNamespaceAware, aValidating);
    }

    public static Document parseDocumentFromResource(ClassLoader aLoader, String aResourceName) throws ParserConfigurationException, SAXException, IOException {
        InputStream _in = aLoader.getResourceAsStream(aResourceName);
        return DOMUtil.parseDocumentFromStream(_in);
    }

    public static Document parseDocumentFromResource(String aResourceName) throws ParserConfigurationException, SAXException, IOException {
        InputStream _in = DOMUtil.class.getClassLoader().getResourceAsStream(aResourceName);
        if (_in == null) {
            throw new RuntimeException(aResourceName + " does not exist");
        }
        return DOMUtil.parseDocumentFromStream(_in);
    }

    public static void print(Node aNode, OutputStream aStream) throws IOException {
        DOMUtil.print(aNode, aStream, false);
    }

    public static void print(Node aNode, OutputStream stream, boolean aOmitDeclaration) throws IOException {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer t = tf.newTransformer();
            t.setOutputProperty("encoding", "UTF-8");
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            if (aOmitDeclaration) {
                t.setOutputProperty("omit-xml-declaration", "yes");
            } else {
                t.setOutputProperty("omit-xml-declaration", "no");
            }
            DOMSource domsource = null;
            if (aNode instanceof Element) {
                domsource = new DOMSource(aNode);
            } else if (aNode instanceof Document) {
                domsource = new DOMSource(aNode);
            } else if (aNode instanceof DocumentFragment) {
                domsource = new DOMSource(aNode);
            } else {
                throw new RuntimeException("Cannot serialize node type: " + aNode.getNodeType());
            }
            StreamResult sr = new StreamResult(stream);
            t.transform(domsource, sr);
        }
        catch (TransformerConfigurationException tce) {
            throw new RuntimeException(tce.getLocalizedMessage(), tce);
        }
        catch (TransformerException te) {
            throw new RuntimeException(te.getLocalizedMessage(), te);
        }
    }

    public static void print(Node aNode, Writer aWriter) throws IOException {
        DOMUtil.print(aNode, aWriter, false);
    }

    public static void print(Node aNode, Writer aWriter, boolean aOmitDeclaration) throws IOException {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer t = tf.newTransformer();
            t.setOutputProperty("encoding", "UTF-8");
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            if (aOmitDeclaration) {
                t.setOutputProperty("omit-xml-declaration", "yes");
            } else {
                t.setOutputProperty("omit-xml-declaration", "no");
            }
            DOMSource domsource = null;
            if (aNode instanceof Element) {
                domsource = new DOMSource(aNode);
            } else if (aNode instanceof Document) {
                domsource = new DOMSource(aNode);
            } else if (aNode instanceof DocumentFragment) {
                domsource = new DOMSource(aNode);
            } else {
                throw new RuntimeException("Cannot serialize node type: " + aNode.getNodeType());
            }
            StreamResult sr = new StreamResult(aWriter);
            t.transform(domsource, sr);
        }
        catch (TransformerConfigurationException tce) {
            throw new RuntimeException(tce.getLocalizedMessage(), tce);
        }
        catch (TransformerException te) {
            throw new RuntimeException(te.getLocalizedMessage(), te);
        }
    }

    public static void print(Element elt) {
        try {
            DOMUtil.print((Node)elt, System.out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String toString(Node aNode) {
        return DOMUtil.toString(aNode, true);
    }

    public static String toString(Node aNode, boolean aOmitXMLDeclaration) {
        if (aNode == null) {
            return null;
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer t = tf.newTransformer();
            t.setOutputProperty("encoding", "UTF-8");
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            if (aOmitXMLDeclaration) {
                t.setOutputProperty("omit-xml-declaration", "yes");
            } else {
                t.setOutputProperty("omit-xml-declaration", "no");
            }
            DOMSource domsource = null;
            if (aNode instanceof Element) {
                domsource = new DOMSource(aNode);
            } else if (aNode instanceof Document) {
                domsource = new DOMSource(aNode);
            } else if (aNode instanceof DocumentFragment) {
                domsource = new DOMSource(aNode);
            } else {
                throw new RuntimeException("Cannot serialize node type: " + aNode.getNodeType());
            }
            CharArrayWriter _buff = new CharArrayWriter();
            StreamResult sr = new StreamResult(_buff);
            t.transform(domsource, sr);
            return _buff.toString();
        }
        catch (TransformerConfigurationException tce) {
            throw new RuntimeException(tce.getLocalizedMessage(), tce);
        }
        catch (TransformerException te) {
            throw new RuntimeException(te.getLocalizedMessage(), te);
        }
    }

    public static Node getTextNode(Node start) {
        Node n = null;
        start.normalize();
        NodeList nl = start.getChildNodes();
        int len = nl.getLength();
        if (len == 0) {
            return null;
        }
        for (int i = 0; i < len; ++i) {
            n = nl.item(i);
            if (n.getNodeType() == 3) {
                return n;
            }
            if (n.getNodeType() != 4) continue;
            return n;
        }
        return null;
    }

    public static Node getTextNode(Element start, String aElmName) {
        Node _n = null;
        start.normalize();
        Element _child = DOMUtil.getChildElement(start, aElmName);
        if (_child == null) {
            return null;
        }
        NodeList _nl = _child.getChildNodes();
        int _len = _nl.getLength();
        for (int i = 0; i < _len; ++i) {
            _n = _nl.item(i);
            if (_n.getNodeType() == 3) {
                return _n;
            }
            if (_n.getNodeType() != 4) continue;
            return _n;
        }
        return null;
    }

    public static String getTextForNode(Node aNode) {
        if (aNode == null) {
            return null;
        }
        if (aNode.getNodeType() == 2) {
            return aNode.getNodeValue();
        }
        if (aNode.getNodeType() == 3) {
            return aNode.getNodeValue();
        }
        Node txt = DOMUtil.getTextNode(aNode);
        if (txt != null) {
            return txt.getNodeValue();
        }
        return null;
    }

    public static String getTextForChild(Element start, String aElmName) {
        Node txt = DOMUtil.getTextNode(start, aElmName);
        if (txt != null) {
            return txt.getNodeValue();
        }
        return null;
    }

    public static String getRequiredTextForChild(Element start, String aElmName) {
        Node txt = DOMUtil.getTextNode(start, aElmName);
        String _val = null;
        if (txt != null) {
            _val = txt.getNodeValue();
        }
        if (_val == null) {
            throw new RuntimeException("No text exists for element: " + aElmName + " under element: " + start.getNodeName());
        }
        return _val;
    }

    public static String getRequiredTextForAttr(Element start, String aAttrName) {
        String _val = DOMUtil.getAttributeValue(start, aAttrName);
        if (TextUtil.isEmpty(_val)) {
            throw new RuntimeException("No text exists for attr: " + aAttrName + " under element: " + start.getNodeName());
        }
        return _val;
    }

    public static Element[] getChildElements(Element start) {
        ArrayList<Node> _list = new ArrayList<Node>();
        NodeList _children = start.getChildNodes();
        for (int i = 0; i < _children.getLength(); ++i) {
            Node _child_node = _children.item(i);
            if (_child_node.getNodeType() != 1) continue;
            _list.add(_child_node);
        }
        Element[] _nodes = new Element[_list.size()];
        _list.toArray(_nodes);
        return _nodes;
    }

    public static Element[] getChildElements(Element aNode, String aName) {
        ArrayList<Node> _list = new ArrayList<Node>();
        NodeList _children = aNode.getChildNodes();
        for (int i = 0; i < _children.getLength(); ++i) {
            Node _child_node = _children.item(i);
            if (!_child_node.getNodeName().equals(aName) || _child_node.getNodeType() != 1) continue;
            _list.add(_child_node);
        }
        Element[] _nodes = new Element[_list.size()];
        _list.toArray(_nodes);
        return _nodes;
    }

    public static Element[] getChildElementsNS(Element aNode, String aNS, String aName) {
        ArrayList<Node> _list = new ArrayList<Node>();
        NodeList _children = aNode.getChildNodes();
        for (int i = 0; i < _children.getLength(); ++i) {
            Node _child_node = _children.item(i);
            if (_child_node.getNamespaceURI() == null || !_child_node.getNamespaceURI().equals(aNS) || !_child_node.getLocalName().equals(aName) || _child_node.getNodeType() != 1) continue;
            _list.add(_child_node);
        }
        Element[] _nodes = new Element[_list.size()];
        _list.toArray(_nodes);
        return _nodes;
    }

    public static boolean hasChild(Element start, String name) {
        NodeList nl = start.getChildNodes();
        int len = nl.getLength();
        Node n = null;
        for (int i = 0; i < len; ++i) {
            n = nl.item(i);
            if (!n.getNodeName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static Element getChildElement(Node start, String name) {
        NodeList nl = null;
        if (start.getNodeType() == 9) {
            Element _elm = ((Document)start).getDocumentElement();
            if (_elm != null) {
                String _localOrNodeName = _elm.getLocalName();
                if (_localOrNodeName == null) {
                    _localOrNodeName = _elm.getNodeName();
                }
                if (_localOrNodeName.equals(name)) {
                    return _elm;
                }
                return null;
            }
            return null;
        }
        nl = start.getChildNodes();
        int len = nl.getLength();
        Node n = null;
        for (int i = 0; i < len; ++i) {
            n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            String _localOrNodeName = n.getLocalName();
            if (_localOrNodeName == null) {
                _localOrNodeName = n.getNodeName();
            }
            if (!_localOrNodeName.equals(name)) continue;
            return (Element)n;
        }
        return null;
    }

    public static Element getChildElementNS(Element start, String aNS, String name) {
        NodeList nl = null;
        if (start.getNodeType() == 9) {
            Element _elm = ((Document)((Object)start)).getDocumentElement();
            if (_elm != null && _elm.getNamespaceURI() != null && _elm.getNamespaceURI().equals(aNS) && _elm.getLocalName().equals(name)) {
                return _elm;
            }
            return null;
        }
        nl = start.getChildNodes();
        int len = nl.getLength();
        Node n = null;
        for (int i = 0; i < len; ++i) {
            n = nl.item(i);
            if (n.getNodeType() != 1 || n.getNamespaceURI() == null || !n.getNamespaceURI().equals(aNS) || !n.getLocalName().equals(name)) continue;
            return (Element)n;
        }
        return null;
    }

    public static Element getFirstChildElement(Node start) {
        Node n = null;
        NodeList nl = start.getChildNodes();
        int len = nl.getLength();
        if (len == 0) {
            return null;
        }
        for (int i = 0; i < len; ++i) {
            n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public static Element getLastChildElement(Node start) {
        NodeList children = start.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            Node n = null;
            for (int i = len - 1; i >= 0; --i) {
                n = children.item(i);
                if (n.getNodeType() != 1) continue;
                return (Element)n;
            }
        }
        return null;
    }

    public static Document newDocument() throws ParserConfigurationException {
        return DOMUtil.newDocument(false, false);
    }

    public static Document newDocument(boolean aNamespaceAware, boolean aValidating) throws ParserConfigurationException {
        DocumentBuilderFactory _dbf = DocumentBuilderFactory.newInstance();
        _dbf.setNamespaceAware(aNamespaceAware);
        _dbf.setValidating(aValidating);
        DocumentBuilder _db = _dbf.newDocumentBuilder();
        return _db.newDocument();
    }

    public static Element createElementWithText(Element aParent, String aElementName, String aText) {
        Document _doc = aParent.getOwnerDocument();
        Element _elm = _doc.createElement(aElementName);
        aParent.appendChild(_elm);
        if (aText != null) {
            _elm.appendChild(_doc.createTextNode(aText));
        }
        return _elm;
    }

    public static Element createElement(Element aParent, String aElementName) {
        Document _doc = aParent.getOwnerDocument();
        Element _elm = _doc.createElement(aElementName);
        aParent.appendChild(_elm);
        return _elm;
    }

    public static Attr createAttribute(Element aElement, String aName) {
        Attr _attr = aElement.getAttributeNode(aName);
        if (_attr == null) {
            _attr = aElement.getOwnerDocument().createAttribute(aName);
            aElement.setAttributeNode(_attr);
        }
        return _attr;
    }

    public static void setNodeText(Node aNode, String aValue) {
        if (aNode == null) {
            throw new NullPointerException("Cannot set text on null node.");
        }
        if (aNode instanceof Text) {
            aNode.setNodeValue(aValue);
        } else if (aNode instanceof Attr) {
            aNode.setNodeValue(aValue);
        } else if (aNode instanceof Element) {
            Element _elm = (Element)aNode;
            Node _node = DOMUtil.getTextNode(_elm);
            if (_node == null) {
                if (aValue == null) {
                    return;
                }
                Document _doc = _elm.getOwnerDocument();
                Text _tn = _doc.createTextNode(aValue);
                _elm.appendChild(_tn);
            } else if (aValue == null) {
                _elm.removeChild(_node);
            } else {
                _node.setNodeValue(aValue);
            }
        } else {
            if (aNode instanceof Document) {
                throw new IllegalArgumentException("Cannot set text on a document node.");
            }
            throw new IllegalArgumentException("Cannot set text on unknown node type.");
        }
    }

    public static void resetIds(Element aNode) {
        DOMUtil.resetIds(aNode, System.currentTimeMillis());
    }

    public static long resetIds(Element aNode, long aSeed) {
        if (aNode == null || aNode.getNodeType() != 1) {
            return aSeed;
        }
        aNode.setAttribute("id", "NR" + aSeed);
        Element[] _elms = DOMUtil.getChildElements(aNode);
        for (int i = 0; i < _elms.length; ++i) {
            Element _elm = _elms[i];
            DOMUtil.resetIds(_elm, ++aSeed);
        }
        return ++aSeed;
    }

    public static void importXMLAsSubtree(Element aNode, String xmlContent) throws ParserConfigurationException, IOException, SAXException {
        if (aNode == null) {
            throw new NullPointerException("Cannot import XML under a null node.");
        }
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = docBuilder.parse(new InputSource(new StringReader(xmlContent)));
        Document toImportInto = aNode.getOwnerDocument();
        Node importedNode = toImportInto.importNode(doc.getDocumentElement(), true);
        aNode.appendChild(importedNode);
    }

    public static boolean isValidTagName(String aTagName) {
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            doc.createElement(aTagName);
            return true;
        }
        catch (ParserConfigurationException e) {
            return false;
        }
        catch (DOMException e) {
            return false;
        }
    }

    public static boolean getBooleanForAttr(Element aElm, String aAttrName) {
        if (aElm == null || TextUtil.isEmpty(aAttrName)) {
            return false;
        }
        String _val = aElm.getAttribute(aAttrName);
        if (TextUtil.isEmpty(_val)) {
            return false;
        }
        if (_val.equalsIgnoreCase("true")) {
            return true;
        }
        return new Boolean(_val);
    }

    public static byte[] writeXmlToBytes(Document document) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(DEFAULT_BUFFER);
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(out);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
            return out.toByteArray();
        }
        catch (TransformerException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public static byte[] writeXmlToBytes(Node node) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(DEFAULT_BUFFER);
            DOMSource source = new DOMSource(node);
            StreamResult result = new StreamResult(out);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
            return out.toByteArray();
        }
        catch (TransformerException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public static Map extractNamespacesFromRoot(Document doc) {
        HashMap<String, String> _namespaces = null;
        if (doc != null) {
            Element rootNode = doc.getDocumentElement();
            NamedNodeMap _nodeMap = rootNode.getAttributes();
            if (_nodeMap != null && _nodeMap.getLength() > 0) {
                _namespaces = new HashMap<String, String>(_nodeMap.getLength());
                for (int i = 0; i < _nodeMap.getLength(); ++i) {
                    String[] _namePrefix;
                    Node _attrib = _nodeMap.item(i);
                    String nodeName = _attrib.getNodeName();
                    if (!nodeName.startsWith("xmlns") || (_namePrefix = nodeName.split(":")).length <= 1) continue;
                    _namespaces.put(_namePrefix[1], _attrib.getNodeValue());
                }
            } else {
                _namespaces = Collections.EMPTY_MAP;
            }
        } else {
            _namespaces = Collections.EMPTY_MAP;
        }
        return _namespaces;
    }
}

