/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.util;

import com.adobe.idp.Document;
import com.adobe.idp.dsc.DSCError;
import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.util.ClassHelper;
import com.adobe.idp.dsc.util.ClassLoaderAwareObjectInputStream;
import com.adobe.idp.dsc.util.DOMUtil;
import com.adobe.idp.dsc.util.InvalidCoercionException;
import com.adobe.idp.dsc.util.TextUtil;
import com.adobe.idp.dsc.util.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoercionUtil {
    public static final TimeZone STANDARD_TIMEZONE = TimeZone.getTimeZone("GMT");
    private static final Boolean BOOLEAN_FALSE_VALUE = new Boolean(false);
    private static final Boolean BOOLEAN_TRUE_VALUE = new Boolean(true);
    protected static final BigDecimal NULL_DECIMAL_VALUE = new BigDecimal(0);
    protected static final Byte NULL_BYTE_VALUE = new Byte(0);
    protected static final Short NULL_SHORT_VALUE = new Short(0);
    protected static final Integer NULL_INTEGER_VALUE = new Integer(0);
    protected static final Long NULL_LONG_VALUE = new Long(0L);
    protected static final Float NULL_FLOAT_VALUE = new Float(0.0f);
    protected static final Double NULL_DOUBLE_VALUE = new Double(0.0);
    protected static final Boolean NULL_BOOLEAN_VALUE = new Boolean(false);
    protected static final Character NULL_CHAR_VALUE = new Character('\u0000');
    protected static final String BYTE_ARRAY_ID = "byte[]";
    protected static final Logger logger = Logger.getLogger(CoercionUtil.class.getName());
    private static List<String> coercibles_;

    public static final BigDecimal toDecimal(Object aVal) {
        if (aVal == null) {
            return NULL_DECIMAL_VALUE;
        }
        if (aVal instanceof BigDecimal) {
            return (BigDecimal)aVal;
        }
        if (aVal instanceof Number) {
            Number _val = (Number)aVal;
            return new BigDecimal(_val.doubleValue());
        }
        if (aVal instanceof String) {
            String _val = (String)aVal;
            if (TextUtil.isEmpty(_val)) {
                return NULL_DECIMAL_VALUE;
            }
            return new BigDecimal(_val);
        }
        if (aVal instanceof Boolean) {
            Boolean _val = (Boolean)aVal;
            return new BigDecimal(_val != false ? 1 : 0);
        }
        if (aVal instanceof Date) {
            Date _val = (Date)aVal;
            return new BigDecimal(_val.getTime());
        }
        if (aVal instanceof List) {
            Object _nodeToReturn = ((List)aVal).get(0);
            if (_nodeToReturn instanceof BigDecimal) {
                return (BigDecimal)_nodeToReturn;
            }
            return CoercionUtil.toDecimal(_nodeToReturn);
        }
        throw new InvalidCoercionException(BigDecimal.class, aVal);
    }

    public static final Boolean toBoolean(Object aVal) {
        if (aVal == null) {
            return BOOLEAN_FALSE_VALUE;
        }
        if (aVal instanceof Number) {
            Number _val = (Number)aVal;
            return new Boolean(_val.intValue() != 0);
        }
        if (aVal instanceof String) {
            String _val = (String)aVal;
            if (_val.equalsIgnoreCase("true") || _val.equals("1")) {
                return BOOLEAN_TRUE_VALUE;
            }
            if (_val.equalsIgnoreCase("false") || _val.equals("0")) {
                return BOOLEAN_FALSE_VALUE;
            }
            return new Boolean(Boolean.valueOf(_val));
        }
        if (aVal instanceof Boolean) {
            Boolean _val = (Boolean)aVal;
            return _val;
        }
        if (aVal instanceof Date) {
            Date _val = (Date)aVal;
            return new Boolean(_val.getTime() != 0L);
        }
        if (aVal instanceof List) {
            Object _nodeToReturn = ((List)aVal).get(0);
            if (_nodeToReturn instanceof Boolean) {
                return (Boolean)_nodeToReturn;
            }
            return CoercionUtil.toBoolean(_nodeToReturn);
        }
        throw new InvalidCoercionException(Boolean.class, aVal);
    }

    public static final Integer toInteger(Object aVal) {
        if (aVal == null) {
            return NULL_INTEGER_VALUE;
        }
        if (aVal instanceof Integer) {
            return (Integer)aVal;
        }
        if (aVal instanceof Number) {
            Number _val = (Number)aVal;
            return new Integer(_val.intValue());
        }
        if (aVal instanceof String) {
            String _val = (String)aVal;
            if (TextUtil.isEmpty(_val)) {
                return NULL_INTEGER_VALUE;
            }
            return new Integer(_val);
        }
        if (aVal instanceof Boolean) {
            Boolean _val = (Boolean)aVal;
            return new Integer(_val != false ? 1 : 0);
        }
        if (aVal instanceof Date) {
            Date _val = (Date)aVal;
            return new Integer((int)_val.getTime());
        }
        if (aVal instanceof List) {
            Object _nodeToReturn = ((List)aVal).get(0);
            if (_nodeToReturn instanceof Integer) {
                return (Integer)_nodeToReturn;
            }
            return CoercionUtil.toInteger(_nodeToReturn);
        }
        throw new InvalidCoercionException(Integer.class, aVal);
    }

    public static final Byte toByte(Object aVal) {
        if (aVal == null) {
            return NULL_BYTE_VALUE;
        }
        if (aVal instanceof Byte) {
            return (Byte)aVal;
        }
        if (aVal instanceof Number) {
            Number _val = (Number)aVal;
            return new Byte(_val.byteValue());
        }
        if (aVal instanceof String) {
            String _val = (String)aVal;
            if (TextUtil.isEmpty(_val)) {
                return NULL_BYTE_VALUE;
            }
            return new Byte(_val);
        }
        if (aVal instanceof Boolean) {
            Boolean _val = (Boolean)aVal;
            return new Byte(_val != false ? (byte)1 : 0);
        }
        if (aVal instanceof Date) {
            Date _val = (Date)aVal;
            return new Byte((byte)_val.getTime());
        }
        if (aVal instanceof List) {
            Object _nodeToReturn = ((List)aVal).get(0);
            if (_nodeToReturn instanceof Byte) {
                return (Byte)_nodeToReturn;
            }
            return CoercionUtil.toByte(_nodeToReturn);
        }
        throw new InvalidCoercionException(Byte.class, aVal);
    }

    public static final Character toCharacter(Object aVal) {
        if (aVal == null) {
            return NULL_CHAR_VALUE;
        }
        if (aVal instanceof Character) {
            return (Character)aVal;
        }
        if (aVal instanceof Number) {
            Number _val = (Number)aVal;
            return new Character((char)_val.intValue());
        }
        if (aVal instanceof String && ((String)aVal).length() == 1) {
            String _val = (String)aVal;
            if (TextUtil.isEmpty(_val)) {
                return NULL_CHAR_VALUE;
            }
            return new Character(_val.charAt(0));
        }
        if (aVal instanceof Boolean) {
            Boolean _val = (Boolean)aVal;
            return new Character(_val != false ? (char)'\u0001' : '\u0000');
        }
        if (aVal instanceof List) {
            Object _nodeToReturn = ((List)aVal).get(0);
            if (_nodeToReturn instanceof Character) {
                return (Character)_nodeToReturn;
            }
            return CoercionUtil.toCharacter(_nodeToReturn);
        }
        throw new InvalidCoercionException(Character.class, aVal);
    }

    public static final byte[] toBytes(Object aVal) {
        if (aVal == null) {
            return null;
        }
        if (aVal instanceof String) {
            return ((String)aVal).getBytes();
        }
        if (aVal instanceof byte[]) {
            return (byte[])aVal;
        }
        try {
            OutputStream _dos;
            ByteArrayOutputStream _bos = new ByteArrayOutputStream();
            DataOutputStream _os = null;
            if (aVal instanceof Integer) {
                _dos = new DataOutputStream(_bos);
                _os = _dos;
                ((DataOutputStream)_dos).writeInt((Integer)aVal);
            } else if (aVal instanceof Long) {
                _dos = new DataOutputStream(_bos);
                _os = _dos;
                ((DataOutputStream)_dos).writeLong((Long)aVal);
            } else if (aVal instanceof Double) {
                _dos = new DataOutputStream(_bos);
                _os = _dos;
                ((DataOutputStream)_dos).writeDouble((Double)aVal);
            } else if (aVal instanceof Short) {
                _dos = new DataOutputStream(_bos);
                _os = _dos;
                ((DataOutputStream)_dos).writeShort(((Short)aVal).shortValue());
            } else if (aVal instanceof Float) {
                _dos = new DataOutputStream(_bos);
                _os = _dos;
                ((DataOutputStream)_dos).writeFloat(((Float)aVal).floatValue());
            } else if (aVal instanceof Byte) {
                _dos = new DataOutputStream(_bos);
                _os = _dos;
                ((DataOutputStream)_dos).writeByte(((Byte)aVal).byteValue());
            } else if (aVal instanceof Boolean) {
                _dos = new DataOutputStream(_bos);
                _os = _dos;
                ((DataOutputStream)_dos).writeBoolean((Boolean)aVal);
            } else if (aVal instanceof org.w3c.dom.Document) {
                DataOutputStream _dos2;
                org.w3c.dom.Document _doc = (org.w3c.dom.Document)aVal;
                String _serializedDOM = DOMUtil.toString(_doc.getDocumentElement());
                _os = _dos2 = new DataOutputStream(_bos);
                _dos2.write(_serializedDOM.getBytes());
            } else {
                _dos = new ObjectOutputStream(_bos);
                _os = _dos;
                ((ObjectOutputStream)_dos).writeObject(aVal);
            }
            ((OutputStream)_os).flush();
            ((OutputStream)_os).close();
            byte[] result = _bos.toByteArray();
            return result;
        }
        catch (NotSerializableException e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "Coercion failed since Object of type " + e.getMessage() + " since the class does not implement serializable.");
            }
            throw new InvalidCoercionException(Byte.class, aVal);
        }
        catch (IOException e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, e.getMessage());
            }
            throw new InvalidCoercionException(Byte.class, aVal);
        }
    }

    public static final Long toLong(Object aVal) {
        if (aVal == null) {
            return NULL_LONG_VALUE;
        }
        if (aVal instanceof Long) {
            return (Long)aVal;
        }
        if (aVal instanceof Number) {
            Number _val = (Number)aVal;
            return new Long(_val.longValue());
        }
        if (aVal instanceof String) {
            String _val = (String)aVal;
            if (TextUtil.isEmpty(_val)) {
                return NULL_LONG_VALUE;
            }
            return new Long(_val);
        }
        if (aVal instanceof Boolean) {
            Boolean _val = (Boolean)aVal;
            return new Long(_val != false ? 1L : 0L);
        }
        if (aVal instanceof Date) {
            Date _val = (Date)aVal;
            return new Long(_val.getTime());
        }
        if (aVal instanceof List) {
            Object _nodeToReturn = ((List)aVal).get(0);
            if (_nodeToReturn instanceof Long) {
                return (Long)_nodeToReturn;
            }
            return CoercionUtil.toLong(_nodeToReturn);
        }
        throw new InvalidCoercionException(Long.class, aVal);
    }

    public static final Short toShort(Object aVal) {
        if (aVal == null) {
            return NULL_SHORT_VALUE;
        }
        if (aVal instanceof Short) {
            return (Short)aVal;
        }
        if (aVal instanceof Number) {
            Number _val = (Number)aVal;
            return new Short(_val.shortValue());
        }
        if (aVal instanceof String) {
            String _val = (String)aVal;
            if (TextUtil.isEmpty(_val)) {
                return NULL_SHORT_VALUE;
            }
            return new Short(Short.parseShort(_val));
        }
        if (aVal instanceof Boolean) {
            Boolean _val = (Boolean)aVal;
            return new Short((short)(_val != false ? 1 : 0));
        }
        if (aVal instanceof Date) {
            Date _val = (Date)aVal;
            return new Short((short)_val.getTime());
        }
        if (aVal instanceof List) {
            Object _nodeToReturn = ((List)aVal).get(0);
            if (_nodeToReturn instanceof Short) {
                return (Short)_nodeToReturn;
            }
            return CoercionUtil.toShort(_nodeToReturn);
        }
        throw new InvalidCoercionException(Short.class, aVal);
    }

    public static final Double toDouble(Object aVal) {
        if (aVal == null) {
            return NULL_DOUBLE_VALUE;
        }
        if (aVal instanceof Double) {
            return (Double)aVal;
        }
        if (aVal instanceof Number) {
            Number _val = (Number)aVal;
            return new Double(_val.doubleValue());
        }
        if (aVal instanceof String) {
            String _val = (String)aVal;
            if (TextUtil.isEmpty(_val)) {
                return NULL_DOUBLE_VALUE;
            }
            return new Double(_val);
        }
        if (aVal instanceof Boolean) {
            Boolean _val = (Boolean)aVal;
            return new Double(_val != false ? 1.0 : 0.0);
        }
        if (aVal instanceof Date) {
            Date _val = (Date)aVal;
            return new Double(_val.getTime());
        }
        if (aVal instanceof List) {
            Object _nodeToReturn = ((List)aVal).get(0);
            if (_nodeToReturn instanceof Double) {
                return (Double)_nodeToReturn;
            }
            return CoercionUtil.toDouble(_nodeToReturn);
        }
        throw new InvalidCoercionException(Double.class, aVal);
    }

    public static final Float toFloat(Object aVal) {
        if (aVal == null) {
            return NULL_FLOAT_VALUE;
        }
        if (aVal instanceof Number) {
            Number _val = (Number)aVal;
            return new Float(_val.floatValue());
        }
        if (aVal instanceof String) {
            String _val = (String)aVal;
            if (TextUtil.isEmpty(_val)) {
                return NULL_FLOAT_VALUE;
            }
            return new Float(_val);
        }
        if (aVal instanceof Boolean) {
            Boolean _val = (Boolean)aVal;
            return new Float(_val != false ? 1.0f : 0.0f);
        }
        if (aVal instanceof Date) {
            Date _val = (Date)aVal;
            return new Float(_val.getTime());
        }
        if (aVal instanceof List) {
            Object _nodeToReturn = ((List)aVal).get(0);
            if (_nodeToReturn instanceof Float) {
                return (Float)_nodeToReturn;
            }
            return CoercionUtil.toFloat(_nodeToReturn);
        }
        throw new InvalidCoercionException(Float.class, aVal);
    }

    public static final String toString(Object aVal) {
        if (aVal == null) {
            return null;
        }
        if (aVal instanceof String) {
            String _val = (String)aVal;
            return _val;
        }
        if (aVal instanceof Number) {
            Number _val = (Number)aVal;
            return XMLUtil.formatISO8601Number(_val);
        }
        if (aVal instanceof Boolean) {
            Boolean _val = (Boolean)aVal;
            if (_val.booleanValue()) {
                return "true";
            }
            return "false";
        }
        if (aVal instanceof Date) {
            Date _val = (Date)aVal;
            Calendar _cal = Calendar.getInstance();
            _cal.setTime(_val);
            if (_cal.get(10) == 0 && _cal.get(12) == 0 && _cal.get(13) == 0) {
                return XMLUtil.formatISO8601Date(_val);
            }
            return XMLUtil.formatISO8601DateTime(_val);
        }
        if (aVal instanceof Node) {
            Node _node = (Node)aVal;
            if (_node.getNodeType() == 1 || _node.getNodeType() == 2 || _node.getNodeType() == 3) {
                if (_node.getNodeType() == 1) {
                    Element _elem = (Element)_node;
                    NodeList _elemChildren = _elem.getChildNodes();
                    if (_elemChildren.getLength() > 1) {
                        return DOMUtil.toString(_elem, false);
                    }
                    if (_elemChildren.getLength() != 0) {
                        if (_elem.getFirstChild().getNodeType() == 3) {
                            return DOMUtil.getTextForNode(_node);
                        }
                        return DOMUtil.toString(_elem, false);
                    }
                    return DOMUtil.getTextForNode(_elem);
                }
                return DOMUtil.getTextForNode(_node);
            }
            return DOMUtil.toString(_node, false);
        }
        if (aVal instanceof List) {
            Object _nodeToReturn = ((List)aVal).get(0);
            if (_nodeToReturn instanceof String) {
                return (String)_nodeToReturn;
            }
            return CoercionUtil.toString(_nodeToReturn);
        }
        if (aVal.getClass().isEnum()) {
            Enum anEnumVal = (Enum)aVal;
            return anEnumVal.name();
        }
        try {
            ByteArrayOutputStream _bout = new ByteArrayOutputStream();
            ObjectOutputStream _oout = new ObjectOutputStream(_bout);
            _oout.writeObject(aVal);
            _oout.flush();
            _oout.close();
            String _objectText = new String(TextUtil.base64Encode(_bout.toByteArray()));
            return _objectText;
        }
        catch (IOException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public static final Date toDateTime(Object aVal) {
        if (aVal == null) {
            return null;
        }
        if (aVal instanceof Date) {
            return (Date)aVal;
        }
        if (aVal instanceof String) {
            String _val = (String)aVal;
            if (TextUtil.isEmpty(_val)) {
                return null;
            }
            Date _result = null;
            try {
                _result = XMLUtil.parseISO8601DateTime(_val);
            }
            catch (ParseException ex) {
                // empty catch block
            }
            if (_result == null) {
                try {
                    _result = XMLUtil.parseISO8601Date(_val);
                }
                catch (ParseException ex) {
                    throw new InvalidCoercionException(Date.class, aVal);
                }
            }
            return _result;
        }
        if (aVal instanceof Number) {
            Number _val = (Number)aVal;
            return new Date(_val.longValue());
        }
        if (aVal instanceof Calendar) {
            return ((Calendar)aVal).getTime();
        }
        if (aVal instanceof List) {
            Object _nodeToReturn = ((List)aVal).get(0);
            if (_nodeToReturn instanceof Date) {
                return (Date)_nodeToReturn;
            }
            return CoercionUtil.toDateTime(_nodeToReturn);
        }
        throw new InvalidCoercionException(Date.class, aVal);
    }

    public static final Date toDate(Object aVal) {
        Date _result = null;
        if (aVal == null) {
            return null;
        }
        if (aVal instanceof Date) {
            _result = (Date)aVal;
        } else {
            if (aVal instanceof String) {
                String _val = (String)aVal;
                if (TextUtil.isEmpty(_val)) {
                    return null;
                }
                try {
                    _result = XMLUtil.parseISO8601Date(_val);
                }
                catch (ParseException ex) {
                    throw new InvalidCoercionException(Date.class, aVal);
                }
                return _result;
            }
            if (aVal instanceof Number) {
                Number _val = (Number)aVal;
                _result = new Date(_val.longValue());
            } else if (aVal instanceof Calendar) {
                _result = ((Calendar)aVal).getTime();
            } else {
                if (aVal instanceof List) {
                    Object _nodeToReturn = ((List)aVal).get(0);
                    if (_nodeToReturn instanceof Date) {
                        return (Date)_nodeToReturn;
                    }
                    return CoercionUtil.toDate(_nodeToReturn);
                }
                throw new InvalidCoercionException(Date.class, aVal);
            }
        }
        if (_result == null) {
            return null;
        }
        Calendar _cal = Calendar.getInstance(STANDARD_TIMEZONE);
        _cal.setTime(_result);
        _cal.set(11, 12);
        _cal.set(12, 0);
        _cal.set(13, 0);
        _cal.set(14, 0);
        return _cal.getTime();
    }

    public static org.w3c.dom.Document toDOMDocument(Object aVal, boolean makeNamespaceAware, boolean enableValidation) {
        try {
            org.w3c.dom.Document _doc = null;
            if (aVal != null) {
                if (aVal instanceof String) {
                    String _xml = (String)aVal;
                    if (!TextUtil.isEmpty(_xml)) {
                        _doc = DOMUtil.parseDocumentFromString((String)aVal, makeNamespaceAware, enableValidation);
                    }
                } else if (aVal instanceof org.w3c.dom.Document) {
                    _doc = (org.w3c.dom.Document)aVal;
                } else if (aVal instanceof Element) {
                    DocumentBuilderFactory _dbf = DocumentBuilderFactory.newInstance();
                    _dbf.setNamespaceAware(false);
                    _dbf.setValidating(false);
                    DocumentBuilder _db = _dbf.newDocumentBuilder();
                    DOMImplementation domImpl = null;
                    String namespace = null;
                    if (((Element)aVal).getPrefix() != null) {
                        namespace = CoercionUtil.getNamespaceURI((Node)aVal, ((Element)aVal).getPrefix());
                        domImpl = _db.getDOMImplementation();
                        _doc = domImpl.createDocument(namespace, ((Element)aVal).getPrefix() + ":" + ((Element)aVal).getLocalName(), ((Element)aVal).getOwnerDocument().getDoctype());
                        NamedNodeMap attribMap = ((Element)aVal).getAttributes();
                        for (int i = 0; i < attribMap.getLength(); ++i) {
                            Attr attrib = (Attr)attribMap.item(i);
                            Attr importedAttrib = (Attr)_doc.importNode(attrib, true);
                            _doc.getDocumentElement().setAttributeNode(importedAttrib);
                        }
                        CoercionUtil.copyTreeWithNamespaces(_doc, _doc.getDocumentElement(), ((Element)aVal).getChildNodes());
                        if (namespace != null) {
                            CoercionUtil.addNamespaceToDocument(namespace, ((Element)aVal).getPrefix(), _doc);
                        }
                    } else {
                        _doc = _db.newDocument();
                        Node importedNode = _doc.importNode((Node)aVal, true);
                        _doc.appendChild(importedNode);
                    }
                } else if (aVal instanceof Document) {
                    Document _theDoc = (Document)aVal;
                    try {
                        _doc = DOMUtil.parseDocumentFromStream(_theDoc.getInputStream(), makeNamespaceAware, enableValidation);
                    }
                    catch (Exception e) {
                        InvalidCoercionException _exception = new InvalidCoercionException(org.w3c.dom.Document.class, aVal);
                        _exception.setStackTrace(e.getStackTrace());
                        throw _exception;
                    }
                    if (_doc == null) {
                        throw new InvalidCoercionException(org.w3c.dom.Document.class, aVal);
                    }
                } else {
                    if (aVal instanceof List) {
                        Object _nodeToReturn = ((List)aVal).get(0);
                        if (_nodeToReturn instanceof org.w3c.dom.Document) {
                            return (org.w3c.dom.Document)_nodeToReturn;
                        }
                        return CoercionUtil.toDOMDocument(_nodeToReturn);
                    }
                    if (aVal instanceof byte[]) {
                        try {
                            _doc = DOMUtil.parseDocumentFromStream(new ByteArrayInputStream((byte[])aVal));
                        }
                        catch (Exception e) {
                            InvalidCoercionException _exception = new InvalidCoercionException(org.w3c.dom.Document.class, aVal);
                            _exception.setStackTrace(e.getStackTrace());
                            throw _exception;
                        }
                    } else {
                        throw new InvalidCoercionException(org.w3c.dom.Document.class, aVal);
                    }
                }
            }
            return _doc;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public static org.w3c.dom.Document toDOMDocument(Object aVal) {
        return CoercionUtil.toDOMDocument(aVal, true, false);
    }

    private static void addNamespaceToDocument(String namespace, String prefix, org.w3c.dom.Document _doc) {
        if (_doc != null && _doc.getDocumentElement() != null) {
            Element root = _doc.getDocumentElement();
            NamedNodeMap attributes = root.getAttributes();
            if (attributes.getNamedItem("xmlns:" + prefix) != null) {
                return;
            }
            Attr attrib = _doc.createAttribute("xmlns:" + prefix);
            attrib.setNodeValue(namespace);
            root.setAttributeNode(attrib);
        }
    }

    private static void copyTreeWithNamespaces(org.w3c.dom.Document _doc, Node parent, NodeList children) {
        for (int i = 0; i < children.getLength(); ++i) {
            String namespaceURI;
            Node childNode = children.item(i);
            if (childNode.getPrefix() != null && (namespaceURI = CoercionUtil.getNamespaceURI(childNode, childNode.getPrefix())) != null) {
                CoercionUtil.addNamespaceToDocument(namespaceURI, childNode.getPrefix(), _doc);
            }
            Node importedChildNode = _doc.importNode(childNode, false);
            parent.appendChild(importedChildNode);
            if (childNode.getNodeType() == 1) {
                NamedNodeMap attribMap = ((Element)childNode).getAttributes();
                for (int j = 0; j < attribMap.getLength(); ++j) {
                    Attr attrib = (Attr)attribMap.item(j);
                    Attr importedAttrib = (Attr)_doc.importNode(attrib, true);
                    ((Element)importedChildNode).setAttributeNode(importedAttrib);
                }
            }
            if (childNode.getChildNodes() == null) continue;
            CoercionUtil.copyTreeWithNamespaces(_doc, importedChildNode, childNode.getChildNodes());
        }
    }

    private static String getNamespaceURI(Node aVal, String prefix) {
        if (aVal.getNamespaceURI() != null) {
            return aVal.getNamespaceURI();
        }
        if (aVal.getParentNode() == null) {
            throw new DSCRuntimeException(new DSCError(310, prefix, (Object)aVal.getNodeName()));
        }
        Node parent = aVal.getParentNode();
        if (parent.getPrefix().compareTo(prefix) == 0 && parent.getNamespaceURI() != null) {
            return parent.getNamespaceURI();
        }
        NamedNodeMap attribMaps = parent.getAttributes();
        Node namespaceNode = null;
        if (attribMaps != null) {
            namespaceNode = attribMaps.getNamedItem("xmlns:" + ((Element)aVal).getPrefix());
        }
        if (namespaceNode == null) {
            return CoercionUtil.getNamespaceURI(aVal.getParentNode(), prefix);
        }
        return namespaceNode.getNamespaceURI();
    }

    public static Document toDocument(Object aVal) {
        try {
            Document _doc;
            block19: {
                _doc = null;
                if (aVal != null) {
                    if (aVal instanceof byte[]) {
                        byte[] _buff = (byte[])aVal;
                        ByteArrayInputStream memoryInputStream = new ByteArrayInputStream(_buff);
                        ObjectInputStream deserializer = null;
                        try {
                            deserializer = new ObjectInputStream(memoryInputStream);
                            Object _deserializedValue = deserializer.readObject();
                            if (_deserializedValue instanceof Document) {
                                _doc = (Document)_deserializedValue;
                                break block19;
                            }
                            _doc = new Document(_buff);
                        }
                        catch (StreamCorruptedException e) {
                            _doc = new Document(_buff);
                        }
                    } else if (aVal instanceof Document) {
                        _doc = (Document)aVal;
                    } else if (aVal instanceof org.w3c.dom.Document) {
                        byte[] _domBytes = DOMUtil.writeXmlToBytes((org.w3c.dom.Document)aVal);
                        _doc = new Document(_domBytes);
                    } else if (aVal instanceof Node) {
                        byte[] _domBytes = DOMUtil.writeXmlToBytes((Node)aVal);
                        _doc = new Document(_domBytes);
                    } else if (aVal instanceof String) {
                        _doc = new Document(((String)aVal).getBytes());
                    } else if (aVal instanceof List) {
                        Object toAssign = ((List)aVal).get(0);
                        _doc = toAssign instanceof Document ? (Document)toAssign : CoercionUtil.toDocument(toAssign);
                    } else {
                        throw new InvalidCoercionException(Document.class, aVal);
                    }
                }
            }
            return _doc;
        }
        catch (IOException ioEx) {
            throw new DSCRuntimeException(ioEx);
        }
        catch (ClassNotFoundException cnfEx) {
            throw new DSCRuntimeException(cnfEx);
        }
    }

    public static Object toType(Class aType, Object aVal) {
        Object _returnVal = null;
        _returnVal = aType != null ? CoercionUtil.toType(aType, aVal, aType.getClassLoader()) : CoercionUtil.toType(aType, aVal, null);
        return _returnVal;
    }

    public static boolean requiresSerialization(Class aType) {
        if (ClassHelper.isPrimitive(aType)) {
            return false;
        }
        return !Number.class.isAssignableFrom(aType) && aType != String.class && aType != Boolean.class && aType != Date.class && aType != org.w3c.dom.Document.class && aType != Document.class;
    }

    public static Properties toJavaProperties(Object aVal, ClassLoader classLoader) {
        Properties properties;
        block12: {
            properties = null;
            try {
                if (aVal instanceof Properties) {
                    properties = (Properties)aVal;
                    break block12;
                }
                if (aVal instanceof Map) {
                    Map map = (Map)aVal;
                    Map<String, Object> _checkedMap = Collections.checkedMap(map, String.class, Object.class);
                    if (_checkedMap != null && !_checkedMap.isEmpty()) {
                        properties = new Properties();
                        for (String _key : _checkedMap.keySet()) {
                            if (_key == null) continue;
                            Object _value = _checkedMap.get(_key);
                            properties.put(_key, _value);
                        }
                    } else {
                        properties = new Properties();
                    }
                    break block12;
                }
                if (aVal instanceof byte[]) {
                    ByteArrayInputStream _byteStream = new ByteArrayInputStream((byte[])aVal);
                    ObjectInputStream _objStream = null;
                    _objStream = classLoader != null ? new ClassLoaderAwareObjectInputStream(_byteStream, classLoader) : new ObjectInputStream(_byteStream);
                    properties = (Properties)_objStream.readObject();
                    break block12;
                }
                if (aVal instanceof InputStream) {
                    ObjectInputStream _objStream = null;
                    _objStream = classLoader != null ? new ClassLoaderAwareObjectInputStream((InputStream)aVal, classLoader) : new ObjectInputStream((InputStream)aVal);
                    break block12;
                }
                if (aVal instanceof ObjectInputStream) {
                    ObjectInputStream _objStream = (ObjectInputStream)aVal;
                    break block12;
                }
                throw new InvalidCoercionException(List.class, aVal);
            }
            catch (ClassCastException e) {
                throw new InvalidCoercionException(Properties.class, aVal);
            }
            catch (ClassNotFoundException e) {
                throw new InvalidCoercionException(Properties.class, aVal);
            }
            catch (IOException e) {
                throw new DSCRuntimeException(e);
            }
        }
        return properties;
    }

    public static Object toType(Class aType, Object aVal, ClassLoader aClassLoader) {
        if (aType == null) {
            return aVal;
        }
        if (ClassHelper.isPrimitive(aType) && aVal == null) {
            if (aType == Byte.TYPE) {
                return NULL_BYTE_VALUE;
            }
            if (aType == Integer.TYPE) {
                return NULL_INTEGER_VALUE;
            }
            if (aType == Float.TYPE) {
                return NULL_FLOAT_VALUE;
            }
            if (aType == Double.TYPE) {
                return NULL_DOUBLE_VALUE;
            }
            if (aType == Short.TYPE) {
                return NULL_SHORT_VALUE;
            }
            if (aType == Long.TYPE) {
                return NULL_LONG_VALUE;
            }
            if (aType == Boolean.TYPE) {
                return NULL_BOOLEAN_VALUE;
            }
            if (aType == Character.TYPE) {
                return NULL_CHAR_VALUE;
            }
        }
        if (aVal == null) {
            return null;
        }
        if (aType.isInstance(aVal)) {
            if (aVal instanceof Document) {
                // empty if block
            }
            return aVal;
        }
        if (aType.isAssignableFrom(aVal.getClass())) {
            return aVal;
        }
        if (aType == String.class) {
            return CoercionUtil.toString(aVal);
        }
        if (aType == Boolean.class || aType == Boolean.TYPE) {
            return CoercionUtil.toBoolean(aVal);
        }
        if (aType == byte[].class) {
            return CoercionUtil.toBytes(aVal);
        }
        if (aType == Byte.class || aType == Byte.TYPE) {
            return CoercionUtil.toByte(aVal);
        }
        if (aType == Character.class || aType == Character.TYPE) {
            return CoercionUtil.toCharacter(aVal);
        }
        if (aType == Integer.class || aType == Integer.TYPE) {
            return CoercionUtil.toInteger(aVal);
        }
        if (aType == Float.class || aType == Float.TYPE) {
            return CoercionUtil.toFloat(aVal);
        }
        if (aType == Double.class || aType == Double.TYPE) {
            return CoercionUtil.toDouble(aVal);
        }
        if (aType == Short.class || aType == Short.TYPE) {
            return CoercionUtil.toShort(aVal);
        }
        if (aType == Long.class || aType == Long.TYPE) {
            return CoercionUtil.toLong(aVal);
        }
        if (aType == Date.class) {
            return CoercionUtil.toDateTime(aVal);
        }
        if (aType == BigDecimal.class) {
            return CoercionUtil.toDecimal(aVal);
        }
        if (aType == org.w3c.dom.Document.class || aType == Node.class) {
            return CoercionUtil.toDOMDocument(aVal);
        }
        if (aType == Document.class) {
            return CoercionUtil.toDocument(aVal);
        }
        if (aType == Element.class) {
            org.w3c.dom.Document _doc = CoercionUtil.toDOMDocument(aVal);
            return _doc.getDocumentElement();
        }
        if (aType == List.class) {
            return CoercionUtil.toList(aVal, aClassLoader);
        }
        if (aType == Properties.class) {
            return CoercionUtil.toJavaProperties(aVal, aClassLoader);
        }
        if (aType == Map.class) {
            return CoercionUtil.toMap(aVal, aClassLoader);
        }
        if (aType.isEnum() && !(aVal instanceof byte[])) {
            return CoercionUtil.toEnum(aType, aVal);
        }
        if (aVal instanceof byte[]) {
            try {
                byte[] _buff = (byte[])aVal;
                ClassLoaderAwareObjectInputStream _oin = new ClassLoaderAwareObjectInputStream(new ByteArrayInputStream(_buff), aClassLoader);
                Object _val = _oin.readObject();
                if (aType.isInstance(_val)) {
                    return _val;
                }
                throw new InvalidCoercionException(aType, aVal);
            }
            catch (IOException ex) {
                throw new InvalidCoercionException(aType, aVal);
            }
            catch (ClassNotFoundException ex) {
                throw new InvalidCoercionException(aType, aVal);
            }
        }
        if (aVal instanceof ObjectInputStream) {
            try {
                Object _val = ((ObjectInputStream)aVal).readObject();
                if (aType.isInstance(_val)) {
                    return _val;
                }
                throw new InvalidCoercionException(aType, aVal);
            }
            catch (IOException ex) {
                throw new InvalidCoercionException(aType, aVal);
            }
            catch (ClassNotFoundException ex) {
                throw new InvalidCoercionException(aType, aVal);
            }
        }
        if (aVal instanceof InputStream) {
            try {
                ClassLoaderAwareObjectInputStream _oin = new ClassLoaderAwareObjectInputStream((InputStream)aVal, aClassLoader);
                Object _val = _oin.readObject();
                if (aType.isInstance(_val)) {
                    return _val;
                }
                throw new InvalidCoercionException(aType, aVal);
            }
            catch (IOException ex) {
                throw new InvalidCoercionException(aType, aVal);
            }
            catch (ClassNotFoundException ex) {
                throw new InvalidCoercionException(aType, aVal);
            }
        }
        if (aVal instanceof String) {
            try {
                if (TextUtil.isEmpty((String)aVal)) {
                    return null;
                }
                byte[] _buff = TextUtil.base64Decode((String)aVal);
                ClassLoaderAwareObjectInputStream _oin = new ClassLoaderAwareObjectInputStream(new ByteArrayInputStream(_buff), aClassLoader);
                Object _val = _oin.readObject();
                if (aType.isInstance(_val)) {
                    return _val;
                }
                throw new InvalidCoercionException(aType, aVal);
            }
            catch (IOException ex) {
                throw new InvalidCoercionException(aType, aVal);
            }
            catch (ClassNotFoundException ex) {
                throw new InvalidCoercionException(aType, aVal);
            }
        }
        throw new InvalidCoercionException(aType, aVal);
    }

    public static Enum toEnum(Class aType, Object aVal) {
        if (aVal == null) {
            return null;
        }
        if (aVal instanceof String) {
            String aString = (String)aVal;
            if (aString.length() == 0) {
                return null;
            }
            return Enum.valueOf(aType, aString);
        }
        throw new InvalidCoercionException(aType, aVal);
    }

    public static boolean isCoercible(Object aValue, Class aTargetType) {
        if (aValue == null || aTargetType == null || aValue.getClass() == aTargetType) {
            return true;
        }
        if (aTargetType == String.class || aTargetType == byte[].class) {
            return true;
        }
        if (Number.class.isAssignableFrom(aTargetType)) {
            return aValue instanceof Number || aValue instanceof String || aValue instanceof Boolean;
        }
        if (aTargetType == Boolean.class && (Number.class.isInstance(aValue) || aValue instanceof String)) {
            return true;
        }
        if (aTargetType == org.w3c.dom.Document.class) {
            return aValue instanceof String || aValue instanceof Node;
        }
        if (aTargetType == List.class) {
            return aValue instanceof List || aValue instanceof byte[] || aValue instanceof InputStream;
        }
        if (aTargetType == Map.class) {
            return aValue instanceof Map || aValue instanceof byte[] || aValue instanceof InputStream;
        }
        if (aTargetType == Document.class) {
            return aValue instanceof String || aValue instanceof byte[] || aValue instanceof org.w3c.dom.Document || aValue instanceof Node || aValue instanceof Document;
        }
        return true;
    }

    public static final List toList(Object aValue) {
        return CoercionUtil.toList(aValue, null);
    }

    public static final List toList(Object aValue, ClassLoader classLoader) {
        List valueList = null;
        ObjectInputStream _objStream = null;
        if (aValue == null) {
            return Collections.EMPTY_LIST;
        }
        if (aValue instanceof List) {
            return (List)aValue;
        }
        try {
            if (aValue instanceof byte[]) {
                ByteArrayInputStream _byteStream = new ByteArrayInputStream((byte[])aValue);
                _objStream = classLoader != null ? new ClassLoaderAwareObjectInputStream(_byteStream, classLoader) : new ObjectInputStream(_byteStream);
            } else if (aValue instanceof InputStream) {
                _objStream = classLoader != null ? new ClassLoaderAwareObjectInputStream((InputStream)aValue, classLoader) : new ObjectInputStream((InputStream)aValue);
            } else if (aValue instanceof ObjectInputStream) {
                _objStream = (ObjectInputStream)aValue;
            } else {
                throw new InvalidCoercionException(List.class, aValue);
            }
            valueList = (List)_objStream.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new InvalidCoercionException(List.class, aValue);
        }
        catch (IOException e) {
            throw new InvalidCoercionException(List.class, aValue);
        }
        return valueList;
    }

    public static final Map toMap(Object aValue) {
        return CoercionUtil.toMap(aValue, null);
    }

    public static final Map toMap(Object aValue, ClassLoader classLoader) {
        Map valueMap = null;
        ObjectInputStream _objStream = null;
        if (aValue == null) {
            return Collections.EMPTY_MAP;
        }
        if (aValue instanceof Map) {
            valueMap = (Map)aValue;
        } else {
            try {
                if (aValue instanceof byte[]) {
                    ByteArrayInputStream _byteStream = new ByteArrayInputStream((byte[])aValue);
                    _objStream = classLoader != null ? new ClassLoaderAwareObjectInputStream(_byteStream, classLoader) : new ObjectInputStream(_byteStream);
                } else if (aValue instanceof InputStream) {
                    _objStream = classLoader != null ? new ClassLoaderAwareObjectInputStream((InputStream)aValue, classLoader) : new ObjectInputStream((InputStream)aValue);
                } else if (aValue instanceof ObjectInputStream) {
                    _objStream = (ObjectInputStream)aValue;
                } else {
                    throw new InvalidCoercionException(List.class, aValue);
                }
                valueMap = (Map)_objStream.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new InvalidCoercionException(Map.class, aValue);
            }
            catch (IOException e) {
                throw new InvalidCoercionException(Map.class, aValue);
            }
        }
        return valueMap;
    }

    public static final Class getJavaClassForPOFType(int aPOFType) {
        switch (aPOFType) {
            case 10: {
                return byte[].class;
            }
            case 2: {
                return Boolean.class;
            }
            case 8: 
            case 12: 
            case 13: 
            case 16: {
                return Date.class;
            }
            case 7: {
                return BigDecimal.class;
            }
            case 6: {
                return Double.class;
            }
            case 5: {
                return Float.class;
            }
            case 4: {
                return Integer.class;
            }
            case 14: {
                return Long.class;
            }
            case 1: 
            case 9: 
            case 17: 
            case 18: {
                return String.class;
            }
            case 3: {
                return Short.class;
            }
        }
        return null;
    }

    public static Boolean isCoercible(String fromType, String toType) {
        if (fromType.equals(toType)) {
            return Boolean.TRUE;
        }
        if (toType.equals(String.class.getName())) {
            return Boolean.TRUE;
        }
        if (toType.equals(byte[].class.getName()) || toType.equals(BYTE_ARRAY_ID)) {
            return Boolean.TRUE;
        }
        if (CoercionUtil.checkDefinedCoercion(fromType, toType)) {
            return Boolean.TRUE;
        }
        if ((fromType = CoercionUtil.normalizeNumericType(fromType)).equals(toType = CoercionUtil.normalizeNumericType(toType)) || CoercionUtil.checkDefinedCoercion(fromType, toType)) {
            return Boolean.TRUE;
        }
        if (fromType.equals("boolean") && CoercionUtil.checkDefinedCoercion(Boolean.class.getName(), toType)) {
            return Boolean.TRUE;
        }
        if (toType.equals("boolean") && CoercionUtil.checkDefinedCoercion(fromType, Boolean.class.getName())) {
            return Boolean.TRUE;
        }
        if (toType.equals(Number.class.getName()) || toType.equals(org.w3c.dom.Document.class.getName()) || toType.equals(Document.class.getName()) || toType.equals(List.class.getName()) || toType.equals(Map.class.getName())) {
            return Boolean.FALSE;
        }
        return null;
    }

    private static String normalizeNumericType(String inType) {
        if (inType.equals("java.util.concurrent.AtomicInteger") || inType.equals("java.util.concurrent.AtomicLong") || inType.equals("int") || inType.equals("short") || inType.equals("float") || inType.equals("byte") || inType.equals("decimal") || inType.equals("double") || inType.equals("long") || inType.equals("java.math.BigDecimal") || inType.equals("com.adobe.agl.Math") || inType.equals("java.util.BigInteger") || inType.equals("java.lang.Byte") || inType.equals("java.lang.Double") || inType.equals("java.lang.Float") || inType.equals("java.lang.Integer") || inType.equals("java.lang.Long") || inType.equals("java.lang.Short")) {
            return Number.class.getName();
        }
        return inType;
    }

    private static boolean checkDefinedCoercion(String fromType, String toType) {
        List<String> coercibles = CoercionUtil.getKnownCoercions();
        Iterator<String> itr = coercibles.iterator();
        while (itr.hasNext()) {
            String from = itr.next();
            String to = itr.next();
            if (!fromType.equals(from) || !toType.equals(to)) continue;
            return true;
        }
        return false;
    }

    private static synchronized List<String> getKnownCoercions() {
        if (coercibles_ == null) {
            ArrayList<String> c = new ArrayList<String>(15);
            c.add("java.lang.String");
            c.add("java.lang.Number");
            c.add("java.lang.Boolean");
            c.add("java.lang.Number");
            c.add("java.lang.Number");
            c.add("java.lang.Boolean");
            c.add("java.lang.String");
            c.add("java.lang.Boolean");
            c.add("java.lang.String");
            c.add("org.w3c.dom.Document");
            c.add("java.lang.String");
            c.add("org.w3c.dom.Node");
            c.add("org.w3c.dom.Node");
            c.add("org.w3c.dom.Document");
            c.add("java.lang.String");
            c.add("com.adobe.idp.Document");
            c.add(byte[].class.getName());
            c.add("com.adobe.idp.Document");
            c.add(BYTE_ARRAY_ID);
            c.add("com.adobe.idp.Document");
            c.add("org.w3c.dom.Document");
            c.add("com.adobe.idp.Document");
            c.add("com.adobe.idp.Document");
            c.add("org.w3c.dom.Document");
            c.add("org.w3c.dom.Node");
            c.add("com.adobe.idp.Document");
            c.add(byte[].class.getName());
            c.add("java.util.List");
            c.add(BYTE_ARRAY_ID);
            c.add("java.util.List");
            c.add("java.io.InputStream");
            c.add("java.util.List");
            c.add("java.util.ArrayList");
            c.add("java.util.List");
            c.add(byte[].class.getName());
            c.add("java.util.Map");
            c.add(BYTE_ARRAY_ID);
            c.add("java.util.Map");
            c.add("java.util.HashMap");
            c.add("java.util.Map");
            c.add("java.io.InputStream");
            c.add("java.util.Map");
            c.add("java.util.Map");
            c.add("java.util.HashMap");
            c.add("java.util.List");
            c.add("java.util.ArrayList");
            coercibles_ = c;
        }
        return coercibles_;
    }
}

