/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.util;

import com.adobe.idp.DocumentCustomDeserializationStream;
import com.adobe.idp.dsc.util.ClassHelper;
import com.adobe.logging.AdobeLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.util.Map;
import java.util.logging.Level;

public class ClassLoaderAwareObjectInputStream
extends DocumentCustomDeserializationStream {
    protected static final AdobeLogger logger = AdobeLogger.getAdobeLogger(ClassLoaderAwareObjectInputStream.class);
    protected ClassLoader m_classLoader;
    private String[] m_ignoredPackages = new String[]{"java.", "javax.", "sun."};
    private ClassLoader m_systemClassLoader = ClassLoader.getSystemClassLoader();

    public ClassLoaderAwareObjectInputStream(InputStream aIn, ClassLoader aClassLoader) throws IOException {
        super(aIn);
        this.m_classLoader = aClassLoader;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Using ClassLoader: " + (aClassLoader == null ? "" : aClassLoader.getClass().getName()));
        }
    }

    public ClassLoaderAwareObjectInputStream(InputStream aIn, ClassLoader aClassLoader, Map aClassCache) throws IOException {
        super(aIn);
        this.m_classLoader = aClassLoader;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Using ClassLoader: " + (aClassLoader == null ? "" : aClassLoader.getClass().getName()));
        }
    }

    public ClassLoaderAwareObjectInputStream(InputStream aIn) throws IOException {
        super(aIn);
    }

    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        return this.getContainerClass(desc);
    }

    protected void addIgnoredPkgs(String[] aIgnoredPackages) {
        String[] _newIgnoredPackages = new String[aIgnoredPackages.length + this.m_ignoredPackages.length];
        System.arraycopy(this.m_ignoredPackages, 0, _newIgnoredPackages, 0, this.m_ignoredPackages.length);
        System.arraycopy(aIgnoredPackages, 0, _newIgnoredPackages, aIgnoredPackages.length, aIgnoredPackages.length);
        this.m_ignoredPackages = _newIgnoredPackages;
    }

    protected Class getContainerClass(ObjectStreamClass _objectStreamClass) throws IOException, ClassNotFoundException {
        Class<Object> _class = null;
        String _clasName = _objectStreamClass.getName();
        for (int i = 0; i < this.m_ignoredPackages.length; ++i) {
            if (!_objectStreamClass.getName().startsWith(this.m_ignoredPackages[i])) continue;
            try {
                _class = ClassLoader.getSystemClassLoader().loadClass(_clasName);
            }
            catch (ClassNotFoundException e) {}
            break;
        }
        if (_class == null) {
            try {
                _class = this.m_classLoader == null ? ClassHelper.forName(_clasName, ClassLoader.getSystemClassLoader()) : ClassHelper.forName(_clasName, this.m_classLoader);
            }
            catch (Exception e) {
                _class = super.resolveClass(_objectStreamClass);
            }
        }
        return _class;
    }
}

