/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.util;

import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.util.ClassLoaderAwareObjectInputStream;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;

public class ClassHelper {
    public static final Object[] NO_ARGS = new Object[0];
    public static final String ARRAY_SUFFIX = "[]";
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static Class[] PRIMITIVE_CLASSES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static Class[] WRAPPER_CLASSES = new Class[]{Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class};

    public static boolean isConcrete(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        return !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
    }

    public static URL getResource(final String resourceName, final Class callingClass) {
        URL url = null;
        url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader().getResource(resourceName);
            }
        });
        if (url == null) {
            url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ClassHelper.class.getClassLoader().getResource(resourceName);
                }
            });
        }
        if (url == null) {
            url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return callingClass.getClassLoader().getResource(resourceName);
                }
            });
        }
        return url;
    }

    public static Enumeration getResources(final String resourceName, final Class callingClass) {
        Enumeration enumeration = null;
        enumeration = (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Thread.currentThread().getContextClassLoader().getResources(resourceName);
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
        if (enumeration == null) {
            enumeration = (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return ClassHelper.class.getClassLoader().getResources(resourceName);
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
            });
        }
        if (enumeration == null) {
            enumeration = (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return callingClass.getClassLoader().getResources(resourceName);
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
            });
        }
        return enumeration;
    }

    public static InputStream getResourceAsStream(final String resourceName, final Class callingClass) {
        InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL url = ClassHelper.getResource(resourceName, callingClass);
                try {
                    return url != null ? url.openStream() : null;
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
        return inputStream;
    }

    public static Class loadClass(final String className, final Class callingClass) throws ClassNotFoundException {
        Class clazz = null;
        clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Thread.currentThread().getContextClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
        });
        if (clazz == null) {
            clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return Class.forName(className);
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                }
            });
        }
        if (clazz == null) {
            clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return ClassHelper.class.getClassLoader().loadClass(className);
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                }
            });
        }
        if (clazz == null) {
            clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return callingClass.getClassLoader().loadClass(className);
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                }
            });
        }
        if (clazz == null) {
            throw new ClassNotFoundException(className);
        }
        return clazz;
    }

    public static void printClassLoader() {
        System.out.println("ClassLoaderUtils.printClassLoader");
        ClassHelper.printClassLoader(Thread.currentThread().getContextClassLoader());
    }

    public static void printClassLoader(ClassLoader cl) {
        System.out.println("ClassLoaderUtils.printClassLoader(cl = " + cl + ")");
        if (cl != null) {
            ClassHelper.printClassLoader(cl.getParent());
        }
    }

    public static Object instanciateClass(Class clazz, Object[] constructorArgs) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor ctor;
        Class[] args = null;
        if (constructorArgs != null) {
            args = new Class[constructorArgs.length];
            for (int i = 0; i < constructorArgs.length; ++i) {
                args[i] = constructorArgs[i] == null ? null : constructorArgs[i].getClass();
            }
        } else {
            args = new Class[]{};
        }
        if ((ctor = ClassHelper.getConstructor(clazz, args)) == null) {
            String argsString = new String();
            for (int i = 0; i < args.length; ++i) {
                argsString = argsString + args[i].getName() + ", ";
            }
            throw new NoSuchMethodException("could not find constructor with matching arg params: " + argsString);
        }
        return ctor.newInstance(constructorArgs);
    }

    public static Object instanciateClass(String name, Object[] constructorArgs) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class clazz = ClassHelper.loadClass(name, ClassHelper.class);
        return ClassHelper.instanciateClass(clazz, constructorArgs);
    }

    public static Object instanciateClass(String name, Object[] constructorArgs, Class callingClass) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class clazz = ClassHelper.loadClass(name, callingClass);
        return ClassHelper.instanciateClass(clazz, constructorArgs);
    }

    public static Class[] getParameterTypes(Object bean, String methodName) {
        if (!methodName.startsWith("set")) {
            methodName = "set" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        }
        Method[] methods = bean.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            return methods[i].getParameterTypes();
        }
        return new Class[0];
    }

    public static Method getMethod(String name, Class clazz) {
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            return methods[i];
        }
        return null;
    }

    public static Constructor getConstructor(Class clazz, Class[] paramTypes) {
        Constructor<?>[] ctors = clazz.getConstructors();
        for (int i = 0; i < ctors.length; ++i) {
            if (ctors[i].getParameterTypes().length != paramTypes.length) continue;
            Class<?>[] types = ctors[i].getParameterTypes();
            boolean match = true;
            for (int x = 0; x < types.length; ++x) {
                match = paramTypes[x] == null ? true : types[x].isAssignableFrom(paramTypes[x]);
            }
            if (!match) continue;
            return ctors[i];
        }
        return null;
    }

    public static List getSatisfiableMethods(Class implementation, Class[] parameterTypes, boolean voidOk, boolean ignoreEquals) {
        ArrayList<Method> result = new ArrayList<Method>();
        List<Method> methods = Arrays.asList(implementation.getMethods());
        for (Method method : methods) {
            Class[] methodParams = method.getParameterTypes();
            if (!ClassHelper.compare(methodParams, parameterTypes) || (!method.getName().equals("equals") || ignoreEquals) && method.getName().equals("equals") || (!method.getReturnType().getName().equals("void") || !voidOk) && method.getReturnType().getName().equals("void")) continue;
            result.add(method);
        }
        return result;
    }

    public static boolean isClassOnPath(String className, Class currentClass) {
        try {
            return ClassHelper.loadClass(className, currentClass) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Class[] getClassTypes(Object object) {
        Class[] types;
        if (object instanceof Object[]) {
            Object[] objects = (Object[])object;
            types = new Class[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                types[i] = objects[i].getClass();
            }
        } else {
            types = new Class[]{object.getClass()};
        }
        return types;
    }

    public static String getClassName(Class clazz) {
        if (clazz == null) {
            return null;
        }
        String name = clazz.getName();
        return name.substring(name.lastIndexOf(".") + 1);
    }

    public static boolean compare(Class[] c1, Class[] c2) {
        if (c1.length != c2.length) {
            return false;
        }
        for (int i = 0; i < c1.length; ++i) {
            if (c1[i].equals(Object.class) || c1[i].isAssignableFrom(c2[i])) continue;
            return false;
        }
        return true;
    }

    public static String getLoadableClassName(String aClassName) {
        if (aClassName == null || aClassName.indexOf("[") < 0 || aClassName.charAt(0) == '[') {
            return aClassName;
        }
        String className = aClassName.substring(0, aClassName.indexOf("["));
        className = className.equals("byte") ? "B" : (className.equals("char") ? "C" : (className.equals("double") ? "D" : (className.equals("float") ? "F" : (className.equals("int") ? "I" : (className.equals("long") ? "J" : (className.equals("short") ? "S" : (className.equals("boolean") ? "Z" : "L" + className + ";")))))));
        int i = aClassName.indexOf("]");
        while (i > 0) {
            className = "[" + className;
            i = aClassName.indexOf("]", i + 1);
        }
        return className;
    }

    public static Class forName(String name) throws ClassNotFoundException {
        return ClassHelper.forName(name, Thread.currentThread().getContextClassLoader());
    }

    public static Class forName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        Class clazz = ClassHelper.resolvePrimitiveClassName(name);
        if (clazz != null) {
            return clazz;
        }
        if (name.endsWith(ARRAY_SUFFIX)) {
            String elementClassName = name.substring(0, name.length() - ARRAY_SUFFIX.length());
            Class elementClass = ClassHelper.forName(elementClassName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        return Class.forName(name, true, classLoader);
    }

    public static Class resolvePrimitiveClassName(String className) {
        if (className.length() <= 8) {
            for (int i = 0; i < PRIMITIVE_CLASSES.length; ++i) {
                Class clazz = PRIMITIVE_CLASSES[i];
                if (!clazz.getName().equals(className)) continue;
                return clazz;
            }
        }
        return null;
    }

    public static boolean isPrimitive(Class aClass) {
        for (int i = 0; i < PRIMITIVE_CLASSES.length; ++i) {
            Class clazz = PRIMITIVE_CLASSES[i];
            if (clazz != aClass) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitiveOrWrapper(Class aClass) {
        boolean _isPrimitive = ClassHelper.isPrimitive(aClass);
        if (_isPrimitive) {
            return true;
        }
        for (int i = 0; i < WRAPPER_CLASSES.length; ++i) {
            Class clazz = WRAPPER_CLASSES[i];
            if (clazz != aClass) continue;
            return true;
        }
        return false;
    }

    public static Object deserializeOnClassLoader(ClassLoader aClassLoader, Object aValue) {
        try {
            ByteArrayOutputStream _bout = new ByteArrayOutputStream();
            ObjectOutputStream _oout = new ObjectOutputStream(_bout);
            _oout.writeObject(aValue);
            _oout.flush();
            _oout.close();
            byte[] _buff = _bout.toByteArray();
            ByteArrayInputStream _bin = new ByteArrayInputStream(_buff);
            ClassLoaderAwareObjectInputStream _oin = new ClassLoaderAwareObjectInputStream(_bin, aClassLoader);
            Object _val = _oin.readObject();
            _oin.close();
            return _val;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public static PropertyDescriptor getPropertyDescriptor(Class aClass, String aName) {
        Class<?>[] interfaces;
        PropertyDescriptor[] descriptors;
        for (PropertyDescriptor desc : descriptors = PropertyUtils.getPropertyDescriptors((Class)aClass)) {
            if (!desc.getName().equals(aName)) continue;
            return desc;
        }
        if (aClass.isInterface() && (interfaces = aClass.getInterfaces()) != null && interfaces.length > 0) {
            for (Class<?> cls : interfaces) {
                PropertyDescriptor desc = ClassHelper.getPropertyDescriptor(cls, aName);
                if (desc == null) continue;
                return desc;
            }
        }
        return null;
    }
}

