/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.transaction.util;

import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.transaction.TransactionException;
import com.adobe.logging.AdobeLogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public class JTAUtil {
    protected static final Logger logger = AdobeLogger.getAdobeLogger(JTAUtil.class);
    public static final String DEFAULT_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    public static final String[] FALLBACK_TRANSACTION_MANAGER_NAMES = new String[]{"java:comp/TransactionManager", "java:/TransactionManager"};
    protected static final String WEBSPHERE_TX_FACTORY_CLASS_5_1 = "com.ibm.ws.Transaction.TransactionManagerFactory";

    public static TransactionManager findTransactionManager() {
        UserTransaction _ut = JTAUtil.findUserTransaction();
        if (_ut != null && _ut instanceof TransactionManager) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "JTA UserTransaction object [" + _ut + "] implements TransactionManager");
            }
            return (TransactionManager)_ut;
        }
        for (int i = 0; i < FALLBACK_TRANSACTION_MANAGER_NAMES.length; ++i) {
            String jndiName = FALLBACK_TRANSACTION_MANAGER_NAMES[i];
            TransactionManager _tm = (TransactionManager)JTAUtil.lookupObject(jndiName);
            if (_tm == null) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "JTA TransactionManager found at fallback JNDI location [" + jndiName + "]");
            }
            return _tm;
        }
        TransactionManager _tm = JTAUtil.findTransactionManagerForWebSphere();
        return _tm;
    }

    protected static TransactionManager findTransactionManagerForWebSphere() {
        TransactionManager _txMgr = null;
        Class<?> _txFactoryClass = null;
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Looking for WebSphere 5.1+: com.ibm.ws.Transaction.TransactionManagerFactory");
            }
            _txFactoryClass = Class.forName(WEBSPHERE_TX_FACTORY_CLASS_5_1);
            logger.fine("Found WebSphere 5.1+: com.ibm.ws.Transaction.TransactionManagerFactory");
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        try {
            Method method = _txFactoryClass.getMethod("getTransactionManager", null);
            _txMgr = (TransactionManager)method.invoke(null, (Object[])null);
        }
        catch (InvocationTargetException ex) {
            throw new TransactionException(ex.getTargetException(), "WebSphere's TransactionManagerFactory.getTransactionManager method failed");
        }
        catch (Exception ex) {
            throw new TransactionException(ex, "WebSphere's TransactionManagerFactory.getTransactionManager method failed");
        }
        return _txMgr;
    }

    public static UserTransaction findUserTransaction() {
        UserTransaction _ut = (UserTransaction)JTAUtil.lookupObject(DEFAULT_USER_TRANSACTION_NAME);
        return _ut;
    }

    public static Transaction getTransaction() {
        TransactionManager _tm = JTAUtil.findTransactionManager();
        if (_tm == null) {
            return null;
        }
        try {
            return _tm.getTransaction();
        }
        catch (SystemException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    protected static Object lookupObject(String aJndiName) {
        try {
            InitialContext _ic = new InitialContext();
            return _ic.lookup(aJndiName);
        }
        catch (NamingException ex) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Unable to find JTA manager: " + aJndiName);
            }
            return null;
        }
    }
}

