/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.startup;

import com.adobe.idp.dsc.DSCManager;
import com.adobe.idp.dsc.DSContainer;
import com.adobe.idp.dsc.impl.DSCManagerImpl;
import com.adobe.idp.dsc.management.ArchiveStoreException;
import com.adobe.idp.dsc.management.impl.ArchiveFileManagerImpl;
import com.adobe.idp.dsc.transaction.TransactionCallback;
import com.adobe.idp.dsc.transaction.TransactionContext;
import com.adobe.idp.dsc.transaction.TransactionTemplate;
import com.adobe.idp.dsc.util.PerfMonitor;
import com.adobe.logging.AdobeLogger;
import com.adobe.pof.odapi.POFSchemaManager;
import com.adobe.pof.odapi.POFSchemaManagerLocalEJBAdapter;
import com.adobe.pof.odapi.POFSchemaManagerLocalHome;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DSCStartupServlet
extends HttpServlet {
    protected static final Logger log = AdobeLogger.getAdobeLogger(DSCStartupServlet.class);
    public static final String POF_SCHEMA_MANAGER = "java:comp/env/ejb/POFSchemaManagerLocal";
    protected POFSchemaManagerLocalHome pofSchemaManagerLocalHome = null;

    public void init() throws ServletException {
        super.init();
        PerfMonitor.disable();
        DSCManager m = DSCManagerImpl.getInstance();
        try {
            ArchiveFileManagerImpl.getInstance().invalidateArchiveCache();
        }
        catch (ArchiveStoreException e) {
            log.log(Level.WARNING, "Unable to invalidate the Archive Cache", e);
        }
        try {
            TransactionTemplate _txTemplate = DSContainer.getInstance().getTransactionTemplate();
            _txTemplate.setPropagationType(0);
            Boolean isInitialized = (Boolean)_txTemplate.execute(new TransactionCallback(){

                public Object doInTransaction(TransactionContext aCtx) {
                    DSCManager m = DSCManagerImpl.getInstance();
                    Boolean isStarted = Boolean.TRUE;
                    try {
                        if (DSCStartupServlet.this.getPOFSchemaManager().isInstalled()) {
                            if (DSCStartupServlet.this.getPOFSchemaManager().getDomain("dsc") != null) {
                                m.start();
                            } else if (log.isLoggable(Level.INFO)) {
                                log.log(Level.INFO, "Will not attempt to start DSC components since POF is not bootstrapped");
                            }
                        } else if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "Will not attempt to start DSC components since POF is not bootstrapped");
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "DSC Startup failed. Reason: " + e.getMessage());
                        isStarted = Boolean.FALSE;
                    }
                    return isStarted;
                }
            });
            if (!isInitialized.booleanValue() && log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "Unable to start the DSCManager");
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unable to start the DSCManager", e);
        }
    }

    protected POFSchemaManager getPOFSchemaManager() {
        try {
            if (this.pofSchemaManagerLocalHome == null) {
                InitialContext initialContext = new InitialContext();
                this.pofSchemaManagerLocalHome = (POFSchemaManagerLocalHome)initialContext.lookup(POF_SCHEMA_MANAGER);
            }
            POFSchemaManagerLocalEJBAdapter manager = new POFSchemaManagerLocalEJBAdapter(this.pofSchemaManagerLocalHome.create());
            return manager;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "DSCStartupServlet:getPOFObjectManager():Error:" + e.getMessage());
            throw new RuntimeException("DSCStartupServlet:getPOFObjectManager():Error:", e);
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
    }

    public void destroy() {
        try {
            TransactionTemplate _txTemplate = DSContainer.getInstance().getTransactionTemplate();
            _txTemplate.setPropagationType(0);
            _txTemplate.execute(new TransactionCallback(){

                public Object doInTransaction(TransactionContext aCtx) {
                    DSCManager m = DSCManagerImpl.getInstance();
                    m.stop();
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unable to shutdown DSCManager", e);
        }
        super.destroy();
    }
}

