/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.routing;

import com.adobe.idp.dsc.DSCException;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.LongLivedInvocationException;
import com.adobe.idp.dsc.engine.impl.ServiceEngineImpl;
import com.adobe.idp.dsc.impl.DSCManagerImpl;
import com.adobe.idp.dsc.impl.InvocationRequestImpl;
import com.adobe.idp.dsc.impl.InvocationResponseImpl;
import com.adobe.idp.dsc.registry.infomodel.Operation;
import com.adobe.idp.dsc.registry.infomodel.ServiceConfiguration;
import com.adobe.idp.jobmanager.common.JobId;
import com.adobe.logging.AdobeLogger;
import java.util.HashMap;
import java.util.logging.Level;

public class Router {
    static final AdobeLogger log = AdobeLogger.getAdobeLogger(Router.class.getName());

    public InvocationResponse routeRequest(InvocationRequest aRequest) throws DSCException {
        ServiceConfiguration _config;
        InvocationResponse _response = null;
        InvocationRequestImpl _request = (InvocationRequestImpl)aRequest;
        String _endpointId = (String)_request.getProperty("ENDPOINT_PUBLIC_ID");
        StringBuffer _connectorInfo = new StringBuffer();
        if (log.isLoggable(Level.FINE)) {
            String _connectorId = (String)_request.getProperty("CONNECTOR_ID");
            if (_connectorId != null) {
                _connectorInfo = _connectorInfo.append("Request Information. Connector:").append(_connectorId);
            }
            if (_endpointId != null) {
                _connectorInfo.append(" Endpoint:").append(_endpointId);
            }
            _connectorInfo.append(" Service:").append(_request.getServiceName());
            log.fine(_connectorInfo.toString());
        }
        if ((_config = _request.getTargetServiceConfiguration()) == null) {
            _config = ServiceEngineImpl.resolveConfiguration((String)aRequest.getServiceName(), (String)aRequest.getServiceExplicitVersion(), (String)aRequest.getServiceOriginalVersion());
            _request.setTargetServiceConfiguration(_config);
        }
        Operation _operation = _config.getOperation(aRequest.getOperationName());
        Boolean longLivedInvokeExists = (Boolean)aRequest.getProperty("long-lived-invoke");
        if (longLivedInvokeExists == null) {
            longLivedInvokeExists = new Boolean(false);
        }
        if (_operation.getLongLived() && !longLivedInvokeExists.booleanValue()) {
            if (aRequest.isSynchronous()) {
                throw new LongLivedInvocationException(aRequest.getServiceName());
            }
            InvocationRequestImpl _longLivedRequest = new InvocationRequestImpl();
            HashMap<String, Object> _params = new HashMap<String, Object>();
            aRequest.setSynchronous(aRequest.isSynchronous());
            aRequest.setEndPointURI(null);
            _params.put("invocationRequest", aRequest);
            _params.put("persistent", new Boolean(true));
            _longLivedRequest.setServiceName("JobManager");
            _longLivedRequest.setOperationName("createJob");
            _longLivedRequest.setInputParameters(_params);
            _longLivedRequest.setSynchronous(true);
            _longLivedRequest.setEndPointURI(aRequest.getEndPointURI());
            _longLivedRequest.setProperty("DSC_CONTEXT", aRequest.getInvocationContext());
            _longLivedRequest.setProperty("DSC_CREDENTIAL", aRequest.getProperty("DSC_CREDENTIAL"));
            _response = DSCManagerImpl.getInstance().getDSContainer().getServiceEngine().invoke((InvocationRequest)_longLivedRequest);
            JobId jobId = (JobId)_response.getOutputParameter("jobId");
            ((InvocationResponseImpl)_response).setJobId(jobId.toString());
            log.fine("Asynchronous jobId:" + jobId);
        } else if (this.isSynchronousRequest(aRequest)) {
            _response = DSCManagerImpl.getInstance().getDSContainer().getServiceEngine().invoke(aRequest);
        } else {
            InvocationRequestImpl _jmRequest = new InvocationRequestImpl();
            HashMap<String, Object> _params = new HashMap<String, Object>();
            aRequest.setProperty("DSC_SYNCHRONOUS_REQUEST", new Boolean(true));
            aRequest.setEndPointURI(null);
            _params.put("invocationRequest", aRequest);
            _params.put("persistent", new Boolean(true));
            _jmRequest.setServiceName("JobManager");
            _jmRequest.setOperationName("createJob");
            _jmRequest.setInputParameters(_params);
            _jmRequest.setSynchronous(true);
            _jmRequest.setEndPointURI(aRequest.getEndPointURI());
            _jmRequest.setProperty("DSC_CONTEXT", aRequest.getInvocationContext());
            _jmRequest.setProperty("DSC_CREDENTIAL", aRequest.getProperty("DSC_CREDENTIAL"));
            _response = DSCManagerImpl.getInstance().getDSContainer().getServiceEngine().invoke((InvocationRequest)_jmRequest);
            JobId jobId = (JobId)_response.getOutputParameter("jobId");
            ((InvocationResponseImpl)_response).setJobId(jobId.toString());
            log.fine("Asynchronous jobId:" + jobId);
        }
        return _response;
    }

    private boolean isSynchronousRequest(InvocationRequest aRequest) {
        Boolean _internalSyncFlag = (Boolean)aRequest.getProperty("DSC_SYNCHRONOUS_REQUEST");
        return _internalSyncFlag != null ? _internalSyncFlag.booleanValue() : aRequest.isSynchronous();
    }
}

