/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.registry.service.client;

import com.adobe.idp.dsc.DSCException;
import com.adobe.idp.dsc.DSCInvocationException;
import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.dsc.filter.FilterResult;
import com.adobe.idp.dsc.filter.PagingFilter;
import com.adobe.idp.dsc.registry.RegistryException;
import com.adobe.idp.dsc.registry.infomodel.Component;
import com.adobe.idp.dsc.registry.infomodel.Service;
import com.adobe.idp.dsc.registry.infomodel.ServiceCategory;
import com.adobe.idp.dsc.registry.infomodel.ServiceConfiguration;
import com.adobe.idp.dsc.registry.service.CreateServiceCategoryInfo;
import com.adobe.idp.dsc.registry.service.CreateServiceConfigurationInfo;
import com.adobe.idp.dsc.registry.service.CreateServiceInfo;
import com.adobe.idp.dsc.registry.service.ModifyServiceCategoryInfo;
import com.adobe.idp.dsc.registry.service.ModifyServiceConfigurationInfo;
import com.adobe.idp.dsc.registry.service.ModifyServiceInfo;
import com.adobe.idp.dsc.registry.service.ServiceRegistry;
import com.adobe.idp.dsc.util.HashMapClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceRegistryClient
implements ServiceRegistry {
    private ServiceClientFactory m_serviceClientFactory;
    private HashMap m_classLoaderCache;
    private boolean m_verifyCache;

    public ServiceRegistryClient(ServiceClientFactory clientServiceFactory) {
        this(clientServiceFactory, true);
    }

    public ServiceRegistryClient(ServiceClientFactory clientServiceFactory, boolean verifyCache) {
        this.m_serviceClientFactory = clientServiceFactory;
        this.m_verifyCache = verifyCache;
    }

    public Service createService(CreateServiceInfo aInfo) throws RegistryException {
        try {
            HashMap<String, CreateServiceInfo> input = new HashMap<String, CreateServiceInfo>(1);
            input.put("service-info", aInfo);
            InvocationResponse response = this.invoke("createService", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof Service)) continue;
                return (Service)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public Service getService(String aServiceId) throws RegistryException {
        try {
            HashMap<String, String> input = new HashMap<String, String>(1);
            input.put("service-id", aServiceId);
            InvocationResponse response = this.invoke("getService", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof Service)) continue;
                return (Service)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public List getServices(ServiceCategory aCategory) {
        try {
            HashMap<String, ServiceCategory> input = new HashMap<String, ServiceCategory>(1);
            input.put("category", aCategory);
            InvocationResponse response = this.invoke("getServicesForCategory", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof List)) continue;
                return (List)returnValue[i];
            }
            return null;
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public List getServices() {
        try {
            InvocationResponse response = this.invoke("getServices", null);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof List)) continue;
                return (List)returnValue[i];
            }
            return null;
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public Service modifyService(ModifyServiceInfo aService) throws RegistryException {
        try {
            HashMap<String, ModifyServiceInfo> input = new HashMap<String, ModifyServiceInfo>(1);
            input.put("service-info", aService);
            InvocationResponse response = this.invoke("modifyService", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof Service)) continue;
                return (Service)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public void removeService(Service aService) throws RegistryException {
        try {
            HashMap<String, Service> input = new HashMap<String, Service>(1);
            input.put("service", aService);
            this.invoke("removeService", input);
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public ServiceConfiguration createConfiguration(CreateServiceConfigurationInfo aInfo) throws RegistryException {
        try {
            HashMap<String, CreateServiceConfigurationInfo> input = new HashMap<String, CreateServiceConfigurationInfo>(1);
            input.put("service-config-info", aInfo);
            InvocationResponse response = this.invoke("createConfiguration", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof ServiceConfiguration)) continue;
                return (ServiceConfiguration)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public void removeConfiguration(ServiceConfiguration aConfig) throws RegistryException {
        try {
            HashMap<String, ServiceConfiguration> input = new HashMap<String, ServiceConfiguration>(1);
            input.put("service-config", aConfig);
            this.invoke("removeConfiguration", input);
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public void forceRemovalOfConfiguration(ServiceConfiguration aConfig) throws RegistryException {
        try {
            HashMap<String, ServiceConfiguration> input = new HashMap<String, ServiceConfiguration>(1);
            input.put("service-config", aConfig);
            this.invoke("forceRemovalOfConfiguration", input);
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public ServiceCategory createCategory(CreateServiceCategoryInfo aCat) throws RegistryException {
        try {
            HashMap<String, CreateServiceCategoryInfo> input = new HashMap<String, CreateServiceCategoryInfo>(1);
            input.put("category-info", aCat);
            InvocationResponse response = this.invoke("createCategory", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof ServiceCategory)) continue;
                return (ServiceCategory)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public ServiceCategory getServiceCategory(String aId) throws RegistryException {
        try {
            HashMap<String, String> input = new HashMap<String, String>(1);
            input.put("category-id", aId);
            InvocationResponse response = this.invoke("getServiceCategory", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof ServiceCategory)) continue;
                return (ServiceCategory)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public ServiceCategory modifyCategory(ModifyServiceCategoryInfo aInfo) throws RegistryException {
        try {
            HashMap<String, ModifyServiceCategoryInfo> input = new HashMap<String, ModifyServiceCategoryInfo>(1);
            input.put("category-info", aInfo);
            InvocationResponse response = this.invoke("modifyCategory", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof ServiceCategory)) continue;
                return (ServiceCategory)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public void removeCategory(ServiceCategory aCat) throws RegistryException {
        try {
            HashMap<String, ServiceCategory> input = new HashMap<String, ServiceCategory>(1);
            input.put("category", aCat);
            this.invoke("removeCategory", input);
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public List getServiceCategories() {
        try {
            InvocationResponse response = this.invoke("getServiceCategories", null);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof List)) continue;
                return (List)returnValue[i];
            }
            return null;
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public List getServiceConfigurations() {
        try {
            InvocationResponse response = this.invoke("getServiceConfigurations", null);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof List)) continue;
                return (List)returnValue[i];
            }
            return null;
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public List getServiceConfigurationsForSpecificationId(String aSpecificationId) {
        try {
            HashMap<String, String> input = new HashMap<String, String>(1);
            input.put("specification-id", aSpecificationId);
            InvocationResponse response = this.invoke("getServiceConfigurationsForSpecificationId", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof List)) continue;
                return (List)returnValue[i];
            }
            return null;
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public FilterResult getServiceConfigurations(PagingFilter aFilter) {
        try {
            HashMap<String, PagingFilter> input = new HashMap<String, PagingFilter>(1);
            input.put("filter", aFilter);
            InvocationResponse response = this.invoke("getServiceConfigurationsWithPagingFilter", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof FilterResult)) continue;
                return (FilterResult)returnValue[i];
            }
            return null;
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public FilterResult getServiceCategories(PagingFilter aFilter) {
        try {
            HashMap<String, PagingFilter> input = new HashMap<String, PagingFilter>(1);
            input.put("filter", aFilter);
            InvocationResponse response = this.invoke("getServiceCategoriesWithPagingFilter", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof FilterResult)) continue;
                return (FilterResult)returnValue[i];
            }
            return null;
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public List getServiceConfigurations(Component aComponent) {
        try {
            HashMap<String, Component> input = new HashMap<String, Component>(1);
            input.put("component", aComponent);
            InvocationResponse response = this.invoke("getServiceConfigurationsForComponent", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof List)) continue;
                return (List)returnValue[i];
            }
            return null;
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public List getServiceConfigurations(Service aService) {
        try {
            HashMap<String, Service> input = new HashMap<String, Service>(1);
            input.put("service", aService);
            InvocationResponse response = this.invoke("getServiceConfigurationsForService", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof List)) continue;
                return (List)returnValue[i];
            }
            return null;
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public ServiceConfiguration getHeadServiceConfiguration(String aServiceId) throws RegistryException {
        try {
            HashMap<String, String> input = new HashMap<String, String>(1);
            input.put("service-id", aServiceId);
            InvocationResponse response = this.invoke("getHeadActiveConfiguration", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof ServiceConfiguration)) continue;
                return (ServiceConfiguration)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public ServiceConfiguration getHeadActiveConfiguration(String aServiceId) throws RegistryException {
        try {
            HashMap<String, String> input = new HashMap<String, String>(1);
            input.put("service-id", aServiceId);
            InvocationResponse response = this.invoke("getHeadActiveConfiguration", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof ServiceConfiguration)) continue;
                return (ServiceConfiguration)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public ServiceConfiguration getCompatibleServiceConfiguration(String aServiceId, int aMajorVersion, int aMinorVersion) throws RegistryException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>(3);
            input.put("service-id", aServiceId);
            input.put("major-version", new Integer(aMajorVersion));
            input.put("minor-version", new Integer(aMinorVersion));
            InvocationResponse response = this.invoke("getCompatibleServiceConfiguration", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof ServiceConfiguration)) continue;
                return (ServiceConfiguration)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public ServiceConfiguration getServiceConfiguration(String aServiceId, int aMajorVersion, int aMinorVersion) throws RegistryException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>(3);
            input.put("service-id", aServiceId);
            input.put("major-version", new Integer(aMajorVersion));
            input.put("minor-version", new Integer(aMinorVersion));
            InvocationResponse response = this.invoke("getServiceConfiguration", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof ServiceConfiguration)) continue;
                return (ServiceConfiguration)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public ServiceConfiguration start(ServiceConfiguration aService) throws RegistryException {
        try {
            HashMap<String, ServiceConfiguration> input = new HashMap<String, ServiceConfiguration>(1);
            input.put("service-config", aService);
            InvocationResponse response = this.invoke("start", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof ServiceConfiguration)) continue;
                return (ServiceConfiguration)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public ServiceConfiguration stop(ServiceConfiguration aService) throws RegistryException {
        try {
            HashMap<String, ServiceConfiguration> input = new HashMap<String, ServiceConfiguration>(1);
            input.put("service-config", aService);
            InvocationResponse response = this.invoke("stop", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof ServiceConfiguration)) continue;
                return (ServiceConfiguration)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public ServiceConfiguration createAndDeploy(Component aComponent, String aServiceId, int aMajorVersion, int aMinorVersion, String aDescriptor, Map aConfigParameters) throws RegistryException {
        return this.createAndDeploy(aComponent, null, aServiceId, aMajorVersion, aMinorVersion, null, aDescriptor, aConfigParameters);
    }

    public ServiceConfiguration createAndDeploy(Component aComponent, String aCategoryId, String aServiceId, int aMajorVersion, int aMinorVersion, String aType, String aDescriptor, Map aConfigParamsAsStrings) throws RegistryException {
        CreateServiceConfigurationInfo _scInfo = new CreateServiceConfigurationInfo();
        _scInfo.setComponentId(aComponent.getComponentId());
        _scInfo.setComponentVersion(aComponent.getVersion());
        _scInfo.setServiceId(aServiceId);
        _scInfo.setMajorVersion(aMajorVersion);
        _scInfo.setMinorVersion(aMinorVersion);
        _scInfo.setDescriptor(aDescriptor);
        _scInfo.setCategoryId(aCategoryId);
        _scInfo.setType(aType);
        return this.createAndDeploy(_scInfo, aConfigParamsAsStrings);
    }

    public ServiceConfiguration createAndDeploy(CreateServiceConfigurationInfo aInfo, Map aConfigParamsAsStrings) throws RegistryException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>(2);
            input.put("service-config-info", aInfo);
            input.put("config-params", aConfigParamsAsStrings);
            InvocationResponse response = this.invoke("createAndDeploy", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof ServiceConfiguration)) continue;
                return (ServiceConfiguration)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public ServiceConfiguration createAndDeploy(CreateServiceConfigurationInfo aInfo, Map aConfigValuesAsStrings, boolean aOverrideEndpointCreation) throws RegistryException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>(3);
            input.put("service-config-info", aInfo);
            input.put("config-params", aConfigValuesAsStrings);
            input.put("override-endpoint-creation", aOverrideEndpointCreation);
            InvocationResponse response = this.invoke("createAndDeploy", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof ServiceConfiguration)) continue;
                return (ServiceConfiguration)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public ServiceConfiguration deploy(ServiceConfiguration aConfig) throws RegistryException {
        try {
            HashMap<String, ServiceConfiguration> input = new HashMap<String, ServiceConfiguration>(1);
            input.put("service-config", aConfig);
            InvocationResponse response = this.invoke("deploy", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof ServiceConfiguration)) continue;
                return (ServiceConfiguration)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public ServiceConfiguration modifyConfiguration(ModifyServiceConfigurationInfo aInfo) throws RegistryException {
        try {
            HashMap<String, ModifyServiceConfigurationInfo> input = new HashMap<String, ModifyServiceConfigurationInfo>(1);
            input.put("service-config-info", aInfo);
            InvocationResponse response = this.invoke("modifyConfiguration", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof ServiceConfiguration)) continue;
                return (ServiceConfiguration)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public ServiceConfiguration undeploy(ServiceConfiguration aServiceConfig) throws RegistryException {
        try {
            HashMap<String, ServiceConfiguration> input = new HashMap<String, ServiceConfiguration>(1);
            input.put("service-config", aServiceConfig);
            InvocationResponse response = this.invoke("undeploy", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof ServiceConfiguration)) continue;
                return (ServiceConfiguration)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public ServiceConfiguration forceUndeploy(ServiceConfiguration aServiceConfig) throws RegistryException {
        try {
            HashMap<String, ServiceConfiguration> input = new HashMap<String, ServiceConfiguration>(1);
            input.put("service-config", aServiceConfig);
            InvocationResponse response = this.invoke("forceUndeploy", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof ServiceConfiguration)) continue;
                return (ServiceConfiguration)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public void clearCache() {
        try {
            this.invoke("clearCache", null);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public Map getClientLibAsMap(String aServiceId, int aMajorVersion, int aMinorVersion) throws RegistryException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>(1);
            input.put("service-id", aServiceId);
            input.put("major-version", new Integer(aMajorVersion));
            input.put("minor-version", new Integer(aMinorVersion));
            InvocationResponse response = this.invoke("getClientLibAsMap", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof Map)) continue;
                return (Map)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public ClassLoader getClientClassLoader(ClassLoader aParent, ServiceConfiguration aConfig) throws RegistryException {
        ServiceConfiguration _sc;
        StringBuffer _key = new StringBuffer(aConfig.getServiceId());
        _key.append('.');
        _key.append(Integer.toString(aConfig.getMajorVersion()));
        _key.append('.');
        _key.append(Integer.toString(aConfig.getMinorVersion()));
        _key.append('.');
        _key.append(System.identityHashCode(aParent));
        HashMapClassLoader _cl = null;
        if (this.m_classLoaderCache == null) {
            this.m_classLoaderCache = new HashMap();
        } else {
            _cl = (HashMapClassLoader)this.m_classLoaderCache.get(_key.toString());
        }
        if (_cl != null && this.m_verifyCache && (_sc = this.getServiceConfiguration(aConfig.getServiceId(), aConfig.getMajorVersion(), aConfig.getMinorVersion())).getUpdateTime().getTime() > _cl.getCreateTime().getTime()) {
            _cl = null;
        }
        if (_cl == null) {
            Map _map = this.getClientLibAsMap(aConfig.getServiceId(), aConfig.getMajorVersion(), aConfig.getMinorVersion());
            _cl = new HashMapClassLoader(_map, aParent);
            this.m_classLoaderCache.put(_key.toString(), _cl);
        }
        return _cl;
    }

    public ServiceConfiguration lock(ServiceConfiguration aConfig) throws RegistryException {
        try {
            HashMap<String, ServiceConfiguration> input = new HashMap<String, ServiceConfiguration>(1);
            input.put("service-config", aConfig);
            InvocationResponse response = this.invoke("lock", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof ServiceConfiguration)) continue;
                return (ServiceConfiguration)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public ServiceConfiguration unlock(ServiceConfiguration aConfig) throws RegistryException {
        try {
            HashMap<String, ServiceConfiguration> input = new HashMap<String, ServiceConfiguration>(1);
            input.put("service-config", aConfig);
            InvocationResponse response = this.invoke("unlock", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof ServiceConfiguration)) continue;
                return (ServiceConfiguration)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    private InvocationResponse invoke(String operationName, HashMap input) throws DSCException {
        InvocationRequest request = this.m_serviceClientFactory.createInvocationRequest("system.service_registry", operationName, input, true);
        return this.m_serviceClientFactory.getServiceClient().invoke(request);
    }
}

