/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.registry.service;

import com.adobe.idp.dsc.filter.FilterResult;
import com.adobe.idp.dsc.filter.PagingFilter;
import com.adobe.idp.dsc.registry.RegistryException;
import com.adobe.idp.dsc.registry.infomodel.Component;
import com.adobe.idp.dsc.registry.infomodel.Service;
import com.adobe.idp.dsc.registry.infomodel.ServiceCategory;
import com.adobe.idp.dsc.registry.infomodel.ServiceConfiguration;
import com.adobe.idp.dsc.registry.service.CreateServiceCategoryInfo;
import com.adobe.idp.dsc.registry.service.CreateServiceConfigurationInfo;
import com.adobe.idp.dsc.registry.service.CreateServiceInfo;
import com.adobe.idp.dsc.registry.service.ModifyServiceCategoryInfo;
import com.adobe.idp.dsc.registry.service.ModifyServiceConfigurationInfo;
import com.adobe.idp.dsc.registry.service.ModifyServiceInfo;
import java.util.List;
import java.util.Map;

public interface ServiceRegistry {
    public static final String SERVICE_ID = "system.service_registry";
    public static final String DEFAULT_CATEGORY_ID = "Default";

    public Service createService(CreateServiceInfo var1) throws RegistryException;

    public Service getService(String var1) throws RegistryException;

    public Service modifyService(ModifyServiceInfo var1) throws RegistryException;

    public void removeService(Service var1) throws RegistryException;

    public List getServices(ServiceCategory var1);

    public List getServices();

    public ServiceCategory createCategory(CreateServiceCategoryInfo var1) throws RegistryException;

    public ServiceCategory modifyCategory(ModifyServiceCategoryInfo var1) throws RegistryException;

    public void removeCategory(ServiceCategory var1) throws RegistryException;

    public ServiceCategory getServiceCategory(String var1) throws RegistryException;

    public List getServiceCategories();

    public List getServiceCategories(PagingFilter var1);

    public ServiceConfiguration createConfiguration(CreateServiceConfigurationInfo var1) throws RegistryException;

    public void removeConfiguration(ServiceConfiguration var1) throws RegistryException;

    public void forceRemovalOfConfiguration(ServiceConfiguration var1) throws RegistryException;

    public List getServiceConfigurations();

    public FilterResult getServiceConfigurations(PagingFilter var1);

    public List getServiceConfigurations(Component var1);

    public List getServiceConfigurations(Service var1);

    public List getServiceConfigurationsForSpecificationId(String var1);

    public ServiceConfiguration getHeadServiceConfiguration(String var1) throws RegistryException;

    public ServiceConfiguration getHeadActiveConfiguration(String var1) throws RegistryException;

    public ServiceConfiguration getCompatibleServiceConfiguration(String var1, int var2, int var3) throws RegistryException;

    public ServiceConfiguration getServiceConfiguration(String var1, int var2, int var3) throws RegistryException;

    public ServiceConfiguration start(ServiceConfiguration var1) throws RegistryException;

    public ServiceConfiguration stop(ServiceConfiguration var1) throws RegistryException;

    public ServiceConfiguration createAndDeploy(Component var1, String var2, int var3, int var4, String var5, Map var6) throws RegistryException;

    public ServiceConfiguration createAndDeploy(Component var1, String var2, String var3, int var4, int var5, String var6, String var7, Map var8) throws RegistryException;

    public ServiceConfiguration createAndDeploy(CreateServiceConfigurationInfo var1, Map var2) throws RegistryException;

    public ServiceConfiguration createAndDeploy(CreateServiceConfigurationInfo var1, Map var2, boolean var3) throws RegistryException;

    public ServiceConfiguration modifyConfiguration(ModifyServiceConfigurationInfo var1) throws RegistryException;

    public ServiceConfiguration undeploy(ServiceConfiguration var1) throws RegistryException;

    public ServiceConfiguration forceUndeploy(ServiceConfiguration var1) throws RegistryException;

    public void clearCache();

    public Map getClientLibAsMap(String var1, int var2, int var3) throws RegistryException;

    public ServiceConfiguration lock(ServiceConfiguration var1) throws RegistryException;

    public ServiceConfiguration unlock(ServiceConfiguration var1) throws RegistryException;

    public ServiceConfiguration deploy(ServiceConfiguration var1) throws RegistryException;
}

