/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.registry.service;

import com.adobe.idp.dsc.registry.service.ServicePoolConfigurationException;
import com.adobe.idp.dsc.util.DOMUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ServicePoolConfigurationInfo
implements Serializable {
    private static final String EMPTY_CONTENT = "";
    private static final long serialVersionUID = 3386919981508696466L;
    private int m_initialInstances;
    private int m_maxAsynchronousInstances;
    private int m_maxInstances;
    private long m_maxWait;
    private String m_serviceId;
    private int m_minorVersion;
    private int m_majorVersion;
    private static final String MAX_ASYNCH_INSTANCES_ELEMENT_NAME = "max-asynch-instances";
    private static final String MAX_WAIT_ELEMENT_NAME = "max-wait";
    private static final String MAX_INSTANCES_ELEMENT_NAME = "max-instances";
    private static final String POOL_ELEMENT_NAME = "pool";
    private static final String INITIAL_INSTANCES_ELEMENT_NAME = "initial-instances";
    private static final String SERVICE_ELEMENT_NAME = "service";
    public static final int DEFAULT_INITIAL_INSTANCES = 0;
    public static final int DEFAULT_MAX_INSTANCES = 0;
    public static final int DEFAULT_MAX_ASYCHRONOUS_INSTANCES = 0;
    public static final long DEFAULT_WAIT_TIME = 0L;

    public int getInitialInstances() {
        return this.m_initialInstances;
    }

    public void setInitialInstances(int instances) {
        this.m_initialInstances = instances;
    }

    public int getMaxAsynchronousInstances() {
        return this.m_maxAsynchronousInstances;
    }

    public void setMaxAsynchronousInstances(int asynchronousInstances) {
        this.m_maxAsynchronousInstances = asynchronousInstances;
    }

    public int getMaxInstances() {
        return this.m_maxInstances;
    }

    public void setMaxInstances(int instances) {
        this.m_maxInstances = instances;
    }

    public long getMaxWait() {
        return this.m_maxWait;
    }

    public void setMaxWait(long wait) {
        this.m_maxWait = wait;
    }

    protected static ServicePoolConfigurationInfo createDefaultServicePoolConfiguration() {
        ServicePoolConfigurationInfo _config = new ServicePoolConfigurationInfo();
        _config.setInitialInstances(0);
        _config.setMaxInstances(0);
        _config.setMaxAsynchronousInstances(0);
        _config.setMaxWait(0L);
        return _config;
    }

    protected static ServicePoolConfigurationInfo createServicePoolConfiguration(String descriptor) throws ServicePoolConfigurationException {
        ServicePoolConfigurationInfo _config = null;
        SAXParserFactory _saxParserFactory = SAXParserFactory.newInstance();
        _saxParserFactory.setNamespaceAware(false);
        _saxParserFactory.setValidating(false);
        SAXParser _parser = null;
        try {
            _parser = _saxParserFactory.newSAXParser();
            ServicePoolConfigurationInfoHandler _infoHandler = new ServicePoolConfigurationInfoHandler();
            _parser.parse((InputStream)new ByteArrayInputStream(descriptor.getBytes("UTF-8")), (DefaultHandler)_infoHandler);
            _config = _infoHandler.getServicePoolConfigurationInfo();
        }
        catch (SAXException e) {
            throw new ServicePoolConfigurationException(e);
        }
        catch (IOException e) {
            throw new ServicePoolConfigurationException(e);
        }
        catch (ParserConfigurationException e) {
            throw new ServicePoolConfigurationException(e);
        }
        return _config;
    }

    protected static String updateServiceConfiguration(String descriptor, ServicePoolConfigurationInfo servicePoolConfigInfo) throws ServicePoolConfigurationException {
        String _updatedDescriptor = null;
        Document _descriptorAsDOM = null;
        Element serviceElement = null;
        try {
            Element _initialInstances;
            Element _pool;
            if (descriptor != null) {
                _descriptorAsDOM = DOMUtil.parseDocumentFromStream(new ByteArrayInputStream(descriptor.getBytes("UTF-8")));
            } else {
                _descriptorAsDOM = DOMUtil.newDocument();
                serviceElement = _descriptorAsDOM.createElement(SERVICE_ELEMENT_NAME);
                _descriptorAsDOM.appendChild(serviceElement);
            }
            if (serviceElement == null) {
                serviceElement = _descriptorAsDOM.getDocumentElement();
            }
            if ((_pool = DOMUtil.getChildElement(serviceElement, POOL_ELEMENT_NAME)) == null) {
                _pool = DOMUtil.createElement(serviceElement, POOL_ELEMENT_NAME);
            }
            if ((_initialInstances = DOMUtil.getChildElement(_pool, INITIAL_INSTANCES_ELEMENT_NAME)) == null) {
                _initialInstances = DOMUtil.createElement(_pool, INITIAL_INSTANCES_ELEMENT_NAME);
            }
            DOMUtil.setNodeText(_initialInstances, Integer.toString(servicePoolConfigInfo.getInitialInstances()));
            Element _maxInstances = DOMUtil.getChildElement(_pool, MAX_INSTANCES_ELEMENT_NAME);
            if (_maxInstances == null) {
                _maxInstances = DOMUtil.createElement(_pool, MAX_INSTANCES_ELEMENT_NAME);
            }
            DOMUtil.setNodeText(_maxInstances, Integer.toString(servicePoolConfigInfo.getMaxInstances()));
            Element _maxWait = DOMUtil.getChildElement(_pool, MAX_WAIT_ELEMENT_NAME);
            if (_maxWait == null) {
                _maxWait = DOMUtil.createElement(_pool, MAX_WAIT_ELEMENT_NAME);
            }
            DOMUtil.setNodeText(_maxWait, Long.toString(servicePoolConfigInfo.getMaxWait()));
            Element _maxAsynchInstances = DOMUtil.getChildElement(_pool, MAX_ASYNCH_INSTANCES_ELEMENT_NAME);
            int _asynchInstances = servicePoolConfigInfo.getMaxAsynchronousInstances();
            if (_maxAsynchInstances == null) {
                _maxAsynchInstances = DOMUtil.createElement(_pool, MAX_ASYNCH_INSTANCES_ELEMENT_NAME);
            }
            DOMUtil.setNodeText(_maxAsynchInstances, Integer.toString(_asynchInstances));
            _updatedDescriptor = DOMUtil.toString(_descriptorAsDOM);
        }
        catch (ParserConfigurationException e) {
            throw new ServicePoolConfigurationException(e);
        }
        catch (SAXException e) {
            throw new ServicePoolConfigurationException(e);
        }
        catch (IOException e) {
            throw new ServicePoolConfigurationException(e);
        }
        return _updatedDescriptor;
    }

    public String getServiceId() {
        return this.m_serviceId;
    }

    public void setServiceId(String serviceId) {
        this.m_serviceId = serviceId;
    }

    public int getMajorVersion() {
        return this.m_majorVersion;
    }

    public void setMajorVersion(int version) {
        this.m_majorVersion = version;
    }

    public int getMinorVersion() {
        return this.m_minorVersion;
    }

    public void setMinorVersion(int version) {
        this.m_minorVersion = version;
    }

    private static class ServicePoolConfigurationInfoHandler
    extends DefaultHandler {
        private String currentNode = null;
        private ServicePoolConfigurationInfo _servicePoolConfiguration = null;

        public ServicePoolConfigurationInfo getServicePoolConfigurationInfo() {
            return this._servicePoolConfiguration;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (localName.equals(ServicePoolConfigurationInfo.POOL_ELEMENT_NAME)) {
                this.currentNode = ServicePoolConfigurationInfo.POOL_ELEMENT_NAME;
                this._servicePoolConfiguration = new ServicePoolConfigurationInfo();
            } else if (localName.equals(ServicePoolConfigurationInfo.INITIAL_INSTANCES_ELEMENT_NAME)) {
                this.currentNode = ServicePoolConfigurationInfo.INITIAL_INSTANCES_ELEMENT_NAME;
            } else if (localName.equals(ServicePoolConfigurationInfo.MAX_INSTANCES_ELEMENT_NAME)) {
                this.currentNode = ServicePoolConfigurationInfo.MAX_INSTANCES_ELEMENT_NAME;
            } else if (localName.equals(ServicePoolConfigurationInfo.MAX_WAIT_ELEMENT_NAME)) {
                this.currentNode = ServicePoolConfigurationInfo.MAX_WAIT_ELEMENT_NAME;
            } else if (localName.equals(ServicePoolConfigurationInfo.MAX_ASYNCH_INSTANCES_ELEMENT_NAME)) {
                this.currentNode = ServicePoolConfigurationInfo.MAX_ASYNCH_INSTANCES_ELEMENT_NAME;
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (this.currentNode != null && this.currentNode.equals(ServicePoolConfigurationInfo.INITIAL_INSTANCES_ELEMENT_NAME)) {
                String _initialInstances = new String(ch, start, length).trim();
                if (_initialInstances != null && _initialInstances.length() > 0) {
                    this._servicePoolConfiguration.setInitialInstances(Integer.parseInt(_initialInstances));
                    if (this._servicePoolConfiguration.getInitialInstances() < 0) {
                        this._servicePoolConfiguration.setInitialInstances(0);
                    }
                } else {
                    this._servicePoolConfiguration.setInitialInstances(0);
                }
            } else if (this.currentNode != null && this.currentNode.equals(ServicePoolConfigurationInfo.MAX_INSTANCES_ELEMENT_NAME)) {
                String _maxInstances = new String(ch, start, length).trim();
                if (_maxInstances != null && _maxInstances.length() > 0) {
                    this._servicePoolConfiguration.setMaxInstances(Integer.parseInt(_maxInstances));
                    if (this._servicePoolConfiguration.getMaxInstances() < 0) {
                        this._servicePoolConfiguration.setMaxInstances(0);
                    }
                } else {
                    this._servicePoolConfiguration.setMaxInstances(0);
                }
            } else if (this.currentNode != null && this.currentNode.equals(ServicePoolConfigurationInfo.MAX_WAIT_ELEMENT_NAME)) {
                String _maxWait = new String(ch, start, length).trim();
                if (_maxWait != null && _maxWait.length() > 0) {
                    this._servicePoolConfiguration.setMaxWait(Long.parseLong(_maxWait));
                    if (this._servicePoolConfiguration.getMaxWait() < 0L) {
                        this._servicePoolConfiguration.setMaxWait(0L);
                    }
                } else {
                    this._servicePoolConfiguration.setMaxWait(0L);
                }
            } else if (this.currentNode != null && this.currentNode.equals(ServicePoolConfigurationInfo.MAX_ASYNCH_INSTANCES_ELEMENT_NAME)) {
                String _maxAsynchInstances = new String(ch, start, length).trim();
                if (_maxAsynchInstances != null && _maxAsynchInstances.length() > 0) {
                    this._servicePoolConfiguration.setMaxAsynchronousInstances(Integer.parseInt(_maxAsynchInstances));
                    if (this._servicePoolConfiguration.getMaxAsynchronousInstances() < 0) {
                        this._servicePoolConfiguration.setMaxAsynchronousInstances(0);
                    }
                } else if (0 > this._servicePoolConfiguration.getMaxInstances()) {
                    this._servicePoolConfiguration.setMaxAsynchronousInstances(this._servicePoolConfiguration.getMaxInstances());
                } else {
                    this._servicePoolConfiguration.setMaxAsynchronousInstances(0);
                }
            }
            this.currentNode = ServicePoolConfigurationInfo.EMPTY_CONTENT;
        }
    }
}

