/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.registry.security.impl;

import com.adobe.edc.server.spi.storage.pof.BOIPermissionEntity;
import com.adobe.edc.server.spi.storage.pof.BOIPrincipalResourcePermEntity;
import com.adobe.idp.Context;
import com.adobe.idp.dsc.DSCAuthorizationException;
import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.DSContainer;
import com.adobe.idp.dsc.InvocationContext;
import com.adobe.idp.dsc.registry.PermissionGrantNotFoundException;
import com.adobe.idp.dsc.registry.connector.impl.ConnectorRegistryImpl;
import com.adobe.idp.dsc.registry.impl.StoreUtils;
import com.adobe.idp.dsc.registry.infomodel.PermissionGrant;
import com.adobe.idp.dsc.registry.infomodel.Service;
import com.adobe.idp.dsc.registry.infomodel.impl.PermissionGrantImpl;
import com.adobe.idp.dsc.registry.security.SecurityProfileManager;
import com.adobe.idp.dsc.util.DSCUMConstants;
import com.adobe.idp.dsc.util.TextUtil;
import com.adobe.idp.um.api.AuthorizationManager;
import com.adobe.idp.um.api.DirectoryManager;
import com.adobe.idp.um.api.UMFactory;
import com.adobe.idp.um.api.UMLocalUtils;
import com.adobe.idp.um.api.infomodel.Permission;
import com.adobe.idp.um.api.infomodel.PermissionInfo;
import com.adobe.idp.um.api.infomodel.ResourceType;
import com.adobe.idp.um.api.infomodel.ResourceTypeSearchFilter;
import com.adobe.idp.um.api.infomodel.User;
import com.adobe.logging.AdobeLogger;
import com.adobe.pof.POFException;
import com.adobe.pof.omapi.POFFilter;
import com.adobe.pof.omapi.POFObjectManager;
import com.adobe.pof.omapi.POFObjectSet;
import com.adobe.pof.omapi.POFQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

public class SecurityProfileManagerServiceImpl
implements SecurityProfileManager {
    protected static final Logger log = AdobeLogger.getLogger(ConnectorRegistryImpl.class.getName());
    private static HashMap m_permsMap = new HashMap(0);
    private static HashMap m_sysPermsMap = new HashMap(0);
    private static String m_sysResourceID;
    private static String m_ResourceID;
    private static SecurityProfileManager INSTANCE;

    private SecurityProfileManagerServiceImpl() {
    }

    public static SecurityProfileManager getInstance() {
        return INSTANCE;
    }

    public PermissionGrant addPermissionGrant(PermissionGrant aPermissionGrant) {
        ArrayList<String> _permList = new ArrayList<String>(1);
        PermissionGrantImpl _grant = null;
        try {
            this.checkPermission("Service Delegate");
            UMFactory _umfactory = UMFactory.getLocalInstance();
            Context _ctx = UMLocalUtils.getSystemContext();
            AuthorizationManager _am = _umfactory.getAuthorizationManager(_ctx);
            String _permId = this.getPermissionId(aPermissionGrant.getPermissionName());
            _permList.add(_permId);
            _am.assignPermToPrincipalForRes(aPermissionGrant.getRefprinid(), aPermissionGrant.getResourceid(), _permList);
            _grant = new PermissionGrantImpl(aPermissionGrant.getRefprinid(), aPermissionGrant.getResourceid(), aPermissionGrant.getPermissionName());
            _grant.setRefpermid(_permId);
            return _grant;
        }
        catch (DSCAuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DSCRuntimeException(e);
        }
    }

    public void deletePermissionGrant(PermissionGrant aPermissionGrant) throws PermissionGrantNotFoundException {
        ArrayList<String> _permList = new ArrayList<String>(1);
        try {
            this.checkPermission("Service Delegate");
            UMFactory _umfactory = UMFactory.getLocalInstance();
            Context _ctx = UMLocalUtils.getSystemContext();
            AuthorizationManager _am = _umfactory.getAuthorizationManager(_ctx);
            String _permId = aPermissionGrant.getRefpermid();
            _permList.add(_permId);
            _am.deletePermsForPrincipalForRes(aPermissionGrant.getRefprinid(), aPermissionGrant.getResourceid(), _permList);
        }
        catch (DSCAuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PermissionGrantNotFoundException(aPermissionGrant.getPermissionName());
        }
    }

    public PermissionGrant getPermissionGrant(PermissionGrant aPermissionGrant) throws PermissionGrantNotFoundException {
        PermissionGrantImpl _grant = null;
        try {
            String _permId = this.getPermissionId(aPermissionGrant.getPermissionName());
            POFObjectManager _om = StoreUtils.getInstance().getPOFObjectManager();
            POFQuery _query = _om.newQuery("user manager", "priresprmentity");
            _query.addFilter("resourceid", 0, aPermissionGrant.getResourceid());
            _query.addFilter("refpermid", 0, _permId);
            _query.addFilter("refprinid", 0, aPermissionGrant.getRefprinid());
            POFObjectSet _os = _om.retrieveObjectSet(_query);
            if (_os.next()) {
                BOIPrincipalResourcePermEntity _boiRecord = (BOIPrincipalResourcePermEntity)_os.getBOIObject();
                _grant = new PermissionGrantImpl(_boiRecord.getRefprinid(), _boiRecord.getResourceid(), aPermissionGrant.getPermissionName());
                _grant.setRefpermid(_boiRecord.getRefpermid());
                _grant.setId(_boiRecord.getId());
                return _grant;
            }
        }
        catch (POFException pe) {
            throw new DSCRuntimeException(pe);
        }
        return null;
    }

    public List getPermissionGrantsForService(Service aService) {
        ArrayList<PermissionGrantImpl> _authList = new ArrayList<PermissionGrantImpl>(0);
        try {
            POFObjectManager _om = StoreUtils.getInstance().getPOFObjectManager();
            POFQuery _query = _om.newQuery("user manager", "priresprmentity");
            POFFilter filter = _query.addFilter("resourceid", 0, aService.getUuid());
            _query.addInnerJoin("perm", "priresprmentity_refpermid_prmentity");
            POFObjectSet _os = _om.retrieveObjectSet(_query);
            while (_os.next()) {
                BOIPrincipalResourcePermEntity _boiRecord = (BOIPrincipalResourcePermEntity)_os.getBOIObject();
                BOIPermissionEntity _perm = (BOIPermissionEntity)_os.getBOIObject("perm");
                if (!TextUtil.contains(PERM_NAMES, _perm.getPermname())) continue;
                PermissionGrantImpl _authRecord = new PermissionGrantImpl(_boiRecord.getRefprinid(), _boiRecord.getResourceid(), _perm.getPermname());
                _authRecord.setRefpermid(_boiRecord.getRefpermid());
                _authRecord.setId(_boiRecord.getId());
                _authList.add(_authRecord);
            }
        }
        catch (POFException pe) {
            throw new DSCRuntimeException(pe);
        }
        return _authList;
    }

    public List getPermissionGrantsForServiceId(String aServiceId) {
        ArrayList<PermissionGrantImpl> _authList = new ArrayList<PermissionGrantImpl>(0);
        try {
            Service _svc = DSContainer.getInstance().getInternalServiceRegistry().getService(aServiceId);
            POFObjectManager _om = StoreUtils.getInstance().getPOFObjectManager();
            POFQuery _query = _om.newQuery("user manager", "priresprmentity");
            POFFilter filter = _query.addFilter("resourceid", 0, _svc.getUuid());
            _query.addInnerJoin("perm", "priresprmentity_refpermid_prmentity");
            POFObjectSet _os = _om.retrieveObjectSet(_query);
            while (_os.next()) {
                BOIPrincipalResourcePermEntity _boiRecord = (BOIPrincipalResourcePermEntity)_os.getBOIObject();
                BOIPermissionEntity _perm = (BOIPermissionEntity)_os.getBOIObject("perm");
                if (!TextUtil.contains(PERM_NAMES, _perm.getPermname())) continue;
                PermissionGrantImpl _authRecord = new PermissionGrantImpl(_boiRecord.getRefprinid(), _boiRecord.getResourceid(), _perm.getPermname());
                _authRecord.setRefpermid(_boiRecord.getRefpermid());
                _authRecord.setId(_boiRecord.getId());
                _authList.add(_authRecord);
            }
        }
        catch (Exception e) {
            throw new DSCRuntimeException(e);
        }
        return _authList;
    }

    public List getPermissionNames() {
        ArrayList<String> _permList = new ArrayList<String>(0);
        for (int i = 0; i < PERM_NAMES.length; i = (int)((short)(i + 1))) {
            _permList.add(PERM_NAMES[i]);
        }
        return _permList;
    }

    public String getPermissionId(String aPermName) {
        SecurityProfileManagerServiceImpl.loadPermissions();
        return (String)m_permsMap.get(aPermName);
    }

    private String findSystemPermissionId(String aPermName) {
        SecurityProfileManagerServiceImpl.loadPermissions();
        return (String)m_sysPermsMap.get(aPermName);
    }

    private static void loadPermissions() {
        try {
            if (!m_permsMap.isEmpty()) {
                return;
            }
            List _resourceTypes = null;
            Context _ctx = UMLocalUtils.getSystemContext();
            UMFactory _umfactory = UMFactory.getLocalInstance();
            AuthorizationManager _authorizationManager = _umfactory.getAuthorizationManager(_ctx);
            DirectoryManager _directoryManager = _umfactory.getDirectoryManager(_ctx);
            SecurityProfileManagerServiceImpl.loadSystemPermissions(_authorizationManager);
            String _resTypeName = "SERVICE";
            ResourceTypeSearchFilter _resourceTypeSearchFilter = new ResourceTypeSearchFilter();
            _resourceTypeSearchFilter.setSpecificResourceTypeName(_resTypeName);
            _resourceTypeSearchFilter.setResultsMax(5);
            _resourceTypeSearchFilter.setSort(ResourceTypeSearchFilter.SORT_ResourceTypeName, true);
            _resourceTypeSearchFilter.setResultsOffset(0);
            _resourceTypes = _authorizationManager.getResourceType(_resourceTypeSearchFilter);
            ResourceType _resourceType = (ResourceType)_resourceTypes.get(0);
            m_ResourceID = _resourceType.getOid();
            List permList = new ArrayList();
            permList = _authorizationManager.getPermissions(m_ResourceID);
            for (Permission _perm : permList) {
                String _permName = _perm.getName();
                if (!TextUtil.contains(PERM_NAMES, _permName)) continue;
                m_permsMap.put(_permName, _perm.getOid());
            }
        }
        catch (Exception e) {
            throw new DSCRuntimeException(e);
        }
    }

    private static void loadSystemPermissions(AuthorizationManager aAuthorizationManager) {
        try {
            if (!m_sysPermsMap.isEmpty()) {
                return;
            }
            List _resourceTypes = null;
            String _resTypeName = "DSC";
            ResourceTypeSearchFilter _resourceTypeSearchFilter = new ResourceTypeSearchFilter();
            _resourceTypeSearchFilter.setSpecificResourceTypeName(_resTypeName);
            _resourceTypeSearchFilter.setResultsMax(5);
            _resourceTypeSearchFilter.setSort(ResourceTypeSearchFilter.SORT_ResourceTypeName, true);
            _resourceTypeSearchFilter.setResultsOffset(0);
            _resourceTypes = aAuthorizationManager.getResourceType(_resourceTypeSearchFilter);
            ResourceType _resourceType = (ResourceType)_resourceTypes.get(0);
            m_sysResourceID = _resourceType.getOid();
            List permList = new ArrayList();
            permList = aAuthorizationManager.getPermissions(m_sysResourceID);
            for (Permission _perm : permList) {
                String _permName = _perm.getName();
                if (!TextUtil.contains(DSCUMConstants.SYSTEM_PERM_NAMES, _permName)) continue;
                m_sysPermsMap.put(_permName, _perm.getOid());
            }
        }
        catch (Exception e) {
            throw new DSCRuntimeException(e);
        }
    }

    public boolean hasSystemPermission(String aPriId, String aPermName) {
        try {
            UMFactory _umfactory = UMFactory.getLocalInstance();
            Context _ctx = InvocationContext.getInstance().getContext();
            AuthorizationManager _am = _umfactory.getAuthorizationManager(_ctx);
            SecurityProfileManagerServiceImpl.loadPermissions();
            PermissionInfo p = _am.hasPermission(aPriId, m_sysResourceID, this.findSystemPermissionId(aPermName));
            return p.hasPermission();
        }
        catch (Exception e) {
            throw new DSCAuthorizationException(e);
        }
    }

    public boolean hasPermission(String aPriId, String aServiceUuid, String aPermName) {
        try {
            UMFactory _umfactory = UMFactory.getLocalInstance();
            Context _ctx = InvocationContext.getInstance().getContext();
            AuthorizationManager _am = _umfactory.getAuthorizationManager(_ctx);
            SecurityProfileManagerServiceImpl.loadPermissions();
            PermissionInfo p = _am.hasPermission(aPriId, aServiceUuid, this.getPermissionId(aPermName));
            return p.hasPermission();
        }
        catch (Exception e) {
            throw new DSCAuthorizationException(e);
        }
    }

    public void checkPermission(String aSysPermType) throws DSCAuthorizationException {
        this.checkPermission(aSysPermType, null, null, null);
    }

    public void checkPermission(String aSysPermType, String aServiceId, String aServiceUuid, String aPermType) throws DSCAuthorizationException {
        InvocationContext _invCtx = InvocationContext.getInstance();
        if (_invCtx != null) {
            User _u;
            Context _ctx = _invCtx.getContext();
            if (_ctx == null) {
                throw new DSCAuthorizationException(aSysPermType);
            }
            if (!UMLocalUtils.isSystemContext((Context)_ctx) && !this.hasSystemPermission((_u = _ctx.getAuthenticatedUser()).getOid(), aSysPermType)) {
                if (aServiceUuid != null && aServiceUuid.length() != 0 && aPermType != null && aPermType.length() != 0) {
                    if (!this.hasPermission(_u.getOid(), aServiceUuid, aPermType)) {
                        throw new DSCAuthorizationException(aSysPermType);
                    }
                } else {
                    throw new DSCAuthorizationException(aSysPermType);
                }
            }
        }
    }

    static {
        INSTANCE = new SecurityProfileManagerServiceImpl();
    }
}

