/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.registry.security.client;

import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.dsc.registry.PermissionGrantNotFoundException;
import com.adobe.idp.dsc.registry.infomodel.PermissionGrant;
import com.adobe.idp.dsc.registry.infomodel.Service;
import com.adobe.idp.dsc.registry.security.SecurityProfileManager;
import com.adobe.logging.AdobeLogger;
import java.util.HashMap;
import java.util.List;

public class SecurityProfileManagerClient
implements SecurityProfileManager {
    private ServiceClientFactory m_serviceClientFactory;
    protected static final AdobeLogger log = AdobeLogger.getAdobeLogger(SecurityProfileManagerClient.class.getName());

    public SecurityProfileManagerClient(ServiceClientFactory clientServiceFactory) {
        this.m_serviceClientFactory = clientServiceFactory;
    }

    public PermissionGrant addPermissionGrant(PermissionGrant aPermissionGrant) {
        try {
            HashMap<String, PermissionGrant> _input = new HashMap<String, PermissionGrant>(1);
            _input.put("permission-grant", aPermissionGrant);
            InvocationResponse _response = this.invoke("addPermissionGrant", _input);
            return (PermissionGrant)_response.getOutputParameter("permission-grant");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DSCRuntimeException(e);
        }
    }

    public void deletePermissionGrant(PermissionGrant aPermissionGrant) throws PermissionGrantNotFoundException {
        try {
            HashMap<String, PermissionGrant> _input = new HashMap<String, PermissionGrant>(1);
            _input.put("permission-grant", aPermissionGrant);
            InvocationResponse invocationResponse = this.invoke("deletePermissionGrant", _input);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DSCRuntimeException(e);
        }
    }

    public PermissionGrant getPermissionGrant(PermissionGrant aPermissionGrant) throws PermissionGrantNotFoundException {
        try {
            HashMap<String, PermissionGrant> _input = new HashMap<String, PermissionGrant>(1);
            _input.put("permission-grant", aPermissionGrant);
            InvocationResponse _response = this.invoke("getPermissionGrant", _input);
            return (PermissionGrant)_response.getOutputParameter("permission-grant");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DSCRuntimeException(e);
        }
    }

    public List getPermissionGrantsForService(Service aService) {
        try {
            HashMap<String, Service> _input = new HashMap<String, Service>(1);
            _input.put("service", aService);
            InvocationResponse _response = this.invoke("getPermissionGrantsForService", _input);
            return (List)_response.getOutputParameter("permission-grants");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DSCRuntimeException(e);
        }
    }

    public List getPermissionGrantsForServiceId(String aServiceId) {
        try {
            HashMap<String, String> _input = new HashMap<String, String>(1);
            _input.put("service-id", aServiceId);
            InvocationResponse _response = this.invoke("getPermissionGrantsForServiceId", _input);
            return (List)_response.getOutputParameter("permission-grants");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DSCRuntimeException(e);
        }
    }

    public List getPermissionNames() {
        try {
            HashMap _input = new HashMap(0);
            InvocationResponse _response = this.invoke("getPermissionNames", _input);
            return (List)_response.getOutputParameter("perm-names");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DSCRuntimeException(e);
        }
    }

    private InvocationResponse invoke(String operationName, HashMap input) throws Exception {
        InvocationRequest _request = this.m_serviceClientFactory.createInvocationRequest("system.security_profile_manager", operationName, input, true);
        return this.m_serviceClientFactory.getServiceClient().invoke(_request);
    }

    public boolean hasSystemPermission(String aPriId, String aPermName) {
        try {
            HashMap<String, String> _input = new HashMap<String, String>(2);
            _input.put("pri-id", aPriId);
            _input.put("perm-name", aPermName);
            InvocationResponse _response = this.invoke("hasSystemPermission", _input);
            Boolean _hasPerm = (Boolean)_response.getOutputParameter("has-permission");
            return _hasPerm;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DSCRuntimeException(e);
        }
    }

    public String getPermissionId(String aPermName) {
        try {
            HashMap<String, String> _input = new HashMap<String, String>(1);
            _input.put("perm-name", aPermName);
            InvocationResponse _response = this.invoke("getPermissionId", _input);
            return (String)_response.getOutputParameter("perm-id");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DSCRuntimeException(e);
        }
    }

    public boolean hasPermission(String aPriId, String aServiceUuid, String aPermName) {
        try {
            HashMap<String, String> _input = new HashMap<String, String>(3);
            _input.put("pri-id", aPriId);
            _input.put("service-uuid", aServiceUuid);
            _input.put("perm-name", aPermName);
            InvocationResponse _response = this.invoke("hasPermission", _input);
            Boolean _hasPerm = (Boolean)_response.getOutputParameter("has-permission");
            return _hasPerm;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DSCRuntimeException(e);
        }
    }
}

