/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.registry.security;

import com.adobe.idp.dsc.registry.PermissionGrantNotFoundException;
import com.adobe.idp.dsc.registry.infomodel.PermissionGrant;
import com.adobe.idp.dsc.registry.infomodel.Service;
import java.util.List;

public interface SecurityProfileManager {
    public static final String SERVICE_ID = "system.security_profile_manager";
    public static final String DSCSERVICE_PERMISSIONS_RESTYPE = "SERVICE";
    public static final String INVOKE_PERM = "INVOKE_PERM";
    public static final String MODIFY_CONFIG_PERM = "MODIFY_CONFIG_PERM";
    public static final String SUPERVISOR_PERM = "SUPERVISOR_PERM";
    public static final String START_STOP_PERM = "START_STOP_PERM";
    public static final String ADD_REMOVE_ENDPOINTS_PERM = "ADD_REMOVE_ENDPOINTS_PERM";
    public static final String CREATE_VERSION_PERM = "CREATE_VERSION_PERM";
    public static final String DELETE_VERSION_PERM = "DELETE_VERSION_PERM";
    public static final String MODIFY_VERSION_PERM = "MODIFY_VERSION_PERM";
    public static final String READ_PERM = "READ_PERM";
    public static final String[] PERM_NAMES = new String[]{"INVOKE_PERM", "MODIFY_CONFIG_PERM", "SUPERVISOR_PERM", "START_STOP_PERM", "ADD_REMOVE_ENDPOINTS_PERM", "CREATE_VERSION_PERM", "DELETE_VERSION_PERM", "MODIFY_VERSION_PERM", "READ_PERM"};
    public static final String[] PERM_DESCS = new String[]{"Allows Invocation of all operations on the Service", "Modify the configuration of the Service", "View process instance data for the Service that has been created from a Process", "Start or Stop the Service.", "Add, remove and modify end points for the Service", "Create a new version of the Service", "Delete a version of the Service", "Modify a version of the Service", "Read or view the Service"};

    public PermissionGrant addPermissionGrant(PermissionGrant var1);

    public void deletePermissionGrant(PermissionGrant var1) throws PermissionGrantNotFoundException;

    public PermissionGrant getPermissionGrant(PermissionGrant var1) throws PermissionGrantNotFoundException;

    public List getPermissionGrantsForService(Service var1);

    public List getPermissionGrantsForServiceId(String var1);

    public List getPermissionNames();

    public String getPermissionId(String var1);

    public boolean hasSystemPermission(String var1, String var2);

    public boolean hasPermission(String var1, String var2, String var3);
}

