/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.registry.propertyeditor.impl;

import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.DSContainer;
import com.adobe.idp.dsc.boi.BOIComponent;
import com.adobe.idp.dsc.boi.BOIPropertyEditor;
import com.adobe.idp.dsc.registry.ComponentNotFoundException;
import com.adobe.idp.dsc.registry.component.impl.ComponentRegistryImpl;
import com.adobe.idp.dsc.registry.impl.StoreUtils;
import com.adobe.idp.dsc.registry.infomodel.Component;
import com.adobe.idp.dsc.registry.infomodel.PropertyEditorComponent;
import com.adobe.idp.dsc.registry.infomodel.impl.CompositeEditorAttributeImpl;
import com.adobe.idp.dsc.registry.infomodel.impl.CompositeEditorComponentImpl;
import com.adobe.idp.dsc.registry.infomodel.impl.CompositeEditorObjectImpl;
import com.adobe.idp.dsc.registry.infomodel.impl.CompositeEditorSimpleAttributeImpl;
import com.adobe.idp.dsc.registry.infomodel.impl.PropertyEditorComponentImpl;
import com.adobe.idp.dsc.registry.infomodel.impl.PropertyEditorImpl;
import com.adobe.idp.dsc.registry.propertyeditor.PropertyEditorStore;
import com.adobe.idp.dsc.registry.propertyeditor.PropertyEditorStoreException;
import com.adobe.idp.dsc.registry.propertyeditor.impl.PropertyEditorRegistryImpl;
import com.adobe.idp.dsc.registry.service.impl.ServiceStoreImpl;
import com.adobe.idp.dsc.util.DOMUtil;
import com.adobe.idp.dsc.util.TextUtil;
import com.adobe.pof.BOIObject;
import com.adobe.pof.POFException;
import com.adobe.pof.omapi.POFObjectManager;
import com.adobe.pof.omapi.POFObjectSet;
import com.adobe.pof.omapi.POFQuery;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.beanutils.PropertyUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class PropertyEditorStoreImpl
implements PropertyEditorStore {
    public static final Logger log = Logger.getLogger(ServiceStoreImpl.class.getName());

    public PropertyEditorComponent getHeadPropertyEditor(String aEditorId) {
        log.log(Level.FINE, "PropertyEditorStoreImpl:getHeadPropertyEditor:" + aEditorId);
        POFObjectManager _om = StoreUtils.getInstance().getPOFObjectManager();
        try {
            POFQuery _qry = _om.newQuery("sc_property_editor");
            _qry.addInnerJoin("component", "component");
            _qry.addFilter("id", 0, aEditorId);
            POFObjectSet _os = _om.retrieveObjectSet(_qry);
            if (_os.next()) {
                BOIPropertyEditor _boiEditor = (BOIPropertyEditor)_os.getBOIObject();
                BOIComponent _boiComp = (BOIComponent)_os.getBOIObject("component");
                return this.createEditorFromBOI(_boiEditor, _boiComp);
            }
            return null;
        }
        catch (POFException e) {
            log.log(Level.SEVERE, "PropertyEditorStoreImpl:getServiceCategory:POFException:" + e.getMessage());
            throw new PropertyEditorStoreException(e);
        }
    }

    public PropertyEditorComponent getPropertyEditor(String aEditorId, int aMajorVersion, int aMinorVersion) {
        log.log(Level.FINE, "PropertyEditorStoreImpl:getPropertyEditor:" + aEditorId);
        POFObjectManager _om = StoreUtils.getInstance().getPOFObjectManager();
        try {
            POFQuery _qry = _om.newQuery("sc_property_editor");
            _qry.addInnerJoin("component", "component");
            _qry.addFilter("id", 0, aEditorId);
            _qry.addFilter("major_version", 0, aMajorVersion);
            _qry.addFilter("minor_version", 0, aMinorVersion);
            POFObjectSet _os = _om.retrieveObjectSet(_qry);
            if (_os.next()) {
                BOIPropertyEditor _boiEditor = (BOIPropertyEditor)_os.getBOIObject();
                BOIComponent _boiComp = (BOIComponent)_os.getBOIObject("component");
                return this.createEditorFromBOI(_boiEditor, _boiComp);
            }
            return null;
        }
        catch (POFException e) {
            log.log(Level.SEVERE, "PropertyEditorStoreImpl:getServiceCategory:POFException:" + e.getMessage());
            throw new PropertyEditorStoreException(e);
        }
    }

    public void createPropertyEditor(Component aComponent, Element aElement) {
        String _id = DOMUtil.getAttributeValue(aElement, "id");
        short _majorVersion = 0;
        short _minorVersion = 0;
        try {
            _majorVersion = Short.parseShort(DOMUtil.getAttributeValue(aElement, "major-version"));
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            _minorVersion = Short.parseShort(DOMUtil.getAttributeValue(aElement, "minor-version"));
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        log.log(Level.FINE, "PropertyEditorStoreImpl:createPropertyEditor: id=" + _id + " major-version=" + _majorVersion + " minor-version=" + _minorVersion);
        ((PropertyEditorRegistryImpl)PropertyEditorRegistryImpl.getInstance()).clearCache();
        POFObjectManager _om = StoreUtils.getInstance().getPOFObjectManager();
        try {
            POFQuery _qry = _om.newQuery("sc_component");
            _qry.addFilter("id", 0, aComponent.getComponentId());
            _qry.addFilter("version", 0, aComponent.getVersion());
            BOIComponent _comp = (BOIComponent)_om.retrieveBOIObject(_qry);
            if (_comp == null) {
                throw new PropertyEditorStoreException("Component: " + aComponent.getComponentId() + " version: " + aComponent.getVersion() + " not found.");
            }
            BOIPropertyEditor _boiEditor = (BOIPropertyEditor)_om.newBOIObject("sc_property_editor");
            _boiEditor.setId(_id);
            _boiEditor.setMajorVersion(_majorVersion);
            _boiEditor.setMinorVersion(_minorVersion);
            _boiEditor.setDescriptor(DOMUtil.toString(aElement));
            _boiEditor.setComponent(_comp);
            _boiEditor = (BOIPropertyEditor)_om.writeObject((BOIObject)_boiEditor);
        }
        catch (POFException e) {
            log.log(Level.SEVERE, "PropertyEditorStoreImpl:createPropertyEditor:POFException:" + e.getMessage());
            throw new PropertyEditorStoreException(e);
        }
    }

    public void removePropertyEditor(PropertyEditorComponent aComp) {
        log.log(Level.FINE, "PropertyEditorStoreImpl:removePropertyEditor:" + (aComp != null ? aComp.getId() : "Null"));
        ((PropertyEditorRegistryImpl)PropertyEditorRegistryImpl.getInstance()).clearCache();
        POFObjectManager _om = StoreUtils.getInstance().getPOFObjectManager();
        try {
            POFQuery _qry = _om.newQuery("sc_property_editor");
            _qry.addFilter("id", 0, aComp.getId());
            _qry.addFilter("major_version", 0, aComp.getMajorVersion());
            _qry.addFilter("minor_version", 0, aComp.getMinorVersion());
            _om.deleteObjects(_qry);
        }
        catch (POFException e) {
            log.log(Level.SEVERE, "PropertyEditorStoreImpl:getServiceCategory:POFException:" + e.getMessage());
            throw new PropertyEditorStoreException(e);
        }
    }

    public void removePropertyEditors(Component aComp) {
        if (aComp == null) {
            return;
        }
        log.log(Level.FINE, "PropertyEditorStoreImpl:removePropertyEditors:component: " + aComp.getComponentId());
        ((PropertyEditorRegistryImpl)PropertyEditorRegistryImpl.getInstance()).clearCache();
        POFObjectManager _om = StoreUtils.getInstance().getPOFObjectManager();
        try {
            POFQuery _qry = _om.newQuery("sc_property_editor");
            _qry.addInnerJoin("comp", "component");
            _qry.addFilter("comp", "id", 0, aComp.getComponentId());
            _qry.addFilter("comp", "version", 0, aComp.getVersion());
            _om.deleteObjects(_qry);
        }
        catch (POFException e) {
            log.log(Level.SEVERE, "PropertyEditorStoreImpl:getServiceCategory:POFException:" + e.getMessage());
            throw new PropertyEditorStoreException(e);
        }
    }

    protected PropertyEditorComponent createEditorFromBOI(BOIPropertyEditor aBoiEditor, BOIComponent aComp) {
        log.log(Level.FINE, "PropertyEditorStoreImpl:createEditorFromBOI:" + aBoiEditor.getId());
        Element _root = null;
        if (aBoiEditor.getDescriptor() != null) {
            try {
                _root = DOMUtil.parseDocumentFromString(aBoiEditor.getDescriptor()).getDocumentElement();
            }
            catch (Throwable ex) {
                log.log(Level.WARNING, "Unable to parse descriptor for property editor: " + aBoiEditor.getId());
                return null;
            }
        }
        try {
            if (_root.getTagName().equals("editor")) {
                PropertyEditorComponentImpl _editor = new PropertyEditorComponentImpl();
                _editor.setOid(aBoiEditor.getOid());
                _editor.setArchiveId(aComp.getArchiveOid());
                _editor.setComponentId(aComp.getId());
                _editor.setComponentVersion(aComp.getVersion());
                _editor.setCreateTime(aBoiEditor.getCreateTime());
                _editor.setUpdateTime(aBoiEditor.getUpdateTime());
                _editor.setId(DOMUtil.getAttributeValue(_root, "id"));
                _editor.setDescription(DOMUtil.getTextForChild(_root, "description"));
                _editor.setSerializerClass(DOMUtil.getTextForChild(_root, "serializer-class"));
                _editor.setConverterClass(DOMUtil.getTextForChild(_root, "converter-class"));
                _editor.setConfigurationType(DOMUtil.getTextForChild(_root, "configuration-type"));
                Element[] _implementationElms = DOMUtil.getChildElements(_root, "ui-component-class");
                HashMap<String, String> _implementationClasses = new HashMap<String, String>(_implementationElms.length);
                for (int i = 0; i < _implementationElms.length; ++i) {
                    String _type = DOMUtil.getAttributeValue(_implementationElms[i], "type");
                    String _class = DOMUtil.getTextForNode(_implementationElms[i]);
                    if (TextUtil.isEmpty(_type) || TextUtil.isEmpty(_class)) continue;
                    _implementationClasses.put(_type, _class);
                }
                _editor.setUIComponentClasses(_implementationClasses);
                _editor.setDescriptor(DOMUtil.toString(_root));
                return _editor;
            }
            CompositeEditorComponentImpl _editor = new CompositeEditorComponentImpl();
            _editor.setOid(aBoiEditor.getOid());
            _editor.setArchiveId(aComp.getArchiveOid());
            _editor.setComponentId(aComp.getId());
            _editor.setComponentVersion(aComp.getVersion());
            _editor.setCreateTime(aBoiEditor.getCreateTime());
            _editor.setUpdateTime(aBoiEditor.getUpdateTime());
            _editor.setId(DOMUtil.getAttributeValue(_root, "id"));
            _editor.setDescription(DOMUtil.getTextForChild(_root, "description"));
            _editor.setConverterClass(DOMUtil.getTextForChild(_root, "converter-class"));
            _editor.setCompositeType(DOMUtil.getTextForChild(_root, "composite-type"));
            Element _attributesElm = DOMUtil.getChildElement(_root, "attributes");
            List _attrLst = null;
            Component component = ((ComponentRegistryImpl)DSContainer.getInstance().getInternalComponentRegistry()).getComponent(aComp.getId(), aComp.getVersion());
            ClassLoader _cl = DSContainer.getInstance().getClassLoaderForComponent(component);
            Class<?> _compositeType = _cl.loadClass(_editor.getCompositeType());
            if (_attributesElm != null) {
                String[] _attrIncludes = TextUtil.split(_attributesElm.getAttribute("includes"), ',');
                _editor.setIncludes(_attrIncludes);
                _attrLst = this.getAttributeList(_compositeType, _attributesElm);
            } else {
                _attrLst = this.getAttributeListFromClass(_compositeType);
            }
            _editor.setAttributes(_attrLst);
            _editor.setDescriptor(DOMUtil.toString(_root));
            return _editor;
        }
        catch (ComponentNotFoundException ex) {
            throw new DSCRuntimeException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    private List getAttributeListFromClass(Class aType) {
        PropertyDescriptor[] _properties = PropertyUtils.getPropertyDescriptors((Class)aType);
        ArrayList<CompositeEditorSimpleAttributeImpl> _attrLst = new ArrayList<CompositeEditorSimpleAttributeImpl>();
        for (int i = 0; i < _properties.length; ++i) {
            PropertyDescriptor _descriptor = _properties[i];
            Class<?> _class = _descriptor.getPropertyType();
            if (_class == Class.class) continue;
            CompositeEditorSimpleAttributeImpl _attr = new CompositeEditorSimpleAttributeImpl();
            _attr.setName(_descriptor.getName());
            _attr.setTitle(_descriptor.getDisplayName());
            _attr.setType(_descriptor.getPropertyType().getName());
            _attr.setProperty(_descriptor.getName());
            _attr.setHint(_descriptor.getShortDescription());
            _attr.setRequired(false);
            _attrLst.add(_attr);
        }
        return _attrLst;
    }

    private Map getPropertyDescriptorMap(Class aType) {
        PropertyDescriptor[] _properties = PropertyUtils.getPropertyDescriptors((Class)aType);
        HashMap<String, PropertyDescriptor> _propMap = new HashMap<String, PropertyDescriptor>(_properties.length);
        for (int i = 0; i < _properties.length; ++i) {
            _propMap.put(_properties[i].getName(), _properties[i]);
        }
        return _propMap;
    }

    private List getAttributeList(Class aType, Element aRoot) {
        Map _propMap = this.getPropertyDescriptorMap(aType);
        ArrayList<CompositeEditorAttributeImpl> _attributes = new ArrayList<CompositeEditorAttributeImpl>();
        Element[] _attributeElms = DOMUtil.getChildElements(aRoot);
        for (int i = 0; i < _attributeElms.length; ++i) {
            CompositeEditorAttributeImpl _attr;
            boolean _attrRequired;
            PropertyDescriptor _descriptor;
            Element _attributeElm = _attributeElms[i];
            String _attrName = _attributeElm.getAttribute("name");
            Attr _titleNode = (Attr)_attributeElm.getAttributes().getNamedItem("title");
            String _attrTitle = null;
            if (_titleNode == null) {
                _attrTitle = _attrName;
            } else {
                _attrTitle = _titleNode.getNodeValue();
                if (_attrTitle == null) {
                    _attrTitle = "";
                }
            }
            String _attrProperty = _attributeElm.getAttribute("property");
            if (TextUtil.isEmpty(_attrProperty)) {
                _attrProperty = _attrName;
            }
            if ((_descriptor = (PropertyDescriptor)_propMap.get(_attrProperty)) == null) {
                log.log(Level.WARNING, "PropertyEditorStoreImpl:getAttributeList Property: " + _attrProperty + " not found.");
                continue;
            }
            Class<?> _attrTypeClass = _descriptor.getPropertyType();
            String _attrType = _attrTypeClass.getName();
            String _attrHint = DOMUtil.getTextForChild(_attributeElm, "hint");
            if (TextUtil.isEmpty(_attrHint)) {
                _attrHint = _attributeElm.getAttribute("hint");
            }
            String _attrRequiredStr = _attributeElm.getAttribute("required");
            String[] _attrSupportedExpressionTypes = TextUtil.split(_attributeElm.getAttribute("supported-expr-types"), ',');
            boolean bl = _attrRequired = !TextUtil.isEmpty(_attrRequiredStr) && _attrRequiredStr.equalsIgnoreCase("true");
            if (_attributeElm.getTagName().equalsIgnoreCase("attribute")) {
                _attr = new CompositeEditorSimpleAttributeImpl();
                _attr.setName(_attrName);
                _attr.setType(_attrType);
                _attr.setTitle(_attrTitle);
                _attr.setProperty(_attrProperty);
                _attr.setHint(_attrHint);
                _attr.setRequired(_attrRequired);
                _attr.setSupportedExpressionTypes(_attrSupportedExpressionTypes);
                Element _propertyEditorElm = DOMUtil.getChildElement(_attributeElm, "property-editor");
                PropertyEditorImpl _attrPropertyEditor = new PropertyEditorImpl();
                if (_propertyEditorElm != null) {
                    _attrPropertyEditor.setEditorId(_propertyEditorElm.getAttribute("editor-id"));
                    Element[] _propertyEditorParamElms = DOMUtil.getChildElements(_propertyEditorElm, "parameter");
                    if (_propertyEditorParamElms != null && _propertyEditorParamElms.length > 0) {
                        HashMap<String, String> _propertyEditorParams = new HashMap<String, String>();
                        for (int k = 0; k < _propertyEditorParamElms.length; ++k) {
                            Element _propertyEditorParamElm = _propertyEditorParamElms[k];
                            String _name = _propertyEditorParamElm.getAttribute("name");
                            String _value = _propertyEditorParamElm.getAttribute("value");
                            if (TextUtil.isEmpty(_name)) continue;
                            _propertyEditorParams.put(_name, _value);
                        }
                        _attrPropertyEditor.setParameters(_propertyEditorParams);
                    }
                }
                ((CompositeEditorSimpleAttributeImpl)_attr).setEditor(_attrPropertyEditor);
                _attributes.add(_attr);
                continue;
            }
            if (!_attributeElm.getTagName().equalsIgnoreCase("composite-object")) continue;
            _attr = new CompositeEditorObjectImpl();
            String[] _attrIncludes = TextUtil.split(_attributeElm.getAttribute("includes"), ',');
            _attr.setType(_attrType);
            _attr.setName(_attrName);
            _attr.setTitle(_attrTitle);
            _attr.setProperty(_attrProperty);
            _attr.setHint(_attrHint);
            _attr.setRequired(_attrRequired);
            ((CompositeEditorObjectImpl)_attr).setAttributes(this.getAttributeList(_attrTypeClass, _attributeElm));
            ((CompositeEditorObjectImpl)_attr).setIncludes(_attrIncludes);
            _attr.setSupportedExpressionTypes(_attrSupportedExpressionTypes);
            _attributes.add(_attr);
        }
        return _attributes;
    }
}

