/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.registry.propertyeditor.impl;

import com.adobe.idp.dsc.DSCException;
import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.DSContainer;
import com.adobe.idp.dsc.propertyeditor.impl.PropertyEditorComponentImpl;
import com.adobe.idp.dsc.propertyeditor.system.SystemPropertyEditorRegistry;
import com.adobe.idp.dsc.registry.DataTypeNotFoundException;
import com.adobe.idp.dsc.registry.PropertyEditorNotFoundException;
import com.adobe.idp.dsc.registry.RegistryException;
import com.adobe.idp.dsc.registry.component.impl.ComponentRegistryImpl;
import com.adobe.idp.dsc.registry.infomodel.Component;
import com.adobe.idp.dsc.registry.infomodel.DataType;
import com.adobe.idp.dsc.registry.infomodel.PropertyEditorComponent;
import com.adobe.idp.dsc.registry.propertyeditor.PropertyEditorRegistry;
import com.adobe.idp.dsc.registry.propertyeditor.PropertyEditorStore;
import com.adobe.idp.dsc.registry.propertyeditor.impl.PropertyEditorStoreImpl;
import com.adobe.idp.dsc.transaction.TransactionCallback;
import com.adobe.idp.dsc.transaction.TransactionContext;
import com.adobe.idp.dsc.transaction.TransactionTemplate;
import com.adobe.idp.dsc.util.TextUtil;
import com.adobe.livecycle.cache.Cache;
import com.adobe.livecycle.cache.CacheActionException;
import com.adobe.livecycle.cache.CacheCreationException;
import com.adobe.livecycle.cache.CacheType;
import com.adobe.livecycle.cache.adapter.CacheAdapterFactory;
import java.util.Map;
import java.util.logging.Logger;

public class PropertyEditorRegistryImpl
implements PropertyEditorRegistry {
    public static final Logger log = Logger.getLogger(PropertyEditorRegistryImpl.class.getName());
    protected PropertyEditorStore m_store = new PropertyEditorStoreImpl();
    private Cache m_pe_cache = null;
    private static PropertyEditorRegistry INSTANCE = new PropertyEditorRegistryImpl();

    private PropertyEditorRegistryImpl() {
    }

    public static PropertyEditorRegistry getInstance() {
        return INSTANCE;
    }

    public PropertyEditorComponent getHeadPropertyEditor(final String aEditorId) throws PropertyEditorNotFoundException {
        PropertyEditorComponent _pe = this.getHeadPropEditorFromCache(aEditorId);
        if (_pe != null) {
            return _pe;
        }
        try {
            TransactionTemplate _tx = DSContainer.getInstance().getTransactionTemplate();
            return (PropertyEditorComponent)_tx.execute(new TransactionCallback(){

                public Object doInTransaction(TransactionContext aCtx) throws RegistryException {
                    PropertyEditorComponent _comp = PropertyEditorRegistryImpl.this.m_store.getHeadPropertyEditor(aEditorId);
                    if (_comp == null) {
                        throw new PropertyEditorNotFoundException(aEditorId);
                    }
                    PropertyEditorRegistryImpl.this.putHeadPropEditorInCache(_comp);
                    return _comp;
                }
            });
        }
        catch (PropertyEditorNotFoundException ex) {
            throw ex;
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public PropertyEditorComponent getPropertyEditor(final String aEditorId, final int aMajorVersion, final int aMinorVersion) throws PropertyEditorNotFoundException {
        PropertyEditorComponent _pe = this.getPropEditorFromCache(aEditorId, aMajorVersion, aMinorVersion);
        if (_pe != null) {
            return _pe;
        }
        try {
            com.adobe.idp.dsc.propertyeditor.PropertyEditorComponent _comp = SystemPropertyEditorRegistry.getInstance().getPropertyEditorById(aEditorId);
            if (_comp != null) {
                return ((PropertyEditorComponentImpl)_comp).getPropertyEditorComponent();
            }
            TransactionTemplate _tx = DSContainer.getInstance().getTransactionTemplate();
            return (PropertyEditorComponent)_tx.execute(new TransactionCallback(){

                public Object doInTransaction(TransactionContext aCtx) throws RegistryException {
                    PropertyEditorComponent _comp = PropertyEditorRegistryImpl.this.m_store.getPropertyEditor(aEditorId, aMajorVersion, aMinorVersion);
                    if (_comp == null) {
                        throw new PropertyEditorNotFoundException(aEditorId, aMajorVersion, aMinorVersion);
                    }
                    PropertyEditorRegistryImpl.this.putPropEditorInCache(_comp);
                    return _comp;
                }
            });
        }
        catch (PropertyEditorNotFoundException ex) {
            throw ex;
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public Map getClientLibAsMap(final String aEditorId, final int aMajorVersion, final int aMinorVersion) throws PropertyEditorNotFoundException {
        try {
            TransactionTemplate _tx = DSContainer.getInstance().getTransactionTemplate();
            return (Map)_tx.execute(new TransactionCallback(){

                public Object doInTransaction(TransactionContext aCtx) throws RegistryException {
                    PropertyEditorComponent _peComp = PropertyEditorRegistryImpl.this.getPropertyEditor(aEditorId, aMajorVersion, aMinorVersion);
                    ComponentRegistryImpl _cr = (ComponentRegistryImpl)DSContainer.getInstance().getInternalComponentRegistry();
                    Component _comp = _cr.getComponent(_peComp.getComponentId(), _peComp.getComponentVersion());
                    return _cr.getClientLibAsMap(_comp, _peComp.getDescriptor());
                }
            });
        }
        catch (PropertyEditorNotFoundException ex) {
            throw ex;
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public PropertyEditorComponent getPropertyEditorForDataType(String aDataTypeId, int aMajorVersion, int aMinorVersion, int aMicroVersion) throws DataTypeNotFoundException {
        DataType _dt = DSContainer.getInstance().getInternalDataTypeRegistry().getDataType(aDataTypeId, aMajorVersion, aMinorVersion);
        String _editorId = _dt.getPropertyEditor().getEditorId();
        if (TextUtil.isEmpty(_editorId)) {
            return null;
        }
        PropertyEditorComponent _pec = null;
        try {
            _pec = this.getHeadPropertyEditor(_editorId);
        }
        catch (PropertyEditorNotFoundException ex) {
            throw new DSCRuntimeException(ex);
        }
        return _pec;
    }

    public PropertyEditorComponent getPropertyEditorForHeadDataType(String aDataTypeId) throws DataTypeNotFoundException {
        DataType _dt = DSContainer.getInstance().getInternalDataTypeRegistry().getHeadDataType(aDataTypeId);
        String _editorId = _dt.getPropertyEditor().getEditorId();
        if (TextUtil.isEmpty(_editorId)) {
            return null;
        }
        PropertyEditorComponent _pec = null;
        try {
            _pec = this.getHeadPropertyEditor(_editorId);
        }
        catch (PropertyEditorNotFoundException ex) {
            throw new DSCRuntimeException(ex);
        }
        return _pec;
    }

    private Cache getCache() {
        if (this.m_pe_cache == null) {
            CacheAdapterFactory _factory = CacheAdapterFactory.getInstance();
            try {
                Cache _cache;
                this.m_pe_cache = _cache = _factory.getCache(CacheType.Partitioned, "ServiceRegistry.PropEditors");
            }
            catch (CacheCreationException e) {
                log.severe("Could not get the Property Editor cache.  " + e.getMessage());
            }
        }
        return this.m_pe_cache;
    }

    private static String getCacheKey(String aPropEditorId, int aMajorVersion, int aMinorVersion) {
        StringBuffer _buff = new StringBuffer(aPropEditorId);
        _buff.append('.');
        _buff.append(aMajorVersion);
        _buff.append('.');
        _buff.append(aMinorVersion);
        return _buff.toString();
    }

    private static String getHeadKey(String aPropEditorId) {
        StringBuffer _buff = new StringBuffer(aPropEditorId);
        _buff.append('.');
        _buff.append("head");
        return _buff.toString();
    }

    protected PropertyEditorComponent getPropEditorFromCache(String aPropEditorId, int aMajorVersion, int aMinorVersion) {
        PropertyEditorComponent _pe = null;
        if (this.getCache() != null) {
            try {
                _pe = (PropertyEditorComponent)this.getCache().get((Object)PropertyEditorRegistryImpl.getCacheKey(aPropEditorId, aMajorVersion, aMinorVersion));
            }
            catch (CacheActionException e) {
                log.severe("Exception thrown while retrieving PropertyEditor: '" + PropertyEditorRegistryImpl.getCacheKey(aPropEditorId, aMajorVersion, aMinorVersion) + "' from the cache:  " + e.getMessage());
            }
        }
        return _pe;
    }

    protected void putPropEditorInCache(PropertyEditorComponent aPropertyEditor) {
        if (this.getCache() != null && aPropertyEditor != null) {
            String _cacheKey = PropertyEditorRegistryImpl.getCacheKey(aPropertyEditor.getId(), aPropertyEditor.getMajorVersion(), aPropertyEditor.getMinorVersion());
            try {
                this.getCache().put((Object)_cacheKey, (Object)aPropertyEditor);
            }
            catch (CacheActionException e) {
                log.severe("Exception thrown while populating PropertyEditor: '" + _cacheKey + "' in the cache:  " + e.getMessage());
            }
        }
    }

    protected void removePropEditorFromCache(PropertyEditorComponent aPropEditor) {
        if (this.getCache() == null || aPropEditor == null) {
            return;
        }
        String _cacheKey = PropertyEditorRegistryImpl.getCacheKey(aPropEditor.getId(), aPropEditor.getMajorVersion(), aPropEditor.getMinorVersion());
        try {
            this.getCache().remove((Object)_cacheKey);
        }
        catch (CacheActionException e) {
            log.severe("Exception thrown while removing PropertyEditor: '" + _cacheKey + "' from the cache:  " + e.getMessage());
        }
        _cacheKey = PropertyEditorRegistryImpl.getHeadKey(aPropEditor.getId());
        try {
            this.getCache().remove((Object)_cacheKey);
        }
        catch (CacheActionException e) {
            log.severe("Exception thrown while removing DataType: '" + _cacheKey + "' from the cache:  " + e.getMessage());
        }
    }

    protected PropertyEditorComponent getHeadPropEditorFromCache(String aPropEditorId) {
        PropertyEditorComponent _pe = null;
        if (this.getCache() != null) {
            try {
                _pe = (PropertyEditorComponent)this.getCache().get((Object)PropertyEditorRegistryImpl.getHeadKey(aPropEditorId));
            }
            catch (CacheActionException e) {
                log.severe("Exception thrown while retrieving Head Property Editor: '" + PropertyEditorRegistryImpl.getHeadKey(aPropEditorId) + "' from the cache:  " + e.getMessage());
            }
        }
        return _pe;
    }

    protected void putHeadPropEditorInCache(PropertyEditorComponent aPropEditor) {
        if (this.getCache() != null && aPropEditor != null) {
            String _cacheKey = PropertyEditorRegistryImpl.getHeadKey(aPropEditor.getId());
            try {
                this.getCache().put((Object)_cacheKey, (Object)aPropEditor);
            }
            catch (CacheActionException e) {
                log.severe("Exception thrown while populating Head Property Editor: '" + _cacheKey + "' in the cache:  " + e.getMessage());
            }
        }
    }

    public void clearCache() {
        if (this.getCache() != null) {
            try {
                this.getCache().clear();
            }
            catch (CacheActionException e) {
                log.severe("Exception thrown while clearing Property Editor Cache: " + e.getMessage());
            }
        }
    }
}

